/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.table;

import com.dd.xog.saaj.table.IXogTableModel;
import com.dd.xog.saaj.table.XOGRow;
import java.io.File;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class XogResultsTableModel
extends AbstractTableModel
implements IXogTableModel {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(XogResultsTableModel.class);
    ArrayList<XOGRow> xogTable = new ArrayList();
    public static final String NAME = "XogResults";
    private static final String[] COLUMNS = new String[]{" ", "Status", "File", "Inserts", "Updates", "Failures"};

    public XogResultsTableModel() {
    }

    public XogResultsTableModel(ArrayList<XOGRow> xogTable) {
        this.xogTable = xogTable;
    }

    public void setXogTable(ArrayList<XOGRow> xogTable) {
        this.xogTable = xogTable;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public int getRowCount() {
        if (this.xogTable != null) {
            return this.xogTable.size();
        }
        return 0;
    }

    public int getSelCount() {
        int selCount = 0;
        if (this.xogTable != null) {
            int i = 0;
            int size = this.getRowCount();
            while (i < size) {
                if (this.xogTable.get(i).isSelected()) {
                    ++selCount;
                }
                ++i;
            }
        }
        return selCount;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            return true;
        }
        return col == 2;
    }

    public Class getColumnClass(int col) {
        return XOGRow.class;
    }

    @Override
    public Object getValueAt(int row, int col) {
        XOGRow xogRow = this.xogTable.get(row);
        return xogRow;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            this.xogTable.get(row).setSelected((Boolean)value);
        } else if (col == 1) {
            this.xogTable.get(row).setStatus((Integer)value);
        } else if (col == 2) {
            this.xogTable.get(row).setFInput((File)value);
        } else if (col == 3) {
            this.xogTable.get(row).setFOutput((File)value);
        }
        this.fireTableCellUpdated(row, col);
    }

    public void addRow(XOGRow row) {
        this.xogTable.add(row);
        this.fireTableRowsInserted(0, this.xogTable.size() - 1);
    }

    @Override
    public String getColumnName(int col) {
        return COLUMNS[col];
    }

    public XOGRow getNodeAt(int selectedRow) {
        if (selectedRow > -1) {
            return this.xogTable.get(selectedRow);
        }
        return null;
    }

    @Override
    public ArrayList<XOGRow> getXogTable() {
        return this.xogTable;
    }
}

