/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.table;

import com.dd.xog.saaj.gui.animate.AnimatedIcon;
import com.dd.xog.saaj.resources.ResourceLoader;
import com.dd.xog.saaj.table.XOGRow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class FileTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    public final Icon VIEW_ICON = new ImageIcon(ResourceLoader.class.getResource("view.png"));
    public static Icon LOADING_ICON = new AnimatedIcon(new ImageIcon(ResourceLoader.class.getResource("anim.gif")));

    public FileTableCellRenderer() {
        this.setFont(new Font("Helvetia", 0, 12));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        XOGRow xogRow = (XOGRow)value;
        Component comp = super.getTableCellRendererComponent(table, "text", isSelected, hasFocus, row, column);
        if (column == 2) {
            if (xogRow.getFInput() != null) {
                this.setText(xogRow.getFInput().getName());
                this.setToolTipText(xogRow.getFInput().getAbsolutePath());
            } else {
                this.setText("");
                this.setToolTipText(null);
            }
        } else if (column == 3) {
            if (xogRow.getFOutput() != null) {
                this.setText(xogRow.getFOutput().getName());
                this.setToolTipText(xogRow.getFOutput().getAbsolutePath());
            } else {
                this.setText("");
                this.setToolTipText(null);
            }
        }
        if (!isSelected) {
            Color c = table.getBackground();
            if (row % 2 != 0) {
                c = table.getBackground();
            } else {
                c = UIManager.getColor("Table.alternateRowColor");
                if (c == null) {
                    c = UIManager.getColor("Table.light");
                }
                if (c == null) {
                    c = new Color(245, 245, 245);
                }
            }
            Color bg = new Color(c.getRed(), c.getGreen(), c.getBlue());
            comp.setForeground(table.getForeground());
            comp.setBackground(bg);
        }
        return comp;
    }
}

