/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.table;

import com.dd.handler.ContentHandler;
import com.dd.handler.PlugInManager;
import com.dd.sources.Source;
import com.dd.xog.saaj.resources.ResourceLoader;
import com.dd.xog.saaj.table.IXogTableModel;
import com.dd.xog.saaj.table.XOGRow;
import com.dd.xog.saaj.xog.XOGresult;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JTable;

public class ExportResultAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private JTable progressTable = null;

    public ExportResultAction(JTable progressTable) {
        super("Export results");
        this.progressTable = progressTable;
        URL url = ResourceLoader.class.getResource("icon24/export.png");
        if (url != null) {
            this.putValue("SmallIcon", new ImageIcon(url));
        }
        this.putValue("ShortDescription", "Export results to editor");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        StringBuffer totalResults = new StringBuffer();
        totalResults.append("file in;file out;" + XOGresult.getDelimitedNames(';') + "\n");
        ArrayList<XOGRow> list = ((IXogTableModel)((Object)this.progressTable.getModel())).getXogTable();
        for (XOGRow row : list) {
            File fOut = row.getFOutput();
            totalResults.append(String.valueOf(row.getFInput().getName()) + ";" + (fOut != null ? fOut.getName() : "") + ";" + (row.getXogResult() != null ? row.getXogResult().toDelimitedValues(';') : ";;;") + "\n");
        }
        this.openEditor(totalResults);
    }

    private void openEditor(StringBuffer totalResults) {
        PlugInManager contentManager = PlugInManager.getInstance();
        ContentHandler contentHandler = contentManager.getContentHandler("txt");
        Source source = contentHandler.getSource();
        source.setName("xogresults");
        source.setContents(totalResults.toString());
        source.addProperty((Object)"key1", (Object)"this is important info");
        contentHandler.open(source);
        source.setChanged(true);
    }
}

