/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.table;

import com.dd.xog.saaj.resources.ResourceLoader;
import com.dd.xog.saaj.table.XOGRow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class CheckListButtonTableRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    JPanel panel = new JPanel(){

        @Override
        public String getToolTipText(MouseEvent e) {
            if (CheckListButtonTableRenderer.this.actionPane.getBounds().contains(e.getPoint())) {
                return CheckListButtonTableRenderer.this.actionPane.getToolTipText();
            }
            return CheckListButtonTableRenderer.this.actionPane.getToolTipText();
        }
    };
    JPanel actionPane = new JPanel();
    public final Icon VIEW_ICON = new ImageIcon(ResourceLoader.class.getResource("view.png"));
    private JButton pageViewButton = new JButton(this.VIEW_ICON);

    public CheckListButtonTableRenderer() {
        this.panel.setLayout(new BorderLayout());
        this.actionPane.setLayout(new FlowLayout(0, 2, 0));
        this.pageViewButton.setFocusable(false);
        this.pageViewButton.setFocusPainted(false);
        this.pageViewButton.setPreferredSize(new Dimension(16, 16));
        this.pageViewButton.setBorder(BorderFactory.createEmptyBorder());
        this.pageViewButton.setMargin(new Insets(0, 0, 0, 0));
        this.pageViewButton.setBorderPainted(false);
        this.pageViewButton.setContentAreaFilled(false);
        this.pageViewButton.setOpaque(false);
        this.setFont(new Font("Helvetia", 0, 12));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        XOGRow xogRow = (XOGRow)value;
        Component comp = super.getTableCellRendererComponent(table, "text", isSelected, hasFocus, row, column);
        File file = null;
        if (column == 2) {
            file = xogRow.getFInput();
        } else if (column == 3) {
            file = xogRow.getFOutput();
        }
        if (file != null) {
            this.setText(file.getName());
            this.setToolTipText(file.getAbsolutePath());
        } else {
            this.setText("");
            this.setToolTipText(null);
        }
        this.panel.removeAll();
        this.panel.add(comp, "Center");
        this.panel.setOpaque(false);
        this.actionPane.removeAll();
        if (file != null) {
            this.actionPane.add(this.pageViewButton);
        }
        this.actionPane.setToolTipText(null);
        this.panel.add((Component)this.actionPane, "East");
        if (isSelected) {
            this.panel.setForeground(table.getSelectionForeground());
            this.panel.setBackground(table.getSelectionBackground());
            comp.setForeground(table.getSelectionForeground());
            comp.setBackground(table.getSelectionBackground());
            this.actionPane.setBackground(table.getSelectionBackground());
        } else {
            Color c = table.getBackground();
            if (row % 2 != 0) {
                c = table.getBackground();
            } else {
                c = UIManager.getColor("Table.alternateRowColor");
                if (c == null) {
                    c = UIManager.getColor("Table.light");
                }
                if (c == null) {
                    c = table.getBackground();
                }
            }
            Color bg = new Color(c.getRed(), c.getGreen(), c.getBlue());
            this.panel.setForeground(table.getForeground());
            this.panel.setBackground(bg);
            comp.setForeground(table.getForeground());
            comp.setBackground(bg);
            this.actionPane.setBackground(bg);
        }
        return this.panel;
    }
}

