/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.table;

import com.dd.gui.components.Frame;
import com.dd.handler.ContentHandler;
import com.dd.handler.PlugInManager;
import com.dd.sources.Source;
import com.dd.xml.sources.XMLSource;
import com.dd.xog.saaj.io.FileUtil;
import com.dd.xog.saaj.resources.ResourceLoader;
import com.dd.xog.saaj.table.XOGRow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellEditor;
import org.apache.log4j.Logger;

public class CheckListButtonTableEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    public final Icon VIEW_ICON = new ImageIcon(ResourceLoader.class.getResource("view.png"));
    private JButton pageViewButton = new JButton(this.VIEW_ICON);
    JPanel panel = new JPanel();
    JPanel actionPane = new JPanel();
    int currentColumn;
    XOGRow xogRow = null;
    static Logger logger = Logger.getLogger(CheckListButtonTableEditor.class);

    public CheckListButtonTableEditor() {
        this.panel.setLayout(new BorderLayout());
        this.pageViewButton.setFocusable(false);
        this.pageViewButton.setFocusPainted(false);
        this.pageViewButton.setPreferredSize(new Dimension(16, 16));
        this.pageViewButton.setBorder(BorderFactory.createEmptyBorder());
        this.pageViewButton.setMargin(new Insets(0, 0, 0, 0));
        this.pageViewButton.setContentAreaFilled(false);
        this.pageViewButton.addActionListener(this);
        this.actionPane.setLayout(new FlowLayout(0, 2, 0));
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.xogRow = (XOGRow)value;
        this.currentColumn = column;
        JLabel label = new JLabel();
        label.setBorder(BorderFactory.createEmptyBorder());
        File file = null;
        if (column == 2) {
            file = this.xogRow.getFInput();
            logger.debug((Object)("file input " + this.xogRow.getFInput()));
        } else if (column == 3) {
            file = this.xogRow.getFOutput();
            logger.debug((Object)("file output " + this.xogRow.getFInput()));
        }
        if (file != null) {
            label.setText(file.getName());
        } else {
            label.setText("");
        }
        this.panel.removeAll();
        this.panel.add((Component)label, "Center");
        this.panel.setOpaque(true);
        this.panel.setToolTipText(null);
        this.actionPane.removeAll();
        this.actionPane.add(this.pageViewButton);
        this.actionPane.setFocusable(true);
        this.panel.add((Component)this.actionPane, "East");
        this.panel.setToolTipText(null);
        Color c = table.getSelectionBackground();
        c = table.getSelectionBackground();
        Color bg = new Color(c.getRed(), c.getGreen(), c.getBlue());
        this.panel.setForeground(table.getSelectionForeground());
        this.panel.setBackground(bg);
        label.setForeground(table.getSelectionForeground());
        label.setBackground(bg);
        this.actionPane.setBackground(bg);
        return this.panel;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.currentColumn == 2) {
            return this.xogRow.getFInput();
        }
        if (this.currentColumn == 3) {
            return this.xogRow.getFOutput();
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File f = null;
        if (this.currentColumn == 2) {
            f = this.xogRow.getFInput();
        } else if (this.currentColumn == 3) {
            f = this.xogRow.getFOutput();
        }
        if (f != null) {
            this.openContentInEditor(f);
        }
        this.stopCellEditing();
    }

    public void openInOptionPane(File f) {
        JTextArea textArea = new JTextArea();
        textArea.setFont(new Font("Sans-Serif", 0, 10));
        textArea.setEditable(false);
        textArea.setText(FileUtil.readFileToString(f, "UTF-8"));
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(400, 240));
        JOptionPane.showMessageDialog(null, scrollPane, "title", 1);
    }

    public void openInEditor(File f) {
        PlugInManager contentManager = PlugInManager.getInstance();
        ContentHandler contentHandler = contentManager.getContentHandler("xml");
        Source source = contentHandler.getSource();
        contentHandler.open(f);
        Frame.getInstance().toFront();
    }

    public void openContentInEditor(File f) {
        PlugInManager contentManager = PlugInManager.getInstance();
        ContentHandler contentHandler = contentManager.getContentHandler("xml");
        if (contentHandler != null) {
            XMLSource source = new XMLSource(f);
            source.setFileEncoding("UTF-8");
            source.setEndOfLineString(System.getProperty("line.separator"));
            source.setContents(FileUtil.readFileToString(f, "UTF-8"));
            contentHandler.open((Source)source);
            Frame.getInstance().toFront();
        }
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        if (evt instanceof MouseEvent) {
            int clickCount = 1;
            return ((MouseEvent)evt).getClickCount() >= clickCount;
        }
        return true;
    }
}

