/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.table;

import com.dd.xog.saaj.table.XOGRow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class CheckBoxCellRenderer
extends DefaultTableCellRenderer {
    private JCheckBox renderer;
    private JPanel pane;
    private static final long serialVersionUID = 1L;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.pane = new JPanel();
        this.renderer = new JCheckBox();
        this.pane.setLayout(new BorderLayout());
        this.pane.setOpaque(true);
        XOGRow xogRow = (XOGRow)value;
        if (xogRow != null) {
            this.renderer.setSelected(xogRow.isSelected());
        }
        if (isSelected) {
            this.pane.setForeground(table.getSelectionForeground());
            this.pane.setBackground(table.getSelectionBackground());
            this.renderer.setBackground(table.getSelectionBackground());
        } else {
            Color c = this.getBackground();
            if (row % 2 != 0) {
                c = table.getBackground();
            } else {
                c = UIManager.getColor("Table.alternateRowColor");
                if (c == null) {
                    c = UIManager.getColor("Table.light");
                }
                if (c == null) {
                    c = new Color(245, 245, 245);
                }
            }
            Color bg = new Color(c.getRed(), c.getGreen(), c.getBlue());
            this.pane.setForeground(table.getForeground());
            this.pane.setBackground(bg);
            this.renderer.setBackground(bg);
        }
        this.pane.add((Component)this.renderer, "Center");
        return this.pane;
    }
}

