/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.ssl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class StoreCertTrustManager
implements X509TrustManager {
    private TrustManager tm = null;
    private final char[] keyStorePassword = new String("changeit").toCharArray();
    private final String keyStorePath = String.valueOf(System.getProperty("user.home")) + "/https-keystore";
    FileInputStream keyStoreIStream = null;
    private KeyStore keyStore = null;
    private static Logger log = Logger.getLogger(StoreCertTrustManager.class);

    public StoreCertTrustManager() throws Exception {
        try {
            File httpsKeyStore = new File(this.keyStorePath);
            if (httpsKeyStore.exists()) {
                System.setProperty("javax.net.ssl.trustStore", this.keyStorePath);
            }
        }
        catch (SecurityException httpsKeyStore) {
            // empty catch block
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
        tmf.init((KeyStore)null);
        this.tm = tmf.getTrustManagers()[0];
        if (this.tm == null) {
            throw new SSLException("Could not get default TrustManager instance.");
        }
        try {
            this.keyStoreIStream = new FileInputStream(this.keyStorePath);
        }
        catch (FileNotFoundException fne) {
            this.keyStoreIStream = null;
        }
        try {
            log.debug((Object)("KeyStore.getDefaultType " + KeyStore.getDefaultType()));
            this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.keyStore.load(this.keyStoreIStream, this.keyStorePassword);
        }
        catch (KeyStoreException ke) {
            log.debug((Object)("Loading of https keystore from file failed. error message: " + ke.getMessage()));
            this.keyStore = null;
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        ((X509TrustManager)this.tm).checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(final X509Certificate[] chain, String authType) throws CertificateException {
        log.debug((Object)"got X509 certificate from server:");
        int i = 0;
        while (i < chain.length) {
            log.debug((Object)("chain[" + i + "]: " + chain[i].getIssuerDN().getName()));
            ++i;
        }
        try {
            log.debug((Object)("used tm = " + this.tm));
            ((X509TrustManager)this.tm).checkServerTrusted(chain, authType);
        }
        catch (CertificateException ce) {
            log.debug((Object)("in checkServerTrusted: authType: " + authType + ", got certificate exception: " + ce.getMessage()));
            if (this.keyStore == null || chain == null || chain.length == 0) {
                throw ce;
            }
            try {
                boolean trustCert = false;
                final boolean[] trustCertArray = new boolean[1];
                if (SwingUtilities.isEventDispatchThread()) {
                    AskForTrustability ask = new AskForTrustability(chain);
                    trustCertArray[0] = ask.showCertificateAndGetDecision();
                } else {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            AskForTrustability ask = new AskForTrustability(chain);
                            trustCertArray[0] = ask.showCertificateAndGetDecision();
                        }
                    });
                }
                trustCert = trustCertArray[0];
                log.info((Object)("certificate trusted " + trustCert));
                if (trustCert) {
                    int i2 = 0;
                    while (i2 < chain.length) {
                        this.keyStore.setCertificateEntry(chain[i2].getSubjectDN().toString(), chain[i2]);
                        ++i2;
                    }
                    FileOutputStream keyStoreOStream = new FileOutputStream(this.keyStorePath);
                    this.keyStore.store(keyStoreOStream, this.keyStorePassword);
                    keyStoreOStream.close();
                    keyStoreOStream = null;
                    log.debug((Object)("Keystore saved in " + this.keyStorePath));
                }
                throw ce;
            }
            catch (Exception ge) {
                log.debug((Object)("in checkServerTrusted: got exception type: " + ge.getClass() + " message: " + ge.getMessage()));
                throw ce;
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] cf;
        X509Certificate[] allCfs = cf = ((X509TrustManager)this.tm).getAcceptedIssuers();
        log.debug((Object)"getAcceptedIssuers");
        if (this.keyStore != null) {
            try {
                Enumeration<String> ownCerts = this.keyStore.aliases();
                Vector<Certificate> certsVect = new Vector<Certificate>();
                while (ownCerts.hasMoreElements()) {
                    String cert = ownCerts.nextElement();
                    certsVect.add(this.keyStore.getCertificate(cert.toString()));
                }
                int newLength = cf.length + certsVect.size();
                allCfs = new X509Certificate[newLength];
                Iterator it = certsVect.iterator();
                int i = 0;
                while (i < newLength) {
                    if (i < cf.length) {
                        allCfs[i] = cf[i];
                    } else {
                        Object object = it.next();
                        allCfs[i] = (X509Certificate)object;
                    }
                    ++i;
                }
            }
            catch (KeyStoreException ownCerts) {
                // empty catch block
            }
        }
        int i = 0;
        while (i < allCfs.length) {
            log.debug((Object)("allCfs[" + i + "]: " + allCfs[i].getIssuerDN()));
            ++i;
        }
        return allCfs;
    }

    class AskForTrustability
    implements ActionListener,
    ListSelectionListener {
        private JButton yes = new JButton("Yes");
        private JButton no = new JButton("No");
        private boolean isTrusted = false;
        private JDialog trust = null;
        private JList certItems = null;
        private JTextArea certValues = null;
        private JComboBox certChain = null;
        private final String[] certParms = new String[]{"Version", "Serial Number", "Signature Algorithm", "Issuer", "Validity Period", "Subject", "Signature", "Certificate Fingerprint"};
        private X509Certificate[] chain;
        private int chainIdx = 0;

        AskForTrustability(X509Certificate[] chain) {
            this.chain = chain;
        }

        public boolean showCertificateAndGetDecision() {
            if (this.chain == null || this.chain.length == 0) {
                return false;
            }
            this.trust = new JDialog(null, "Untrusted server certificate for SSL connection", true);
            Container cont = this.trust.getContentPane();
            GridBagLayout gl = new GridBagLayout();
            cont.setLayout(gl);
            JPanel pLabel = new JPanel(new BorderLayout());
            Icon icon = UIManager.getIcon("OptionPane.warningIcon");
            pLabel.add((Component)new JLabel(icon), "West");
            JTextArea label = new JTextArea("The certificate sent by the server is unknown and not trustable!\nDo you want to continue creating a SSL connection to that server ?\n\nNote: If you answer 'Yes' the certificate will be stored in the file\n\n" + StoreCertTrustManager.this.keyStorePath + "\n\n" + "and the next time treated trustable automatically. If you want to remove\n" + "the certificate delete the file or use keytool to remove certificates\n" + "selectively.");
            label.setEditable(false);
            label.setBackground(cont.getBackground());
            label.setFont(label.getFont().deriveFont(1));
            pLabel.add((Component)label, "East");
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            gl.setConstraints(pLabel, gc);
            pLabel.setBorder(new EmptyBorder(4, 4, 4, 4));
            cont.add(pLabel);
            Vector<String> choices = new Vector<String>();
            int i = 0;
            while (i < this.chain.length) {
                choices.add(String.valueOf(i + 1) + ". certificate of chain");
                ++i;
            }
            this.certChain = new JComboBox(choices);
            this.certChain.setBackground(cont.getBackground());
            this.certChain.setFont(label.getFont().deriveFont(1));
            this.certChain.addActionListener(this);
            JPanel pChoice = new JPanel(new BorderLayout());
            pChoice.add(this.certChain);
            gc = new GridBagConstraints();
            gc.fill = 2;
            gc.insets = new Insets(4, 4, 4, 4);
            gc.gridy = 1;
            gl.setConstraints(pChoice, gc);
            pChoice.setBorder(new TitledBorder(new EmptyBorder(0, 0, 0, 0), "Certificate chain"));
            cont.add(pChoice);
            this.certItems = new JList<String>(this.certParms);
            this.certItems.setSelectionMode(0);
            this.certItems.addListSelectionListener(this);
            JPanel pList = new JPanel(new BorderLayout());
            pList.add(this.certItems);
            pList.setBorder(new TitledBorder(new EtchedBorder(), "Certificate variables"));
            gc = new GridBagConstraints();
            gc.fill = 2;
            gc.insets = new Insets(4, 4, 4, 4);
            gc.gridy = 2;
            gl.setConstraints(pList, gc);
            cont.add(pList);
            this.certValues = new JTextArea();
            this.certValues.setFont(label.getFont().deriveFont(1));
            this.certValues.setEditable(false);
            this.certValues.setBackground(cont.getBackground());
            this.certValues.setLineWrap(true);
            this.certValues.setWrapStyleWord(true);
            JPanel pVals = new JPanel(new BorderLayout());
            pVals.add(this.certValues);
            pVals.setBorder(new TitledBorder(new EtchedBorder(), "Variable value"));
            gc = new GridBagConstraints();
            gc.insets = new Insets(4, 4, 4, 4);
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            gc.fill = 1;
            gc.gridy = 3;
            gl.setConstraints(pVals, gc);
            cont.add(pVals);
            JPanel p = new JPanel();
            this.yes.addActionListener(this);
            this.no.addActionListener(this);
            p.add(this.yes);
            p.add(this.no);
            gc = new GridBagConstraints();
            gc.weightx = 1.0;
            gc.fill = 2;
            gc.gridy = 4;
            gl.setConstraints(p, gc);
            cont.add(p);
            this.certItems.setSelectedIndex(5);
            this.certItems.requestFocus();
            this.trust.pack();
            this.trust.setSize(500, 600);
            this.trust.setVisible(true);
            return this.isTrusted;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            JList theList = (JList)e.getSource();
            if (theList.isSelectionEmpty()) {
                this.certValues.setText("");
            } else {
                String selVal = theList.getSelectedValue().toString();
                if (selVal.equals("Version")) {
                    this.certValues.setText(String.valueOf(this.chain[this.chainIdx].getVersion()));
                } else if (selVal.equals("Serial Number")) {
                    this.certValues.setText(this.byteArrayToHex(this.chain[this.chainIdx].getSerialNumber().toByteArray()));
                } else if (selVal.equals("Signature Algorithm")) {
                    this.certValues.setText(this.chain[this.chainIdx].getSigAlgName());
                } else if (selVal.equals("Issuer")) {
                    this.certValues.setText(this.chain[this.chainIdx].getIssuerDN().getName());
                } else if (selVal.equals("Validity Period")) {
                    this.certValues.setText(String.valueOf(this.chain[this.chainIdx].getNotBefore().toString()) + " - " + this.chain[this.chainIdx].getNotAfter().toString());
                } else if (selVal.equals("Subject")) {
                    this.certValues.setText(this.chain[this.chainIdx].getSubjectDN().getName());
                } else if (selVal.equals("Signature")) {
                    this.certValues.setText(this.byteArrayToHex(this.chain[this.chainIdx].getSignature()));
                } else if (selVal.equals("Certificate Fingerprint")) {
                    try {
                        this.certValues.setText(String.valueOf(this.getFingerprint(this.chain[this.chainIdx].getEncoded(), "MD5")) + "\n" + this.getFingerprint(this.chain[this.chainIdx].getEncoded(), "SHA1"));
                    }
                    catch (Exception fingerE) {
                        this.certValues.setText("Couldn't calculate fingerprints of the certificate.\nReason: " + fingerE.getMessage());
                    }
                }
            }
        }

        private String getFingerprint(byte[] certificateBytes, String algorithm) throws Exception {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(certificateBytes);
            byte[] digest = md.digest();
            return new String(String.valueOf(algorithm) + ": " + this.byteArrayToHex(digest));
        }

        private String byteArrayToHex(byte[] byteData) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < byteData.length) {
                int b;
                String hex;
                if (i != 0) {
                    sb.append(":");
                }
                if ((hex = Integer.toHexString(b = byteData[i] & 0xFF)).length() == 1) {
                    sb.append("0");
                }
                sb.append(hex);
                ++i;
            }
            return sb.toString();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object entry = e.getSource();
            if (entry.equals(this.yes)) {
                this.isTrusted = true;
                this.trust.dispose();
            } else if (entry.equals(this.certChain)) {
                int selIndex = this.certChain.getSelectedIndex();
                if (selIndex >= 0 && selIndex < this.chain.length) {
                    this.chainIdx = selIndex;
                    int oldSelIdx = this.certItems.getSelectedIndex();
                    this.certItems.clearSelection();
                    this.certItems.setSelectedIndex(oldSelIdx);
                }
            } else {
                this.trust.dispose();
            }
        }
    }
}

