/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.preferences;

import com.dd.xog.saaj.common.xml.XMLWriter;
import com.dd.xog.saaj.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.digester.Digester;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class PlugInPreferences {
    private String lastMultipleInputDir = null;
    private String lastMultipleOutputDir = null;
    private String xogPrefix = "";
    private String xogPostfix = "_xogout";
    private String lastListXogResultDir = null;
    private File fPrefs = null;
    private static PlugInPreferences preferences = null;
    private static Logger log = Logger.getLogger(PlugInPreferences.class);

    public String toXml(int level, boolean doLineBreak) {
        StringBuffer sb = new StringBuffer();
        if (doLineBreak) {
            XMLWriter.doLineAndIndent(sb, level);
        } else {
            XMLWriter.doIndent(sb, level);
        }
        sb.append("<preferences>");
        if (this.lastMultipleInputDir != null) {
            XMLWriter.doLineAndIndent(sb, level + 1);
            sb.append(XMLWriter.normalizeAndPrint("lastMultipleInputDir", this.lastMultipleInputDir));
        }
        if (this.lastMultipleOutputDir != null) {
            XMLWriter.doLineAndIndent(sb, level + 1);
            sb.append(XMLWriter.normalizeAndPrint("lastMultipleOutputDir", this.lastMultipleOutputDir));
        }
        XMLWriter.doLineAndIndent(sb, level + 1);
        sb.append(XMLWriter.normalizeAndPrint("xogPrefix", this.xogPrefix));
        XMLWriter.doLineAndIndent(sb, level + 1);
        sb.append(XMLWriter.normalizeAndPrint("xogPostfix", this.xogPostfix));
        if (this.lastListXogResultDir != null) {
            XMLWriter.doLineAndIndent(sb, level + 1);
            sb.append(XMLWriter.normalizeAndPrint("lastListXogResultDir", this.lastListXogResultDir));
        }
        XMLWriter.doLineAndIndent(sb, level);
        sb.append("</preferences>");
        return sb.toString();
    }

    public void store(File f) {
        if (f != null) {
            FileUtil.writeToFile(f, this.toXml(0, false));
        }
    }

    private PlugInPreferences(final File file) {
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new Thread(){

            @Override
            public void run() {
                PlugInPreferences.this.store(file);
            }
        });
        this.fPrefs = file;
        if (file != null && file.exists()) {
            Digester digester = new Digester();
            digester.push((Object)this);
            digester.addBeanPropertySetter("preferences/lastMultipleInputDir");
            digester.addBeanPropertySetter("preferences/lastMultipleOutputDir");
            digester.addBeanPropertySetter("preferences/xogPrefix");
            digester.addBeanPropertySetter("preferences/xogPostfix");
            digester.addBeanPropertySetter("preferences/lastListXogResultDir");
            try {
                digester.parse(this.fPrefs);
            }
            catch (IOException e) {
                log.error((Object)"PlugIn preferences could not be loaded", (Throwable)e);
            }
            catch (SAXException e) {
                log.error((Object)"PlugIn preferences could not be loaded", (Throwable)e);
            }
        }
    }

    public static synchronized PlugInPreferences loadPreferences(File f) {
        if (preferences == null) {
            preferences = new PlugInPreferences(f);
        }
        return preferences;
    }

    public static synchronized PlugInPreferences getInstance() {
        if (preferences == null) {
            String name = "com.dd.xog.saaj.PlugInPreferences.prefs";
            File fPref = new File(FileUtil.getHomeDir(), name);
            preferences = new PlugInPreferences(fPref);
        }
        return preferences;
    }

    private PlugInPreferences() {
    }

    public String getLastMultipleInputDir() {
        return this.lastMultipleInputDir;
    }

    public void setLastMultipleInputDir(String lastMultipleInputDir) {
        this.lastMultipleInputDir = lastMultipleInputDir;
    }

    public String getLastMultipleOutputDir() {
        return this.lastMultipleOutputDir;
    }

    public void setLastMultipleOutputDir(String lastMultipleOutputDir) {
        this.lastMultipleOutputDir = lastMultipleOutputDir;
    }

    public String getXogPrefix() {
        return this.xogPrefix;
    }

    public void setXogPrefix(String xogPrefix) {
        this.xogPrefix = xogPrefix;
    }

    public String getXogPostfix() {
        return this.xogPostfix;
    }

    public void setXogPostfix(String xogPostfix) {
        this.xogPostfix = xogPostfix;
    }

    public static void main(String[] args) throws Exception {
        String name = "csvexcel.prefs";
        File f = new File(FileUtil.getHomeDir(), name);
        boolean init = false;
        if (init) {
            PlugInPreferences prefs = PlugInPreferences.getInstance();
            prefs.setLastMultipleInputDir("C:\\Data\\temp\\xog\\in");
            prefs.setLastMultipleOutputDir("C:\\Data\\temp\\xog\\out");
            prefs.store(f);
        }
        if (f.exists()) {
            PlugInPreferences prefs2 = PlugInPreferences.loadPreferences(f);
            log.info((Object)prefs2.toXml(0, true));
        }
    }

    public String getLastListXogResultDir() {
        return this.lastListXogResultDir;
    }

    public void setLastListXogResultDir(String lastListXogResultDir) {
        this.lastListXogResultDir = lastListXogResultDir;
    }
}

