/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.popup;

import com.dd.gui.components.Frame;
import com.dd.sources.Source;
import com.dd.xog.saaj.configuration.Configuration;
import com.dd.xog.saaj.configuration.ConfigurationList;
import com.dd.xog.saaj.gui.layout.ParagraphLayout;
import com.dd.xog.saaj.io.FileUtil;
import com.dd.xog.saaj.model.ConfigurationListModel;
import com.dd.xog.saaj.popup.Popup;
import com.dd.xog.saaj.popup.PopupVO;
import com.dd.xog.saaj.popup.XogPopupVO;
import com.dd.xog.saaj.preferences.PlugInPreferences;
import com.dd.xog.saaj.xog.Proxy;
import com.donkeydevelopment.xmlspear.Preferences;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.TitledBorder;
import org.xml.sax.SAXException;

public class XogPopup
extends Popup {
    private static final long serialVersionUID = 1L;
    int i = 0;
    JComboBox comboConfig = null;
    JLabel lbHost = new JLabel();
    JLabel lbPort = new JLabel();
    JLabel lbSsl = new JLabel();
    JTextField tfUserid = new JTextField(25);
    JPasswordField pfPassword = new JPasswordField(25);
    JCheckBox cbUseProxy = new JCheckBox();
    JPanel colorPane = new JPanel();
    JTextField tfProxyHost = new JTextField(25);
    JTextField tfProxyPort = new JTextField(6);
    JTextField tfProxyUserid = new JTextField(25);
    JPasswordField pfProxyPassword = new JPasswordField(25);
    JLabel lbProxyInfo = new JLabel();
    int currentInputIndx = 0;
    JLabel lbInputFilename = new JLabel("XOG File");
    JTextField tfInputFile = null;
    JButton btChooseFile = new JButton("..");
    int currentActionIndx = 0;
    JCheckBox cbOpen = new JCheckBox("open file after xog");
    JLabel lbOutDir = new JLabel("output directory");
    JTextField tfOutDir = null;
    JLabel lbOutFileName = new JLabel("fileName");
    JTextField tfOutFileName = new JTextField(30);
    JButton btSave = new JButton("..");
    File fOutDir = null;
    JComboBox cbInputType = null;
    JComboBox cbOutputActions = null;
    JComboBox cbSelectedFiles = new JComboBox();
    File[] selectedFiles = new File[0];
    JPanel proxyPane = new JPanel(new ParagraphLayout());
    XogPopupVO answer;

    public XogPopup(JFrame owner, String title, boolean modal, PopupVO answer) {
        super(owner, title, modal);
        this.answer = (XogPopupVO)answer;
    }

    public PopupVO showDialog() {
        this.setCenter(this.createCenter());
        this.createListeners();
        this.center();
        this.setDefaultCloseOperation(0);
        this.getRootPane().setDefaultButton(this.btOk);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                XogPopup.this.requestFocusInWindow();
                XogPopup.this.comboConfig.requestFocus();
            }
        });
        this.setVisible(true);
        return this.answer;
    }

    public void createListeners() {
        this.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (this.checkInput()) {
                    XogPopup.this.answer.setIndxSelectedInput(XogPopup.this.currentInputIndx);
                    XogPopup.this.answer.setInFile(new File(XogPopup.this.tfInputFile.getText()));
                    XogPopup.this.answer.setInFiles(XogPopup.this.selectedFiles);
                    XogPopup.this.answer.setIndxSelectedAction(XogPopup.this.currentActionIndx);
                    XogPopup.this.answer.setOutDir(XogPopup.this.fOutDir);
                    XogPopup.this.answer.setOutFileName(XogPopup.this.tfOutFileName.getText());
                    XogPopup.this.answer.setOpenFile(XogPopup.this.cbOpen.isSelected());
                    XogPopup.this.answer.setSelectedConfigurationIndex(XogPopup.this.comboConfig.getSelectedIndex());
                    Configuration config = XogPopup.this.answer.getConfigurationList().getConfiguration(XogPopup.this.answer.getSelectedConfigurationIndex());
                    config.getXOGSettings().setUserid(XogPopup.this.tfUserid.getText());
                    config.getXOGSettings().setPassword(new String(XogPopup.this.pfPassword.getPassword()));
                    config.getXOGSettings().setUseProxy(XogPopup.this.cbUseProxy.isSelected());
                    Proxy proxy = config.getProxy();
                    if (proxy == null) {
                        proxy = new Proxy();
                        proxy.setConfigDefined(false);
                        config.setProxy(proxy);
                    }
                    if (proxy != null) {
                        proxy.setHost(XogPopup.this.tfProxyHost.getText());
                        try {
                            proxy.setPort(Integer.parseInt(XogPopup.this.tfProxyPort.getText()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        proxy.setUser(XogPopup.this.tfProxyUserid.getText());
                        proxy.setPassword(new String(XogPopup.this.pfProxyPassword.getPassword()));
                        if (!proxy.isConfigDefined()) {
                            Preferences.setProxyAddress((String)proxy.getHost());
                            Preferences.setProxyPortNr((int)proxy.getPort());
                            System.setProperty("proxyUser", XogPopup.this.tfProxyUserid.getText());
                            System.setProperty("proxyPassword", new String(XogPopup.this.pfProxyPassword.getPassword()));
                        }
                    }
                    if (XogPopup.this.currentInputIndx == XogPopup.this.answer.getIndxUseMultipleFiles()) {
                        if (XogPopup.this.selectedFiles != null && XogPopup.this.selectedFiles.length > 0) {
                            PlugInPreferences.getInstance().setLastMultipleInputDir(XogPopup.this.selectedFiles[0].getAbsolutePath());
                        }
                    } else if (XogPopup.this.currentInputIndx == XogPopup.this.answer.getIndxUseInputFile() && XogPopup.this.tfInputFile.getText() != null) {
                        PlugInPreferences.getInstance().setLastMultipleInputDir(XogPopup.this.tfInputFile.getText().trim());
                    }
                    if (XogPopup.this.currentActionIndx == XogPopup.this.answer.getIndxSaveToFile()) {
                        PlugInPreferences.getInstance().setLastMultipleOutputDir(XogPopup.this.tfOutDir.getText());
                    }
                    XogPopup.this.answer.setAction(true);
                    XogPopup.this.dispose();
                }
            }

            private boolean checkInput() {
                if (XogPopup.this.currentInputIndx == XogPopup.this.answer.getIndxUseInputFile()) {
                    File f = new File(XogPopup.this.tfInputFile.getText());
                    if (!f.exists()) {
                        JOptionPane.showMessageDialog((Component)Frame.getInstance(), "Input file does not exist", "Input Error", 0);
                        return false;
                    }
                    if (f.isDirectory()) {
                        JOptionPane.showMessageDialog((Component)Frame.getInstance(), "Input file is a directory", "Input Error", 0);
                        return false;
                    }
                }
                if (XogPopup.this.currentInputIndx == XogPopup.this.answer.getIndxUseMultipleFiles() && XogPopup.this.selectedFiles.length == 0) {
                    JOptionPane.showMessageDialog((Component)Frame.getInstance(), "No Input files selected", "Input Error", 0);
                    return false;
                }
                if (XogPopup.this.currentActionIndx == XogPopup.this.answer.getIndxSaveToFile()) {
                    if (XogPopup.this.tfOutDir.getText().trim().length() == 0) {
                        JOptionPane.showMessageDialog((Component)Frame.getInstance(), "Supply the name of the output directory", "Input Error", 0);
                        return false;
                    }
                    XogPopup.this.fOutDir = new File(XogPopup.this.tfOutDir.getText());
                    if (XogPopup.this.fOutDir.isDirectory()) {
                        if (!XogPopup.this.fOutDir.exists()) {
                            JOptionPane.showMessageDialog((Component)Frame.getInstance(), "Output directory does not exist", "Input Error", 0);
                            return false;
                        }
                    } else {
                        JOptionPane.showMessageDialog((Component)Frame.getInstance(), "Output directory is invalid", "Input Error", 0);
                        return false;
                    }
                    if (XogPopup.this.currentInputIndx != XogPopup.this.answer.getIndxUseMultipleFiles()) {
                        int ans;
                        if (XogPopup.this.tfOutFileName.getText().trim().length() == 0) {
                            JOptionPane.showMessageDialog((Component)Frame.getInstance(), "Please specify the name of the output file", "Input Error", 0);
                            return false;
                        }
                        File fOut = new File(XogPopup.this.fOutDir, XogPopup.this.tfOutFileName.getText().trim());
                        if (fOut.exists() && (ans = JOptionPane.showConfirmDialog(null, fOut.getName() + " exists. Overwrite?", "Save Over Existing File", 2, 3)) != 0) {
                            return false;
                        }
                    }
                }
                if (XogPopup.this.tfUserid.getText().trim().length() == 0) {
                    JOptionPane.showMessageDialog((Component)Frame.getInstance(), "You have to fill in a userid", "Input Error", 0);
                    return false;
                }
                if (XogPopup.this.pfPassword.getPassword().length == 0) {
                    JOptionPane.showMessageDialog((Component)Frame.getInstance(), "You have to fill in a password", "Input Error", 0);
                    return false;
                }
                return true;
            }
        });
        this.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XogPopup.this.answer.setAction(false);
                XogPopup.this.dispose();
            }
        });
    }

    public JPanel createCenter() {
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(600, 680));
        JTextPane infoPane = new JTextPane();
        infoPane.setText(this.answer.getInfoText());
        infoPane.setPreferredSize(new Dimension(540, 50));
        infoPane.setEditable(false);
        infoPane.setBackground(new JLabel().getBackground());
        infoPane.setBorder(new TitledBorder("Information"));
        JPanel inputPane = new JPanel(new ParagraphLayout());
        inputPane.setBorder(new TitledBorder("Input Parameters"));
        inputPane.setPreferredSize(new Dimension(540, 100));
        inputPane.add((Component)new JLabel("Input Source"), ParagraphLayout.NEW_PARAGRAPH);
        this.cbInputType = new JComboBox<String>(this.answer.getUseInputArray());
        this.cbInputType.setSelectedIndex(this.answer.getIndxSelectedInput());
        this.currentInputIndx = this.answer.getIndxSelectedInput();
        this.cbInputType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                XogPopup.this.answer.setIndxSelectedInput(cb.getSelectedIndex());
                XogPopup.this.currentInputIndx = cb.getSelectedIndex();
                if (XogPopup.this.currentInputIndx == XogPopup.this.answer.indxOpenInTab) {
                    XogPopup.this.setOutFileName();
                }
                XogPopup.this.setExtensionVisibilityInput(cb.getSelectedIndex());
                if (XogPopup.this.cbInputType.getSelectedIndex() == XogPopup.this.answer.getIndxUseMultipleFiles()) {
                    XogPopup.this.cbOutputActions.setSelectedIndex(XogPopup.this.answer.getIndxSaveToFile());
                }
                XogPopup.this.setExtensionVisibilityOuput(XogPopup.this.cbOutputActions.getSelectedIndex());
            }
        });
        this.cbInputType.setEnabled(this.answer.isInputEnabled());
        inputPane.add(this.cbInputType);
        inputPane.add(this.cbOpen);
        inputPane.add((Component)this.lbInputFilename, ParagraphLayout.NEW_PARAGRAPH);
        this.tfInputFile = new JTextField(35);
        if (this.answer.getInFile() != null) {
            this.tfInputFile.setText(this.answer.getInFile().getAbsolutePath());
        }
        inputPane.add(this.cbSelectedFiles);
        this.cbSelectedFiles.setPreferredSize(new Dimension(400, 20));
        inputPane.add(this.tfInputFile);
        this.btChooseFile.setPreferredSize(new Dimension(20, 25));
        inputPane.add(this.btChooseFile);
        this.btChooseFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle("Choose XOG input file");
                fc.setFileSelectionMode(0);
                fc.setMultiSelectionEnabled(XogPopup.this.cbInputType.getSelectedIndex() == XogPopup.this.answer.getIndxUseMultipleFiles());
                if (XogPopup.this.answer.getInFile() != null) {
                    fc.setCurrentDirectory(XogPopup.this.answer.getInFile());
                } else if (XogPopup.this.selectedFiles != null && XogPopup.this.selectedFiles.length > 0) {
                    fc.setCurrentDirectory(XogPopup.this.selectedFiles[0]);
                } else if (PlugInPreferences.getInstance().getLastMultipleInputDir() != null) {
                    fc.setCurrentDirectory(new File(PlugInPreferences.getInstance().getLastMultipleInputDir()));
                }
                if (XogPopup.this.cbInputType.getSelectedIndex() == XogPopup.this.answer.getIndxUseInputFile() && XogPopup.this.tfInputFile.getText() != null && XogPopup.this.tfInputFile.getText().trim().length() > 0) {
                    fc.setCurrentDirectory(new File(XogPopup.this.tfInputFile.getText().trim()));
                }
                int ret = fc.showOpenDialog((Component)Frame.getInstance());
                switch (ret) {
                    case 0: {
                        if (!fc.isMultiSelectionEnabled()) {
                            File f = fc.getSelectedFile();
                            if (f == null) break;
                            XogPopup.this.tfInputFile.setText(f.getAbsolutePath());
                            XogPopup.this.tfOutFileName.setText(String.valueOf(PlugInPreferences.getInstance().getXogPrefix()) + FileUtil.getFileName(f) + PlugInPreferences.getInstance().getXogPostfix() + "." + FileUtil.getExtension(f, "xml"));
                            break;
                        }
                        XogPopup.this.selectedFiles = fc.getSelectedFiles();
                        XogPopup.this.cbSelectedFiles.removeAllItems();
                        int i = 0;
                        while (i < XogPopup.this.selectedFiles.length) {
                            XogPopup.this.cbSelectedFiles.addItem(XogPopup.this.selectedFiles[i].getName());
                            ++i;
                        }
                        break;
                    }
                }
            }
        });
        panel.add(inputPane);
        this.setExtensionVisibilityInput(this.cbInputType.getSelectedIndex());
        JPanel outputPane = new JPanel(new ParagraphLayout());
        outputPane.setBorder(new TitledBorder("Output Parameters"));
        outputPane.setPreferredSize(new Dimension(540, 130));
        outputPane.add((Component)new JLabel("Output action"), ParagraphLayout.NEW_PARAGRAPH);
        this.cbOutputActions = new JComboBox<String>(this.answer.getActionArray());
        this.cbOutputActions.setSelectedIndex(this.answer.getIndxSelectedAction());
        this.currentActionIndx = this.answer.getIndxSelectedAction();
        this.cbOutputActions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                XogPopup.this.answer.setIndxSelectedAction(cb.getSelectedIndex());
                XogPopup.this.currentActionIndx = cb.getSelectedIndex();
                XogPopup.this.setExtensionVisibilityOuput(cb.getSelectedIndex());
            }
        });
        outputPane.add(this.cbOutputActions);
        outputPane.add(this.cbOpen);
        this.cbOpen.setSelected(this.answer.isOpenFile());
        outputPane.add((Component)this.lbOutDir, ParagraphLayout.NEW_PARAGRAPH);
        this.tfOutDir = new JTextField(35);
        if (this.answer.getOutDir() != null) {
            this.tfOutDir.setText(this.answer.getOutDir().getAbsolutePath());
        } else {
            this.tfOutDir.setText(PlugInPreferences.getInstance().getLastMultipleOutputDir());
        }
        outputPane.add(this.tfOutDir);
        this.btSave.setPreferredSize(new Dimension(20, 25));
        outputPane.add(this.btSave);
        this.btSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle("Choose output directory");
                fc.setFileSelectionMode(1);
                if (XogPopup.this.answer.getOutDir() != null) {
                    fc.setCurrentDirectory(XogPopup.this.answer.getOutDir());
                }
                if (XogPopup.this.tfOutDir.getText() != null && XogPopup.this.tfOutDir.getText().trim().length() > 0) {
                    fc.setCurrentDirectory(new File(XogPopup.this.tfOutDir.getText().trim()));
                }
                int ret = fc.showSaveDialog((Component)Frame.getInstance());
                switch (ret) {
                    case 0: {
                        File f = fc.getSelectedFile();
                        if (f == null) break;
                        XogPopup.this.tfOutDir.setText(f.getAbsolutePath());
                    }
                }
            }
        });
        outputPane.add((Component)this.lbOutFileName, ParagraphLayout.NEW_PARAGRAPH);
        this.tfOutFileName = new JTextField(35);
        if (this.currentInputIndx == this.answer.indxOpenInTab) {
            this.setOutFileName();
        } else {
            this.tfOutFileName.setText(this.answer.getOutFileName());
        }
        outputPane.add(this.tfOutFileName);
        panel.add(outputPane);
        this.setExtensionVisibilityOuput(this.cbOutputActions.getSelectedIndex());
        JPanel configurationPane = new JPanel(new ParagraphLayout());
        configurationPane.setBorder(new TitledBorder("Target environment"));
        configurationPane.setPreferredSize(new Dimension(540, 250));
        configurationPane.add((Component)new JLabel("Configuartion"), ParagraphLayout.NEW_PARAGRAPH);
        this.proxyPane.setBorder(new TitledBorder("Proxy settings"));
        this.cbUseProxy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                XogPopup.this.setProxyVisibility(XogPopup.this.cbUseProxy.isSelected());
            }
        });
        this.comboConfig = new JComboBox(new ConfigurationListModel(this.answer.getConfigurationList()));
        this.comboConfig.setRenderer(new ComboBoxRenderer());
        this.comboConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Configuration config = (Configuration)XogPopup.this.comboConfig.getModel().getSelectedItem();
                XogPopup.this.lbHost.setText(config.getXOGSettings().getHost());
                XogPopup.this.lbPort.setText(String.valueOf(config.getXOGSettings().getPort()));
                XogPopup.this.lbSsl.setText(new Boolean(config.getXOGSettings().isSsl()).toString());
                XogPopup.this.tfUserid.setText(config.getXOGSettings().getUserid());
                XogPopup.this.pfPassword.setText(config.getXOGSettings().getPassword());
                XogPopup.this.cbUseProxy.setSelected(config.getXOGSettings().isUseProxy());
                XogPopup.this.colorPane.setBackground(config.getEvaluatedColor());
                Proxy proxy = config.getProxy();
                if (proxy != null) {
                    XogPopup.this.tfProxyHost.setText(proxy.getHost());
                    XogPopup.this.tfProxyPort.setText(String.valueOf(proxy.getPort()));
                    XogPopup.this.tfProxyUserid.setText(proxy.getUser());
                    XogPopup.this.pfProxyPassword.setText(proxy.getPassword());
                } else {
                    XogPopup.this.tfProxyHost.setText(Preferences.getProxyAddress());
                    XogPopup.this.tfProxyPort.setText(String.valueOf(Preferences.getProxyPortNr()));
                    XogPopup.this.tfProxyUserid.setText(System.getProperty("proxyUser"));
                    XogPopup.this.pfProxyPassword.setText(System.getProperty("proxyPassword"));
                }
            }
        });
        this.comboConfig.setSelectedIndex(this.answer.getSelectedConfigurationIndex());
        configurationPane.add(this.comboConfig);
        this.colorPane.setPreferredSize(new Dimension(20, 20));
        configurationPane.add(this.colorPane);
        configurationPane.add((Component)new JLabel("Host"), ParagraphLayout.NEW_PARAGRAPH);
        configurationPane.add(this.lbHost);
        configurationPane.add(this.lbPort);
        configurationPane.add((Component)new JLabel("SSL"), ParagraphLayout.NEW_PARAGRAPH);
        configurationPane.add(this.lbSsl);
        configurationPane.add((Component)new JLabel("Userid"), ParagraphLayout.NEW_PARAGRAPH);
        configurationPane.add(this.tfUserid);
        configurationPane.add((Component)new JLabel("Password"), ParagraphLayout.NEW_PARAGRAPH);
        configurationPane.add(this.pfPassword);
        configurationPane.add((Component)new JLabel("UseProxy"), ParagraphLayout.NEW_PARAGRAPH);
        configurationPane.add(this.cbUseProxy);
        configurationPane.add(this.lbProxyInfo);
        panel.add(configurationPane);
        this.proxyPane.setPreferredSize(new Dimension(540, 150));
        this.proxyPane.add((Component)new JLabel("Host"), ParagraphLayout.NEW_PARAGRAPH);
        this.proxyPane.add(this.tfProxyHost);
        this.proxyPane.add(this.tfProxyPort);
        this.proxyPane.add((Component)new JLabel("Userid"), ParagraphLayout.NEW_PARAGRAPH);
        this.proxyPane.add(this.tfProxyUserid);
        this.proxyPane.add((Component)new JLabel("Password"), ParagraphLayout.NEW_PARAGRAPH);
        this.proxyPane.add(this.pfProxyPassword);
        panel.add(this.proxyPane);
        this.setProxyVisibility(this.cbUseProxy.isSelected());
        return panel;
    }

    private void setExtensionVisibilityInput(int index) {
        if (index == this.answer.getIndxUseInputFile()) {
            this.lbInputFilename.setVisible(true);
            this.tfInputFile.setVisible(true);
            this.cbSelectedFiles.setVisible(false);
            this.tfInputFile.requestFocus();
            this.btChooseFile.setVisible(true);
        } else if (index == this.answer.indxOpenInTab) {
            this.lbInputFilename.setVisible(false);
            this.tfInputFile.setVisible(false);
            this.cbSelectedFiles.setVisible(false);
            this.btChooseFile.setVisible(false);
        } else if (index == this.answer.getIndxUseMultipleFiles()) {
            this.lbInputFilename.setVisible(true);
            this.tfInputFile.setVisible(false);
            this.cbSelectedFiles.setVisible(true);
            this.tfInputFile.requestFocus();
            this.btChooseFile.setVisible(true);
        }
    }

    private void setExtensionVisibilityOuput(int index) {
        if (index == this.answer.getIndxSaveToFile()) {
            this.cbOpen.setVisible(true);
            this.lbOutDir.setVisible(true);
            this.tfOutDir.setVisible(true);
            this.btSave.setVisible(true);
            this.lbOutFileName.setVisible(true);
            this.tfOutFileName.setVisible(true);
            this.tfOutDir.requestFocus();
        } else if (index == this.answer.indxOpenInTab) {
            this.cbOpen.setVisible(false);
            this.lbOutDir.setVisible(false);
            this.tfOutDir.setVisible(false);
            this.btSave.setVisible(false);
            this.lbOutFileName.setVisible(false);
            this.tfOutFileName.setVisible(false);
        }
        if (this.cbInputType.getSelectedIndex() == this.answer.getIndxUseMultipleFiles()) {
            this.cbOutputActions.setEnabled(false);
            this.tfOutFileName.setVisible(false);
        } else {
            this.cbOutputActions.setEnabled(true);
        }
    }

    private void setProxyVisibility(boolean useProxy) {
        if (useProxy) {
            this.lbProxyInfo.setText("Proxy settings may be edited below");
        } else {
            this.lbProxyInfo.setText("");
        }
        this.pfProxyPassword.setVisible(useProxy);
        this.tfProxyUserid.setVisible(useProxy);
        this.tfProxyPort.setVisible(useProxy);
        this.tfProxyHost.setVisible(useProxy);
        Configuration config = (Configuration)this.comboConfig.getModel().getSelectedItem();
        String infoText = "";
        if (config != null) {
            Proxy proxy = config.getProxy();
            if (proxy != null && proxy.isConfigDefined()) {
                this.proxyPane.setBorder(new TitledBorder("Proxy settings, specific fore this destination"));
            } else {
                this.proxyPane.setBorder(new TitledBorder("Global Proxy settings"));
            }
        }
    }

    private void setOutFileName() {
        File inFile = null;
        Source source = Frame.getInstance().getActiveSource();
        if (source != null && (inFile = source.getFile()) != null) {
            this.tfOutFileName.setText(String.valueOf(PlugInPreferences.getInstance().getXogPrefix()) + FileUtil.getFileName(inFile) + PlugInPreferences.getInstance().getXogPostfix() + "." + FileUtil.getExtension(inFile, "xml"));
        }
    }

    public static void main(String[] args) throws SAXException, IOException {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            System.out.println("LookAndFeel " + UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        XogPopupVO answer = new XogPopupVO();
        answer.setInfoText("Choose your target environment\n");
        answer.setConfigurationList(ConfigurationList.getInstance("configurations"));
        XogPopup popup = new XogPopup(null, "Specify XOG paramaters", true, answer);
        popup.showDialog();
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Configuration configuration = (Configuration)value;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setText(configuration.getEnvironment());
            this.setIcon(null);
            return this;
        }
    }
}

