/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.popup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Popup
extends JDialog {
    private static final long serialVersionUID = 1L;
    public JButton btOk;
    public JButton btCancel;
    public boolean showCancel = true;
    JPanel southPanel = new JPanel();

    public Popup(JDialog owner, String title, boolean modal) {
        super(owner, title, modal);
        this.getContentPane().setLayout(new BorderLayout());
        this.createSouth();
        this.setResizable(false);
    }

    public Popup(JFrame owner, String title, boolean modal, boolean showCancel) {
        super(owner, title, modal);
        this.showCancel = showCancel;
        this.getContentPane().setLayout(new BorderLayout());
        this.createSouth();
        this.setResizable(false);
    }

    public Popup(JFrame owner, String title, boolean modal, boolean showCancel, boolean isResizeAllowed) {
        super(owner, title, modal);
        this.showCancel = showCancel;
        this.getContentPane().setLayout(new BorderLayout());
        this.createSouth();
        this.setResizable(isResizeAllowed);
    }

    public Popup(JFrame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.getContentPane().setLayout(new BorderLayout());
        this.createSouth();
        this.setResizable(false);
    }

    public void setNorth(URL url) {
        ImageIcon icon = new ImageIcon(url);
        JLabel label = new JLabel(icon);
        this.getContentPane().add((Component)label, "North");
    }

    public void setNorth(JLabel label) {
        this.getContentPane().add((Component)label, "North");
    }

    public void setCenter(JPanel panel) {
        panel.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add((Component)panel, "Center");
    }

    protected void createSouth() {
        this.southPanel.setBorder(BorderFactory.createEtchedBorder());
        this.btOk = new JButton("  OK  ");
        this.btOk.setDefaultCapable(true);
        this.btCancel = new JButton("Cancel");
        this.southPanel.add(this.btOk);
        if (this.showCancel) {
            this.southPanel.add(this.btCancel);
        }
        this.getContentPane().add((Component)this.southPanel, "South");
    }

    public void center() {
        this.pack();
        if (this.getParent() == null) {
            Dimension dim = this.getToolkit().getScreenSize();
            int screenWidth = dim.width;
            int screenHeight = dim.height;
            int frameWidth = this.getPreferredSize().width;
            int frameHeight = this.getPreferredSize().height;
            this.setLocation((screenWidth - frameWidth) / 2, (screenHeight - frameHeight) / 2);
        } else {
            this.setLocationRelativeTo(this.getParent());
        }
    }

    public void addOkActionListener(ActionListener listener) {
        this.btOk.addActionListener(listener);
    }

    public void removeOkActionListener(ActionListener listener) {
        this.btOk.removeActionListener(listener);
    }

    public void addCancelActionListener(ActionListener listener) {
        this.btCancel.addActionListener(listener);
    }

    public void removeCancelActionListener(ActionListener listener) {
        this.btCancel.removeActionListener(listener);
    }

    public void removeCancelButton() {
        this.southPanel.remove(this.btCancel);
    }
}

