/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DelayedDocumentListener
implements DocumentListener,
ActionListener {
    private Timer timer = null;
    private DocumentListener delegate;
    private DocumentEvent event;

    public DelayedDocumentListener(DocumentListener delegate) {
        this(delegate, 3000);
    }

    public DelayedDocumentListener(DocumentListener delegate, int delay) {
        this.delegate = delegate;
        this.timer = new Timer(delay, this);
    }

    private void documentChanged(DocumentEvent de) {
        this.timer.restart();
        this.event = de;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DocumentEvent.EventType eventType;
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        if ((eventType = this.event.getType()) == DocumentEvent.EventType.INSERT) {
            this.delegate.insertUpdate(this.event);
        } else if (eventType == DocumentEvent.EventType.REMOVE) {
            this.delegate.removeUpdate(this.event);
        }
        if (eventType == DocumentEvent.EventType.CHANGE) {
            this.delegate.changedUpdate(this.event);
        }
    }
}

