/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.gui.animate;

import com.dd.xog.saaj.gui.animate.AnimatedIcon;
import com.dd.xog.saaj.gui.animate.SpinningDial;
import com.dd.xog.saaj.gui.animate.SpinningDialWaitIndicator;
import com.dd.xog.saaj.gui.animate.WaitIndicator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.SimpleBeanInfo;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AnimatedIconDemo
extends JApplet {
    protected static Icon LOADING_ICON;
    protected static Icon SPINNING_ICON;
    private static WaitIndicator waiter;

    @Override
    public void init() {
        SPINNING_ICON = new SpinningDial(16, 16);
        try {
            URL url = this.getClass().getResource("anim.gif");
            if (url == null) {
                url = this.getClass().getResource("/anim.gif");
            }
            if (url != null) {
                LOADING_ICON = new ImageIcon(url);
            }
            if (LOADING_ICON == null) {
                Image image = new SimpleBeanInfo().loadImage("anim.gif");
                if (image == null) {
                    image = new SimpleBeanInfo().loadImage("/anim.gif");
                }
                if (image != null) {
                    LOADING_ICON = new ImageIcon(image);
                }
            }
            if (LOADING_ICON != null) {
                LOADING_ICON = new AnimatedIcon((ImageIcon)LOADING_ICON);
                this.setContentPane(AnimatedIconDemo.createContentPane());
            } else {
                this.getContentPane().add(new JLabel("Image not found"));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.getContentPane().add(new JTextArea(t.toString()));
        }
    }

    @Override
    public void start() {
        waiter = new SpinningDialWaitIndicator((JComponent)this.getContentPane());
        new Timer(10000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (waiter != null) {
                    waiter.dispose();
                    waiter = null;
                }
            }
        }).start();
    }

    private static Container createContentPane() {
        JPanel p = new JPanel(new BorderLayout());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root", true);
        LazyTreeModel model = new LazyTreeModel(root);
        JTree tree = new JTree(model);
        DefaultTreeCellRenderer r = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean isLeaf, int row, boolean focused) {
                Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, isLeaf, row, focused);
                TreePath path = tree.getPathForRow(row);
                if (path != null && path.getLastPathComponent() instanceof LoadingNode) {
                    this.setIcon(LOADING_ICON);
                }
                return c;
            }
        };
        tree.setCellRenderer(r);
        tree.setRootVisible(true);
        JLabel topLabel = new JLabel("Processing", LOADING_ICON, 2);
        topLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JLabel bottomLabel = new JLabel("Click Here");
        bottomLabel.setHorizontalTextPosition(10);
        bottomLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        bottomLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JLabel label = (JLabel)e.getComponent();
                if (label.getIcon() == null) {
                    label.setIcon(LOADING_ICON);
                } else if (label.getIcon() == LOADING_ICON) {
                    label.setIcon(SPINNING_ICON);
                } else {
                    label.setIcon(null);
                }
            }
        });
        p.add((Component)topLabel, "North");
        p.add(new JScrollPane(tree));
        p.add((Component)bottomLabel, "South");
        return p;
    }

    public static void main(String[] args) {
        URL url = AnimatedIconDemo.class.getResource("anim.gif");
        LOADING_ICON = new AnimatedIcon(new ImageIcon(url));
        SPINNING_ICON = new SpinningDial(16, 16);
        JFrame frame = new JFrame("Cell Animator Demo");
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(AnimatedIconDemo.createContentPane());
        frame.pack();
        frame.setLocation(100, 100);
        frame.setSize(new Dimension(200, 300));
        frame.setVisible(true);
        waiter = new SpinningDialWaitIndicator(frame);
        new Timer(10000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (waiter != null) {
                    waiter.dispose();
                    waiter = null;
                }
            }
        }){
            {
                this.setRepeats(false);
            }
        }.start();
    }

    private static final class LazyTreeModel
    extends DefaultTreeModel {
        private Set loading = new HashSet();

        public LazyTreeModel(TreeNode root) {
            super(root);
            this.setAsksAllowsChildren(true);
        }

        private void populate(Object node) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)node;
            n.removeAllChildren();
            int i = 0;
            while (i < 5) {
                n.add(new DefaultMutableTreeNode("child " + i, true));
                ++i;
            }
            this.fireTreeStructureChanged(this, n.getPath(), null, null);
        }

        private void loadChildren(final Object node) {
            if (!this.loading.contains(node)) {
                this.loading.add(node);
                new Thread("Load children for " + node){

                    @Override
                    public void run() {
                        try {
                            1.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LazyTreeModel.this.populate(node);
                            }
                        });
                    }
                }.start();
            }
        }

        @Override
        public int getChildCount(Object node) {
            int count = super.getChildCount(node);
            if (count == 0) {
                this.loadChildren(node);
                return 1;
            }
            return count;
        }

        @Override
        public Object getChild(Object node, int idx) {
            if (super.getChildCount(node) == 0) {
                ((DefaultMutableTreeNode)node).add(new LoadingNode());
            }
            return super.getChild(node, idx);
        }
    }

    private static class LoadingNode
    extends DefaultMutableTreeNode {
        public LoadingNode() {
            super("Loading...", false);
        }

        @Override
        public int getChildCount() {
            return 0;
        }
    }
}

