/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.gui.animate;

import com.dd.xog.saaj.gui.animate.GifDecoder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import sun.awt.image.GifImageDecoder;
import sun.awt.image.ImageDecoder;
import sun.awt.image.InputStreamImageSource;

public class AnimatedIcon
implements Icon {
    private static Map decoded = new WeakHashMap();
    private ImageIcon original;
    private Set repaints = new HashSet();

    public static boolean isAnimated(Icon icon) {
        if (icon instanceof ImageIcon) {
            Image image = ((ImageIcon)icon).getImage();
            if (image != null) {
                Object comment = image.getProperty("comment", null);
                if (String.valueOf(comment).startsWith("GifBuilder")) {
                    return true;
                }
                if (decoded.containsKey(image)) {
                    return Boolean.TRUE.equals(decoded.get(image));
                }
                InputStream is = null;
                try {
                    URL url = new URL(icon.toString());
                    is = url.openConnection().getInputStream();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (is == null) {
                    try {
                        ImageProducer p = image.getSource();
                        if (p instanceof InputStreamImageSource) {
                            Method m = InputStreamImageSource.class.getDeclaredMethod("getDecoder", null);
                            m.setAccessible(true);
                            ImageDecoder d = (ImageDecoder)m.invoke((Object)p, null);
                            if (d instanceof GifImageDecoder) {
                                GifImageDecoder gd = (GifImageDecoder)d;
                                Field input = ImageDecoder.class.getDeclaredField("input");
                                input.setAccessible(true);
                                is = (InputStream)input.get(gd);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (is != null) {
                    GifDecoder decoder = new GifDecoder();
                    decoder.read(is);
                    boolean animated = decoder.getFrameCount() > 1;
                    decoded.put(image, animated);
                    return animated;
                }
            }
            return false;
        }
        return icon instanceof AnimatedIcon;
    }

    protected AnimatedIcon() {
    }

    public AnimatedIcon(ImageIcon original) {
        this.original = original;
        new AnimationObserver(this, original);
    }

    protected synchronized void repaint() {
        Iterator i = this.repaints.iterator();
        while (i.hasNext()) {
            ((RepaintArea)i.next()).repaint();
        }
        this.repaints.clear();
    }

    @Override
    public int getIconHeight() {
        return this.original.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.original.getIconWidth();
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        this.paintFrame(c, g, x, y);
        if (c != null) {
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            AffineTransform tx = ((Graphics2D)g).getTransform();
            w = (int)((double)w * tx.getScaleX());
            h = (int)((double)h * tx.getScaleY());
            this.registerRepaintArea(c, x, y, w, h);
        }
    }

    protected void paintFrame(Component c, Graphics g, int x, int y) {
        this.original.paintIcon(c, g, x, y);
    }

    protected void registerRepaintArea(Component c, int x, int y, int w, int h) {
        this.repaints.add(new RepaintArea(c, x, y, w, h));
    }

    private static class AnimationObserver
    implements ImageObserver {
        private WeakReference ref;
        private ImageIcon original;

        public AnimationObserver(AnimatedIcon animIcon, ImageIcon original) {
            this.original = original;
            this.original.setImageObserver(this);
            this.ref = new WeakReference<AnimatedIcon>(animIcon);
        }

        @Override
        public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
            if ((flags & 0x30) != 0) {
                AnimatedIcon animIcon = (AnimatedIcon)this.ref.get();
                if (animIcon != null) {
                    animIcon.repaint();
                } else {
                    this.original.setImageObserver(null);
                }
            }
            return (flags & 0xA0) == 0;
        }
    }

    private class RepaintArea {
        public int x;
        public int y;
        public int w;
        public int h;
        public Component component;
        private int hashCode;

        public RepaintArea(Component c, int x, int y, int w, int h) {
            Component ancestor = this.findNonRendererAncestor(c);
            if (ancestor != c) {
                Point pt = SwingUtilities.convertPoint(c, x, y, ancestor);
                c = ancestor;
                x = pt.x;
                y = pt.y;
            }
            this.component = c;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            String hash = String.valueOf(String.valueOf(x)) + "," + y + ":" + c.hashCode();
            this.hashCode = hash.hashCode();
        }

        private Component findNonRendererAncestor(Component c) {
            Container ancestor = SwingUtilities.getAncestorOfClass(CellRendererPane.class, c);
            if (ancestor != null && ancestor != c && ancestor.getParent() != null) {
                c = this.findNonRendererAncestor(ancestor.getParent());
            }
            return c;
        }

        public void repaint() {
            this.component.repaint(this.x, this.y, this.w, this.h);
        }

        public boolean equals(Object o) {
            if (o instanceof RepaintArea) {
                RepaintArea area = (RepaintArea)o;
                return area.component == this.component && area.x == this.x && area.y == this.y && area.w == this.w && area.h == this.h;
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "Repaint(" + this.component.getClass().getName() + "@" + this.x + "," + this.y + " " + this.w + "x" + this.h + ")";
        }
    }
}

