/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.gui.animate;

import com.dd.xog.saaj.gui.animate.AnimatedIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import javax.swing.Timer;

public abstract class AbstractAnimatedIcon
extends AnimatedIcon {
    private static final int DEFAULT_INTERVAL = 41;
    private Timer timer;
    private int repaintInterval;
    private int frame;
    private int frameCount;

    protected AbstractAnimatedIcon() {
        this(0);
    }

    protected AbstractAnimatedIcon(int frameCount) {
        this(frameCount, 41);
    }

    protected AbstractAnimatedIcon(int frameCount, int interval) {
        this.frameCount = frameCount;
        this.setFrameInterval(interval);
    }

    protected void finalize() {
        this.timer.stop();
    }

    public void setFrameInterval(int interval) {
        this.repaintInterval = interval;
        if (interval != 0) {
            if (this.timer == null) {
                this.timer = new Timer(interval, new AnimationUpdater(this));
                this.timer.setRepeats(true);
            } else {
                this.timer.setDelay(interval);
            }
        } else if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public int getFrameInterval() {
        return this.repaintInterval;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public void nextFrame() {
        this.setFrame(this.getFrame() + 1);
    }

    public void setFrame(int f) {
        this.frame = f;
        if (this.frameCount != 0) {
            this.frame %= this.frameCount;
        }
        this.repaint();
    }

    public int getFrame() {
        return this.frame;
    }

    @Override
    protected abstract void paintFrame(Component var1, Graphics var2, int var3, int var4);

    @Override
    public abstract int getIconWidth();

    @Override
    public abstract int getIconHeight();

    @Override
    protected synchronized void registerRepaintArea(Component c, int x, int y, int w, int h) {
        if (this.timer != null && !this.timer.isRunning()) {
            this.timer.start();
        }
        super.registerRepaintArea(c, x, y, w, h);
    }

    private static class AnimationUpdater
    implements ActionListener {
        private WeakReference ref;

        public AnimationUpdater(AbstractAnimatedIcon icon) {
            this.ref = new WeakReference<AbstractAnimatedIcon>(icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractAnimatedIcon icon = (AbstractAnimatedIcon)this.ref.get();
            if (icon != null) {
                icon.nextFrame();
            }
        }
    }
}

