/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.gui;

import com.dd.xog.saaj.popup.PopupDocument;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class XogDisplayPanel
extends JPanel {
    private static final Insets WEST_INSETS = new Insets(5, 0, 5, 5);
    private static final Insets EAST_INSETS = new Insets(5, 5, 5, 0);
    private Map<FieldTitle, JTextField> fieldMap = new HashMap<FieldTitle, JTextField>();

    public XogDisplayPanel() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("XOG Settings"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        int i = 0;
        while (i < FieldTitle.values().length) {
            FieldTitle fieldTitle = FieldTitle.values()[i];
            GridBagConstraints gbc = this.createGbc(0, i);
            this.add((Component)new JLabel(String.valueOf(fieldTitle.getTitle()) + ":", 2), gbc);
            gbc = this.createGbc(1, i);
            JTextField textField = new JTextField();
            textField.setDocument(new PopupDocument(fieldTitle.getMaxLength(), fieldTitle.isNumericOnly()));
            textField.setEditable(fieldTitle.isEditable());
            this.add((Component)textField, gbc);
            this.fieldMap.put(fieldTitle, textField);
            ++i;
        }
    }

    private GridBagConstraints createGbc(int x, int y) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = x == 0 ? 17 : 13;
        gbc.fill = x == 0 ? 1 : 2;
        gbc.insets = x == 0 ? WEST_INSETS : EAST_INSETS;
        gbc.weightx = x == 0 ? 0.1 : 1.0;
        gbc.weighty = 1.0;
        return gbc;
    }

    public String getFieldText(FieldTitle fieldTitle) {
        return this.fieldMap.get((Object)fieldTitle).getText();
    }

    public JTextField getField(FieldTitle fieldTitle) {
        return this.fieldMap.get((Object)fieldTitle);
    }

    public void setFieldText(FieldTitle fieldTitle, String value) {
        this.fieldMap.get((Object)fieldTitle).setText(value);
    }

    public void setFieldEditable(FieldTitle fieldTitle, boolean value) {
        this.fieldMap.get((Object)fieldTitle).setEditable(value);
    }

    static enum FieldTitle {
        NAME("Environment", false, 100, false),
        URL("Url", false, 9999, false),
        USER("User", false, 50, false),
        THREADCOUNT("Nr of parallel XOG processes", false, 3, true);

        private String title;
        private boolean editable;
        private int maxLength = 9999;
        private boolean numericOnly;

        private FieldTitle(String title, boolean editable, int maxLen, boolean numericOnly) {
            this.title = title;
            this.editable = editable;
            this.maxLength = maxLen;
            this.numericOnly = numericOnly;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public boolean isNumericOnly() {
            return this.numericOnly;
        }
    }
}

