/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.gui;

import com.dd.xog.saaj.configuration.Configuration;
import com.dd.xog.saaj.gui.Table;
import com.dd.xog.saaj.gui.XogDisplayPanel;
import com.dd.xog.saaj.popup.XogPopupVO;
import com.dd.xog.saaj.resources.ResourceLoader;
import com.dd.xog.saaj.table.CheckAllAction;
import com.dd.xog.saaj.table.CheckBoxCellEditor;
import com.dd.xog.saaj.table.CheckBoxCellRenderer;
import com.dd.xog.saaj.table.CheckListButtonTableEditor;
import com.dd.xog.saaj.table.CheckListButtonTableRenderer;
import com.dd.xog.saaj.table.ExportResultAction;
import com.dd.xog.saaj.table.StatusTableRenderer;
import com.dd.xog.saaj.table.UnCheckAllAction;
import com.dd.xog.saaj.table.XOGRow;
import com.dd.xog.saaj.table.XogResultRenderer;
import com.dd.xog.saaj.table.XogTableModel;
import com.dd.xog.saaj.worker.XogMultiThreadWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class StatusFrame
extends JFrame {
    private static final long serialVersionUID = -8668818312732181049L;
    private Action searchCancelAction;
    private Action browseAction;
    private JTextField wordTextField;
    private JTextField directoryPathTextField;
    private JTextArea messagesTextArea;
    private JProgressBar searchProgressBar;
    private JTable progressTable;
    XogPopupVO answer;
    Configuration config;
    private XogMultiThreadWorker xogMultiThreadWorker;
    private XogDisplayPanel xogDisplayPanel;
    private JFrame parent;

    public StatusFrame(JFrame parent, String title, XogPopupVO answer) {
        this.parent = parent;
        this.setTitle(title);
        this.setIconImage(new ImageIcon(ResourceLoader.class.getResource("xog.gif")).getImage());
        this.answer = answer;
        this.config = answer.getConfigurationList().getConfiguration(answer.getSelectedConfigurationIndex());
        this.initActions();
        this.initComponents();
    }

    private void cancel() {
        this.xogMultiThreadWorker.cancel(false);
    }

    private void initActions() {
        this.browseAction = new AbstractAction("Browse"){
            private static final long serialVersionUID = 4669650683189592364L;

            @Override
            public void actionPerformed(ActionEvent e) {
                File dir = new File(StatusFrame.this.directoryPathTextField.getText()).getAbsoluteFile();
                JFileChooser fileChooser = new JFileChooser(dir.getParentFile());
                fileChooser.setFileSelectionMode(1);
                int option = fileChooser.showOpenDialog(StatusFrame.this);
                if (option == 0) {
                    File selected = fileChooser.getSelectedFile();
                    StatusFrame.this.directoryPathTextField.setText(selected.getAbsolutePath());
                }
            }
        };
        this.searchCancelAction = new AbstractAction("Go"){
            private static final long serialVersionUID = 4669650683189592364L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StatusFrame.this.xogMultiThreadWorker == null) {
                    StatusFrame.this.search();
                } else {
                    StatusFrame.this.cancel();
                }
            }
        };
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    private void initComponents() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        this.xogDisplayPanel = new XogDisplayPanel();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 3;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        contentPane.add((Component)new JScrollPane(this.xogDisplayPanel), constraints);
        this.xogDisplayPanel.setFieldText(XogDisplayPanel.FieldTitle.NAME, this.config.getEnvironment());
        this.xogDisplayPanel.setFieldText(XogDisplayPanel.FieldTitle.URL, this.config.getXOGSettings().getUrl());
        this.xogDisplayPanel.setFieldText(XogDisplayPanel.FieldTitle.USER, this.config.getXOGSettings().getUserid());
        this.xogDisplayPanel.setFieldText(XogDisplayPanel.FieldTitle.THREADCOUNT, "1");
        if (StatusFrame.isWindows()) {
            this.xogDisplayPanel.setFieldEditable(XogDisplayPanel.FieldTitle.THREADCOUNT, true);
        }
        Border yellowline = BorderFactory.createLineBorder(this.config.getEvaluatedColor(), 3);
        CompoundBorder coloredBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(yellowline, "XOG Settings"), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ArrayList<XOGRow> xogTable = new ArrayList<XOGRow>();
        int i = 0;
        while (i < this.answer.getInFiles().length) {
            XOGRow xogRow = new XOGRow();
            xogRow.setSelected(true);
            xogRow.setStatus(-1);
            xogRow.setFInput(this.answer.getInFiles()[i]);
            xogRow.setFOutput(null);
            xogTable.add(xogRow);
            ++i;
        }
        this.progressTable = new Table(new XogTableModel(xogTable));
        this.progressTable.setRowHeight(18);
        this.progressTable.getTableHeader().setPreferredSize(new Dimension(this.progressTable.getColumnModel().getTotalColumnWidth(), 24));
        this.progressTable.getColumnModel().getColumn(0).setMaxWidth(24);
        this.progressTable.getColumnModel().getColumn(0).setMinWidth(24);
        this.progressTable.getColumnModel().getColumn(1).setMaxWidth(48);
        this.progressTable.getColumnModel().getColumn(1).setMinWidth(48);
        this.progressTable.getColumnModel().getColumn(4).setMaxWidth(60);
        this.progressTable.getColumnModel().getColumn(5).setMinWidth(60);
        this.progressTable.getColumnModel().getColumn(5).setMaxWidth(60);
        this.progressTable.getColumnModel().getColumn(6).setMinWidth(60);
        this.progressTable.getColumnModel().getColumn(6).setMaxWidth(60);
        this.progressTable.getColumnModel().getColumn(6).setMinWidth(60);
        this.setTableRenders(this.progressTable);
        FeatureRowSorter fSorter = new FeatureRowSorter(this.progressTable.getModel());
        this.progressTable.setRowSorter(fSorter);
        JToolBar tableBar = new JToolBar();
        JButton jb2 = tableBar.add(new CheckAllAction(this.progressTable));
        jb2.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        jb2.setPreferredSize(new Dimension(32, 32));
        JButton jb3 = tableBar.add(new UnCheckAllAction(this.progressTable));
        jb3.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        jb3.setPreferredSize(new Dimension(32, 32));
        JButton jb4 = tableBar.add(new ExportResultAction(this.progressTable));
        jb4.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        jb4.setPreferredSize(new Dimension(32, 32));
        JPanel tablePane = new JPanel(new BorderLayout());
        tablePane.add((Component)tableBar, "North");
        tablePane.add((Component)new JScrollPane(this.progressTable), "Center");
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 3;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        contentPane.add((Component)tablePane, constraints);
        this.searchProgressBar = new JProgressBar();
        this.searchProgressBar.setStringPainted(true);
        this.searchProgressBar.setVisible(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 2;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 1.0;
        constraints.fill = 1;
        contentPane.add((Component)this.searchProgressBar, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 3;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 0.0;
        contentPane.add((Component)new JButton(this.searchCancelAction), constraints);
        this.messagesTextArea = new JTextArea();
        this.messagesTextArea.setEditable(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 3;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(contentPane);
        splitPane.setBottomComponent(new JScrollPane(this.messagesTextArea));
        splitPane.setResizeWeight(1.0);
        splitPane.setDividerLocation(450);
        splitPane.setDividerSize(8);
        splitPane.setOneTouchExpandable(true);
        this.getContentPane().add(splitPane);
    }

    private String addTimeExtension(String filename) {
        String suffix = "_" + this.getCurrentDate("yyyyMMdd_HHmmss");
        int indexExtension = filename.lastIndexOf(".");
        if (indexExtension < 0) {
            indexExtension = filename.length();
        }
        return String.valueOf(filename.substring(0, indexExtension)) + suffix + filename.substring(indexExtension);
    }

    private String getCurrentDate(String format) {
        String DATE_FORMAT = format;
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.format(new Date());
    }

    public void setTableRenders(JTable table) {
        table.getColumnModel().getColumn(0).setCellRenderer(new CheckBoxCellRenderer());
        table.getColumnModel().getColumn(0).setCellEditor(new CheckBoxCellEditor());
        table.getColumnModel().getColumn(1).setCellRenderer(new StatusTableRenderer());
        table.getColumnModel().getColumn(2).setCellRenderer(new CheckListButtonTableRenderer());
        table.getColumnModel().getColumn(2).setCellEditor(new CheckListButtonTableEditor());
        table.getColumnModel().getColumn(3).setCellRenderer(new CheckListButtonTableRenderer());
        table.getColumnModel().getColumn(3).setCellEditor(new CheckListButtonTableEditor());
        table.getColumnModel().getColumn(4).setCellRenderer(new XogResultRenderer(0));
        table.getColumnModel().getColumn(5).setCellRenderer(new XogResultRenderer(1));
        table.getColumnModel().getColumn(6).setCellRenderer(new XogResultRenderer(2));
    }

    public void center() {
        this.pack();
        if (this.getParent() == null) {
            Dimension dim = this.getToolkit().getScreenSize();
            int screenWidth = dim.width;
            int screenHeight = dim.height;
            int frameWidth = this.getPreferredSize().width;
            int frameHeight = this.getPreferredSize().height;
            this.setLocation((screenWidth - frameWidth) / 2, (screenHeight - frameHeight) / 2);
        } else {
            this.setLocationRelativeTo(this.getParent());
        }
    }

    private void search() {
        if (this.checkInput()) {
            this.messagesTextArea.setText("Starting XOG with target '" + this.config.getEnvironment() + "\n");
            this.xogMultiThreadWorker = new XogMultiThreadWorker(this.answer, Integer.parseInt(this.xogDisplayPanel.getFieldText(XogDisplayPanel.FieldTitle.THREADCOUNT)), this.messagesTextArea, this.progressTable);
            this.xogMultiThreadWorker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    System.out.println("event " + event.getPropertyName() + ":" + event.getNewValue());
                    if (event.getPropertyName().equals("progress")) {
                        StatusFrame.this.searchProgressBar.setIndeterminate(false);
                        StatusFrame.this.searchProgressBar.setValue((Integer)event.getNewValue());
                    } else if (event.getPropertyName().equals("statex")) {
                        StatusFrame.this.searchProgressBar.setVisible(false);
                        StatusFrame.this.searchCancelAction.putValue("Name", "Go");
                        StatusFrame.this.xogMultiThreadWorker = null;
                    } else if (event.getPropertyName().equals("state")) {
                        switch ((SwingWorker.StateValue)((Object)event.getNewValue())) {
                            case DONE: {
                                break;
                            }
                            case PENDING: 
                            case STARTED: {
                                StatusFrame.this.searchCancelAction.putValue("Name", "Cancel");
                                StatusFrame.this.searchProgressBar.setVisible(true);
                                StatusFrame.this.searchProgressBar.setIndeterminate(true);
                            }
                        }
                    }
                }
            });
            this.xogMultiThreadWorker.execute();
        }
    }

    private boolean checkInput() {
        if (this.xogDisplayPanel.getFieldText(XogDisplayPanel.FieldTitle.THREADCOUNT).length() == 0) {
            JOptionPane.showMessageDialog(this, "Nr of parallel XOG processes must be filled", "Input Error", 0);
            this.xogDisplayPanel.getField(XogDisplayPanel.FieldTitle.THREADCOUNT).requestFocusInWindow();
            return false;
        }
        return true;
    }

    public void showDialog() {
        this.setPreferredSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(150, 100));
        this.center();
        this.setDefaultCloseOperation(1);
        this.setVisible(true);
    }

    class FeatureRowSorter
    extends TableRowSorter<TableModel> {
        public FeatureRowSorter(TableModel tableModel) {
            super(tableModel);
        }

        @Override
        public Comparator<?> getComparator(int column) {
            if (column == 0) {
                return new Comparator(){

                    public int compare(Object o1, Object o2) {
                        XOGRow xogRow1 = (XOGRow)o1;
                        XOGRow xogRow2 = (XOGRow)o2;
                        return new Integer(xogRow1.isSelected() ? 1 : 0).compareTo(new Integer(xogRow2.isSelected() ? 1 : 0));
                    }
                };
            }
            if (column == 1) {
                return new Comparator(){

                    public int compare(Object o1, Object o2) {
                        XOGRow xogRow1 = (XOGRow)o1;
                        XOGRow xogRow2 = (XOGRow)o2;
                        return new Integer(xogRow1.getStatus()).compareTo(new Integer(xogRow2.getStatus()));
                    }
                };
            }
            if (column == 2) {
                return new Comparator(){

                    public int compare(Object o1, Object o2) {
                        XOGRow xogRow1 = (XOGRow)o1;
                        XOGRow xogRow2 = (XOGRow)o2;
                        return xogRow1.getFInput().getName().compareTo(xogRow2.getFInput().getName());
                    }
                };
            }
            return super.getComparator(column);
        }

        @Override
        protected boolean useToString(int column) {
            return false;
        }
    }
}

