/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.gui;

import com.dd.gui.components.Frame;
import com.dd.xog.saaj.gui.Table;
import com.dd.xog.saaj.listener.DelayedDocumentListener;
import com.dd.xog.saaj.preferences.PlugInPreferences;
import com.dd.xog.saaj.resources.ResourceLoader;
import com.dd.xog.saaj.table.CheckAllAction;
import com.dd.xog.saaj.table.CheckBoxCellEditor;
import com.dd.xog.saaj.table.CheckBoxCellRenderer;
import com.dd.xog.saaj.table.CheckListButtonTableEditor;
import com.dd.xog.saaj.table.CheckListButtonTableRenderer;
import com.dd.xog.saaj.table.ExportResultAction;
import com.dd.xog.saaj.table.StatusTableRenderer;
import com.dd.xog.saaj.table.UnCheckAllAction;
import com.dd.xog.saaj.table.XOGRow;
import com.dd.xog.saaj.table.XogResultRenderer;
import com.dd.xog.saaj.table.XogResultsTableModel;
import com.dd.xog.saaj.worker.WorkTask;
import com.dd.xog.saaj.worker.Worker;
import com.dd.xog.saaj.worker.XogResultMultiThreadWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.log4j.Logger;

public class ListXogResultsFrame
extends JFrame
implements WorkTask {
    private static final long serialVersionUID = -8668818312732181049L;
    private Action searchCancelAction;
    private Action browseAction;
    private JTextField directoryPathTextField;
    private JTextArea messagesTextArea;
    private JProgressBar searchProgressBar;
    private JTable progressTable;
    private XogResultMultiThreadWorker xogResultMultiThreadWorker;
    public static final int DO_LIST_FILES = 0;
    private static Logger log = Logger.getLogger(ListXogResultsFrame.class);
    private JFrame parent;
    DocumentListener editorListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            ListXogResultsFrame.this.processFolderChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ListXogResultsFrame.this.processFolderChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ListXogResultsFrame.this.processFolderChange();
        }
    };

    public ListXogResultsFrame(JFrame parent, String title) {
        this.parent = parent;
        this.setTitle(title);
        this.setIconImage(new ImageIcon(ResourceLoader.class.getResource("viewresults.png")).getImage());
        this.initActions();
        this.initComponents();
    }

    private void cancel() {
        this.xogResultMultiThreadWorker.cancel(false);
    }

    private void initActions() {
        this.browseAction = new AbstractAction("Browse"){
            private static final long serialVersionUID = 4669650683189592364L;

            @Override
            public void actionPerformed(ActionEvent e) {
                File dir = new File(ListXogResultsFrame.this.directoryPathTextField.getText()).getAbsoluteFile();
                JFileChooser fileChooser = new JFileChooser(dir.getParentFile());
                fileChooser.setDialogTitle("Select a folder which contains xog output files");
                fileChooser.setFileSelectionMode(1);
                int option = fileChooser.showOpenDialog(ListXogResultsFrame.this);
                if (option == 0) {
                    File selected = fileChooser.getSelectedFile();
                    ListXogResultsFrame.this.directoryPathTextField.setText(selected.getAbsolutePath());
                }
            }
        };
        this.browseAction.putValue("ShortDescription", "Select a folder which contains xog output files");
        this.searchCancelAction = new AbstractAction("Get Results"){
            private static final long serialVersionUID = 4669650683189592364L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ListXogResultsFrame.this.xogResultMultiThreadWorker == null) {
                    ListXogResultsFrame.this.search();
                } else {
                    ListXogResultsFrame.this.cancel();
                }
            }
        };
    }

    private void initComponents() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(2, 2, 2, 2);
        contentPane.add((Component)new JLabel("Folder: "), constraints);
        this.directoryPathTextField = new JTextField();
        this.directoryPathTextField.setText(PlugInPreferences.getInstance().getLastListXogResultDir());
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 1.0;
        constraints.fill = 1;
        contentPane.add((Component)this.directoryPathTextField, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.insets = new Insets(2, 2, 2, 2);
        contentPane.add((Component)new JButton(this.browseAction), constraints);
        this.progressTable = new Table(new XogResultsTableModel());
        this.processFolderChange();
        this.directoryPathTextField.getDocument().addDocumentListener(new DelayedDocumentListener(this.editorListener, 800));
        this.progressTable.setRowHeight(18);
        this.progressTable.getTableHeader().setPreferredSize(new Dimension(this.progressTable.getColumnModel().getTotalColumnWidth(), 24));
        this.progressTable.getColumnModel().getColumn(0).setMaxWidth(24);
        this.progressTable.getColumnModel().getColumn(0).setMinWidth(24);
        this.progressTable.getColumnModel().getColumn(1).setMaxWidth(48);
        this.progressTable.getColumnModel().getColumn(1).setMinWidth(48);
        this.progressTable.getColumnModel().getColumn(2).setMinWidth(400);
        this.progressTable.getColumnModel().getColumn(3).setMaxWidth(60);
        this.progressTable.getColumnModel().getColumn(3).setMinWidth(60);
        this.progressTable.getColumnModel().getColumn(4).setMaxWidth(60);
        this.progressTable.getColumnModel().getColumn(4).setMinWidth(60);
        this.progressTable.getColumnModel().getColumn(5).setMaxWidth(60);
        this.progressTable.getColumnModel().getColumn(5).setMinWidth(60);
        this.setTableRenders(this.progressTable);
        FeatureRowSorter fSorter = new FeatureRowSorter(this.progressTable.getModel());
        this.progressTable.setRowSorter(fSorter);
        JToolBar tableBar = new JToolBar();
        JButton jb2 = tableBar.add(new CheckAllAction(this.progressTable));
        jb2.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        jb2.setPreferredSize(new Dimension(32, 32));
        JButton jb3 = tableBar.add(new UnCheckAllAction(this.progressTable));
        jb3.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        jb3.setPreferredSize(new Dimension(32, 32));
        JButton jb4 = tableBar.add(new ExportResultAction(this.progressTable));
        jb4.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        jb4.setPreferredSize(new Dimension(32, 32));
        JPanel tablePane = new JPanel(new BorderLayout());
        tablePane.add((Component)tableBar, "North");
        tablePane.add((Component)new JScrollPane(this.progressTable), "Center");
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 3;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        contentPane.add((Component)tablePane, constraints);
        this.searchProgressBar = new JProgressBar();
        this.searchProgressBar.setStringPainted(true);
        this.searchProgressBar.setVisible(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 2;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 1.0;
        constraints.fill = 1;
        contentPane.add((Component)this.searchProgressBar, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 3;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 0.0;
        contentPane.add((Component)new JButton(this.searchCancelAction), constraints);
        this.messagesTextArea = new JTextArea();
        this.messagesTextArea.setEditable(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 3;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(contentPane);
        splitPane.setBottomComponent(new JScrollPane(this.messagesTextArea));
        splitPane.setResizeWeight(1.0);
        splitPane.setDividerLocation(450);
        splitPane.setDividerSize(8);
        splitPane.setOneTouchExpandable(true);
        this.getContentPane().add(splitPane);
    }

    private String addTimeExtension(String filename) {
        String suffix = "_" + this.getCurrentDate("yyyyMMdd_HHmmss");
        int indexExtension = filename.lastIndexOf(".");
        if (indexExtension < 0) {
            indexExtension = filename.length();
        }
        return String.valueOf(filename.substring(0, indexExtension)) + suffix + filename.substring(indexExtension);
    }

    private String getCurrentDate(String format) {
        String DATE_FORMAT = format;
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.format(new Date());
    }

    public void setTableRenders(JTable table) {
        table.getColumnModel().getColumn(0).setCellRenderer(new CheckBoxCellRenderer());
        table.getColumnModel().getColumn(0).setCellEditor(new CheckBoxCellEditor());
        table.getColumnModel().getColumn(1).setCellRenderer(new StatusTableRenderer());
        table.getColumnModel().getColumn(2).setCellRenderer(new CheckListButtonTableRenderer());
        table.getColumnModel().getColumn(2).setCellEditor(new CheckListButtonTableEditor());
        table.getColumnModel().getColumn(3).setCellRenderer(new XogResultRenderer(0));
        table.getColumnModel().getColumn(4).setCellRenderer(new XogResultRenderer(1));
        table.getColumnModel().getColumn(5).setCellRenderer(new XogResultRenderer(2));
    }

    public void center() {
        this.pack();
        if (this.getParent() == null) {
            Dimension dim = this.getToolkit().getScreenSize();
            int screenWidth = dim.width;
            int screenHeight = dim.height;
            int frameWidth = this.getPreferredSize().width;
            int frameHeight = this.getPreferredSize().height;
            this.setLocation((screenWidth - frameWidth) / 2, (screenHeight - frameHeight) / 2);
        } else {
            this.setLocationRelativeTo(this.getParent());
        }
    }

    private void search() {
        if (this.checkInput()) {
            this.messagesTextArea.setText("Start retrieving results for directory " + this.directoryPathTextField.getText().trim() + "\n");
            this.xogResultMultiThreadWorker = new XogResultMultiThreadWorker(1, this.messagesTextArea, this.progressTable);
            this.xogResultMultiThreadWorker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    System.out.println("event " + event.getPropertyName() + ":" + event.getNewValue());
                    if (event.getPropertyName().equals("progress")) {
                        ListXogResultsFrame.this.searchProgressBar.setIndeterminate(false);
                        ListXogResultsFrame.this.searchProgressBar.setValue((Integer)event.getNewValue());
                    } else if (event.getPropertyName().equals("statex")) {
                        ListXogResultsFrame.this.searchProgressBar.setVisible(false);
                        ListXogResultsFrame.this.searchCancelAction.putValue("Name", "Get Results");
                        ListXogResultsFrame.this.xogResultMultiThreadWorker = null;
                    } else if (event.getPropertyName().equals("state")) {
                        switch ((SwingWorker.StateValue)((Object)event.getNewValue())) {
                            case DONE: {
                                break;
                            }
                            case PENDING: 
                            case STARTED: {
                                ListXogResultsFrame.this.searchCancelAction.putValue("Name", "Cancel");
                                ListXogResultsFrame.this.searchProgressBar.setVisible(true);
                                ListXogResultsFrame.this.searchProgressBar.setIndeterminate(true);
                            }
                        }
                    }
                }
            });
            this.xogResultMultiThreadWorker.execute();
        }
    }

    private boolean checkInput() {
        return true;
    }

    public void showDialog() {
        this.setPreferredSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(150, 100));
        this.center();
        this.setDefaultCloseOperation(1);
        this.setVisible(true);
    }

    public void listFiles(File f) throws Throwable {
        XogResultsTableModel model = (XogResultsTableModel)this.progressTable.getModel();
        final int position = this.directoryPathTextField.getCaretPosition();
        File[] fileList = (File[])Worker.waitReadURL(this, 0, new Object[]{f}, this.isVisible() ? this : Frame.getInstance(), "Waiting while retrieving files", "Please wait while retrieving xog result files from " + f.getAbsolutePath() + ".\nThis can take a long time!", false);
        log.debug((Object)("setting cursor back on position  " + position));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ListXogResultsFrame.this.directoryPathTextField.requestFocusInWindow();
                ListXogResultsFrame.this.directoryPathTextField.setCaretPosition(position);
            }
        });
        if (fileList != null) {
            int i = 0;
            while (i < fileList.length) {
                XOGRow xogRow = new XOGRow();
                xogRow.setSelected(true);
                xogRow.setStatus(-1);
                xogRow.setFInput(fileList[i]);
                xogRow.setFOutput(null);
                model.addRow(xogRow);
                ++i;
            }
        }
    }

    private void processFolderChange() {
        try {
            File f;
            ArrayList<XOGRow> xogTable = new ArrayList<XOGRow>();
            XogResultsTableModel model = (XogResultsTableModel)this.progressTable.getModel();
            model.setXogTable(xogTable);
            if (this.directoryPathTextField.getText() != null && this.directoryPathTextField.getText().trim().length() > 0 && (f = new File(this.directoryPathTextField.getText().trim())).isDirectory()) {
                this.listFiles(new File(this.directoryPathTextField.getText().trim()));
                PlugInPreferences.getInstance().setLastListXogResultDir(this.directoryPathTextField.getText().trim());
            }
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this, t.toString(), "Listing files failed", 0);
        }
    }

    private File[] doListFiles(File f) {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().toLowerCase().endsWith(".xml");
            }
        };
        log.debug((Object)"listing files");
        File[] fileList = f.listFiles(filter);
        log.debug((Object)("nr files found " + fileList.length));
        return fileList;
    }

    @Override
    public Object doWork(int what, Object[] args) throws Exception {
        switch (what) {
            case 0: {
                return this.doListFiles((File)args[0]);
            }
        }
        throw new Exception("Unknown work");
    }

    class FeatureRowSorter
    extends TableRowSorter<TableModel> {
        public FeatureRowSorter(TableModel tableModel) {
            super(tableModel);
        }

        @Override
        public Comparator<?> getComparator(int column) {
            if (column == 0) {
                return new Comparator(){

                    public int compare(Object o1, Object o2) {
                        XOGRow xogRow1 = (XOGRow)o1;
                        XOGRow xogRow2 = (XOGRow)o2;
                        return new Integer(xogRow1.isSelected() ? 1 : 0).compareTo(new Integer(xogRow2.isSelected() ? 1 : 0));
                    }
                };
            }
            if (column == 1) {
                return new Comparator(){

                    public int compare(Object o1, Object o2) {
                        XOGRow xogRow1 = (XOGRow)o1;
                        XOGRow xogRow2 = (XOGRow)o2;
                        return new Integer(xogRow1.getStatus()).compareTo(new Integer(xogRow2.getStatus()));
                    }
                };
            }
            if (column == 2) {
                return new Comparator(){

                    public int compare(Object o1, Object o2) {
                        XOGRow xogRow1 = (XOGRow)o1;
                        XOGRow xogRow2 = (XOGRow)o2;
                        return xogRow1.getFInput().getName().compareTo(xogRow2.getFInput().getName());
                    }
                };
            }
            return super.getComparator(column);
        }

        @Override
        protected boolean useToString(int column) {
            return false;
        }
    }
}

