/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.configuration;

import com.dd.xog.saaj.configuration.Configuration;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ConfigurationList {
    private static ConfigurationList instance = null;
    ArrayList<Configuration> configurationList = new ArrayList();
    private static Logger log = Logger.getLogger(ConfigurationList.class);
    String path = null;

    private ConfigurationList(String path) {
        this.path = path;
        this.load();
    }

    public static ConfigurationList getInstance(String path) {
        if (instance == null) {
            instance = new ConfigurationList(path);
        }
        return instance;
    }

    public static ConfigurationList getInstance() {
        if (instance == null) {
            instance = new ConfigurationList("configurations");
        }
        return instance;
    }

    public void reload() {
        this.configurationList.clear();
        this.load();
    }

    public void load() {
        FilenameFilter filter;
        File[] files;
        File dir = new File(this.path);
        if (!dir.exists()) {
            log.error((Object)("com.dd.xog.saaj.configuration directory does not exist: " + this.path));
        }
        if (!dir.isDirectory()) {
            log.error((Object)("com.dd.xog.saaj.configuration directory is not a directory: " + this.path));
        }
        if ((files = dir.listFiles(filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        })) == null) {
            files = new File[]{};
        }
        int i = 0;
        while (i < files.length) {
            Configuration conf = null;
            try {
                conf = new Configuration(files[i]);
                this.configurationList.add(conf);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public Configuration getConfiguration(int index) {
        return this.configurationList.get(index);
    }

    public void addConfiguration(Configuration configuration) {
        this.configurationList.add(configuration);
    }

    public ArrayList<Configuration> getConfigurationList() {
        return this.configurationList;
    }

    public void setConfigurationList(ArrayList<Configuration> configurationList) {
        this.configurationList = configurationList;
    }
}

