/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.action;

import com.dd.gui.components.Frame;
import com.dd.handler.ContentHandler;
import com.dd.handler.PlugInManager;
import com.dd.sources.Source;
import com.dd.xog.saaj.configuration.Configuration;
import com.dd.xog.saaj.configuration.ConfigurationList;
import com.dd.xog.saaj.gui.Table;
import com.dd.xog.saaj.io.FileUtil;
import com.dd.xog.saaj.popup.XogPopup;
import com.dd.xog.saaj.popup.XogPopupVO;
import com.dd.xog.saaj.preferences.PlugInPreferences;
import com.dd.xog.saaj.resources.ResourceLoader;
import com.dd.xog.saaj.worker.Worker;
import com.dd.xog.saaj.xog.XOGSoapClient;
import com.dd.xog.saaj.xog.XOGresult;
import com.dd.xog.saaj.xog.Xogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.xml.soap.SOAPMessage;
import org.apache.log4j.Logger;

public class XOGTreeAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    File file = null;
    private XogPopupVO answer = null;
    private static Logger log = Logger.getLogger(XOGTreeAction.class);

    public XOGTreeAction(File file) {
        super("Run XOG action", new ImageIcon(ResourceLoader.class.getResource("xog.gif")));
        this.file = file;
        this.putValue("ShortDescription", "Run XOG action");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.answer == null) {
            this.initAnswer();
        }
        this.answer.setInputEnabled(false);
        this.answer.setIndxSelectedInput(this.answer.getIndxUseInputFile());
        this.answer.setInFile(this.file);
        if (this.answer.getOutDir() == null) {
            this.answer.setOutDir(this.file.getParentFile());
        }
        this.answer.setOutFileName(String.valueOf(PlugInPreferences.getInstance().getXogPrefix()) + FileUtil.getFileName(this.file) + PlugInPreferences.getInstance().getXogPostfix() + "." + FileUtil.getExtension(this.file, "xml"));
        XogPopup popup = new XogPopup((JFrame)Frame.getInstance(), "XOG Settings", true, this.answer);
        popup.showDialog();
        Configuration config = this.answer.getConfigurationList().getConfiguration(this.answer.getSelectedConfigurationIndex());
        if (this.answer.isActionOk() && this.confirmed(config)) {
            try {
                String inNameWithoutExtension = FileUtil.getFileName(this.file);
                String outNameWithoutExtension = FileUtil.getFileName(new File(this.answer.getOutFileName()));
                int indx = outNameWithoutExtension.indexOf(inNameWithoutExtension);
                if (indx > -1) {
                    PlugInPreferences.getInstance().setXogPrefix(outNameWithoutExtension.substring(0, indx));
                    if (indx + inNameWithoutExtension.length() < outNameWithoutExtension.length()) {
                        PlugInPreferences.getInstance().setXogPostfix(outNameWithoutExtension.substring(indx + inNameWithoutExtension.length()));
                    } else {
                        PlugInPreferences.getInstance().setXogPostfix("");
                    }
                }
                this.processAnswer(this.answer);
            }
            catch (Throwable t) {
                t.printStackTrace();
                JOptionPane.showMessageDialog((Component)Frame.getInstance(), t.toString(), "XOG throws exception", 0);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.file.isFile() && this.file.getName().endsWith(".xml");
    }

    private void initAnswer() {
        this.answer = new XogPopupVO();
        this.answer.setInfoText("Choose your target environment\n");
        this.answer.setConfigurationList(ConfigurationList.getInstance());
    }

    private boolean confirmed(Configuration config) {
        if (!config.getXOGSettings().isConfirm()) {
            return true;
        }
        Object[] options = new Object[]{"Cancel", "Ok"};
        int n = JOptionPane.showOptionDialog((Component)Frame.getInstance(), "Do you want to run the XOG on environment " + config.getEnvironment(), "Confirm environment", 0, 3, null, options, options[0]);
        return n == 1;
    }

    private void processAnswer(XogPopupVO answer) throws Throwable {
        Configuration config = answer.getConfigurationList().getConfiguration(answer.getSelectedConfigurationIndex());
        Xogger xogger = new Xogger(config);
        SOAPMessage soapResult = null;
        soapResult = (SOAPMessage)Worker.waitReadURL(xogger, 1, new Object[]{answer.getInFile()}, (Component)Frame.getInstance(), "Xogging " + answer.getInFile().getName(), "Please wait while executing xog", false);
        if (soapResult != null) {
            PlugInManager contentManager;
            XOGresult result = XOGSoapClient.getXOGresult(soapResult);
            this.logResults(result);
            if (result.getState() == null) {
                JOptionPane.showMessageDialog((Component)Frame.getInstance(), "XOG has unexpected result", "XOG Result", 0);
            } else {
                JPanel topPane = XOGTreeAction.buildDisplay(result);
                if (result.getOverallStatusIndication() == 0) {
                    JOptionPane.showMessageDialog((Component)Frame.getInstance(), topPane, "XOG Result", 1);
                } else if (result.getOverallStatusIndication() == 2) {
                    JOptionPane.showMessageDialog((Component)Frame.getInstance(), topPane, "XOG Result", 0);
                } else {
                    JOptionPane.showMessageDialog((Component)Frame.getInstance(), topPane, "XOG Result", 2);
                }
            }
            if (answer.getIndxSelectedAction() == answer.getIndxSaveToFile()) {
                FileUtil.writeToFile(new File(answer.getOutDir(), answer.getOutFileName()), XOGSoapClient.getContent(soapResult, true));
                if (answer.isOpenFile()) {
                    contentManager = PlugInManager.getInstance();
                    ContentHandler contentHandler = contentManager.getContentHandler("xml");
                    contentHandler.open(new File(answer.getOutDir(), answer.getOutFileName()));
                }
            } else {
                contentManager = PlugInManager.getInstance();
                ContentHandler contentHandler = contentManager.getContentHandler("xml");
                Source source = contentHandler.getSource();
                source.setName("xogresult");
                source.setContents(XOGSoapClient.getContent(soapResult, true));
                source.addProperty((Object)"key1", (Object)"this is important info");
                contentHandler.open(source);
                source.setChanged(true);
            }
        }
    }

    static JPanel buildDisplay(XOGresult result) {
        Object[][] cellData = new Object[][]{{result.getInsertedRecords(), result.getUpdatedRecords(), result.getFailureRecords()}};
        Object[] columnNames = new String[]{"inserts", "updates", "failures"};
        Table table = new Table(cellData, columnNames);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setPreferredSize(new Dimension(250, 70));
        JPanel topPane = new JPanel();
        topPane.setLayout(new BorderLayout());
        topPane.add((Component)scrollPane, "Center");
        JLabel label = new JLabel("Highest severity :");
        JTextField textField = new JTextField();
        textField.setEditable(false);
        textField.setText(XOGresult.getStatusDecription(result.getOverallStatusIndication()));
        textField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel headerPane = new JPanel(new GridLayout(1, 2));
        Border emptyBorder = BorderFactory.createEmptyBorder(20, 0, 20, 0);
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        CompoundBorder compBorder = new CompoundBorder(emptyBorder, loweredetched);
        headerPane.setBorder(compBorder);
        headerPane.add(label);
        headerPane.add(textField);
        topPane.add((Component)headerPane, "North");
        return topPane;
    }

    private void logResults(XOGresult result) {
        log.info((Object)("status " + result.getState()));
        log.info((Object)("failures " + result.getFailureRecords()));
        log.info((Object)("inserts " + result.getInsertedRecords()));
        log.info((Object)("updates " + result.getUpdatedRecords()));
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

