/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj.action;

import com.dd.gui.components.Frame;
import com.dd.handler.ContentHandler;
import com.dd.handler.PlugInManager;
import com.dd.sources.Source;
import com.dd.xog.saaj.ClarityPlugIn;
import com.dd.xog.saaj.action.XOGTreeAction;
import com.dd.xog.saaj.configuration.Configuration;
import com.dd.xog.saaj.configuration.ConfigurationList;
import com.dd.xog.saaj.gui.StatusDialog;
import com.dd.xog.saaj.gui.StatusFrame;
import com.dd.xog.saaj.io.FileUtil;
import com.dd.xog.saaj.popup.XogPopup;
import com.dd.xog.saaj.popup.XogPopupVO;
import com.dd.xog.saaj.preferences.PlugInPreferences;
import com.dd.xog.saaj.resources.ResourceLoader;
import com.dd.xog.saaj.worker.Worker;
import com.dd.xog.saaj.xog.XOGSoapClient;
import com.dd.xog.saaj.xog.XOGresult;
import com.dd.xog.saaj.xog.Xogger;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.xml.soap.SOAPMessage;
import org.apache.log4j.Logger;

public class XOGMenuAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private XogPopupVO globalAnswer = null;
    private static Logger log = Logger.getLogger(XOGMenuAction.class);

    public XOGMenuAction() {
        super("Run XOG action", new ImageIcon(ResourceLoader.class.getResource("xog.gif")));
        this.putValue("ShortDescription", "Run XOG action");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.globalAnswer == null) {
            this.initAnswer();
        }
        this.globalAnswer.setInputEnabled(true);
        XogPopup popup = new XogPopup((JFrame)Frame.getInstance(), "XOG Settings", true, this.globalAnswer);
        popup.showDialog();
        Configuration config = this.globalAnswer.getConfigurationList().getConfiguration(this.globalAnswer.getSelectedConfigurationIndex());
        if (this.globalAnswer.isActionOk() && this.confirmed(config)) {
            XogPopupVO answer = this.globalAnswer.clone(this.globalAnswer);
            if (answer.getInFile() != null && answer.getOutFileName() != null && answer.getInFile().exists() && answer.getInFile().isFile()) {
                String inNameWithoutExtension = FileUtil.getFileName(answer.getInFile());
                String outNameWithoutExtension = FileUtil.getFileName(new File(answer.getOutFileName()));
                int indx = outNameWithoutExtension.indexOf(inNameWithoutExtension);
                if (indx > -1) {
                    PlugInPreferences.getInstance().setXogPrefix(outNameWithoutExtension.substring(0, indx));
                    if (indx + inNameWithoutExtension.length() < outNameWithoutExtension.length()) {
                        PlugInPreferences.getInstance().setXogPostfix(outNameWithoutExtension.substring(indx + inNameWithoutExtension.length()));
                    } else {
                        PlugInPreferences.getInstance().setXogPostfix("");
                    }
                }
            }
            try {
                this.processAnswer(answer);
            }
            catch (Throwable t) {
                t.printStackTrace();
                JOptionPane.showMessageDialog((Component)Frame.getInstance(), t.toString(), "XOG throws exception", 0);
            }
        }
    }

    private void initAnswer() {
        this.globalAnswer = new XogPopupVO();
        this.globalAnswer.setInfoText("Choose your target environment\n");
        this.globalAnswer.setConfigurationList(ConfigurationList.getInstance());
    }

    private boolean confirmed(Configuration config) {
        if (!config.getXOGSettings().isConfirm()) {
            return true;
        }
        Object[] options = new Object[]{"Cancel", "Ok"};
        int n = JOptionPane.showOptionDialog((Component)Frame.getInstance(), "Do you want to run the XOG on environment " + config.getEnvironment(), "Confirm environment", 0, 3, null, options, options[0]);
        return n == 1;
    }

    private void processAnswer(XogPopupVO answer) throws Throwable {
        Configuration config = answer.getConfigurationList().getConfiguration(answer.getSelectedConfigurationIndex());
        Xogger xogger = new Xogger(config);
        SOAPMessage soapResult = null;
        if (answer.getIndxSelectedInput() == answer.getIndxUseCurrentTab()) {
            Source xogSource = Frame.getInstance().getActiveSource();
            soapResult = (SOAPMessage)Worker.waitReadURL(xogger, 0, new Object[]{xogSource}, (Component)Frame.getInstance(), "Xogging " + xogSource.getName(), "Please wait while executing xog", false);
        } else if (answer.getIndxSelectedInput() == answer.getIndxUseInputFile()) {
            soapResult = (SOAPMessage)Worker.waitReadURL(xogger, 1, new Object[]{answer.getInFile()}, (Component)Frame.getInstance(), "Xogging " + answer.getInFile().getName(), "Please wait while executing xog", false);
        } else if (answer.getIndxSelectedInput() == answer.getIndxUseMultipleFiles()) {
            if (ClarityPlugIn.USE_ON_TOP_STATUS_DIALOG) {
                StatusDialog statusDialog = new StatusDialog((JFrame)Frame.getInstance(), "XOG multiple files", answer);
                statusDialog.showDialog();
            } else {
                StatusFrame statusFrame = new StatusFrame((JFrame)Frame.getInstance(), "XOG multiple files", answer);
                statusFrame.showDialog();
            }
            soapResult = null;
        }
        if (soapResult != null) {
            PlugInManager contentManager;
            XOGresult result = XOGSoapClient.getXOGresult(soapResult);
            this.logResults(result);
            if (result.getState() != null) {
                JPanel topPane = XOGTreeAction.buildDisplay(result);
                if (result.getOverallStatusIndication() == 0) {
                    JOptionPane.showMessageDialog((Component)Frame.getInstance(), topPane, "XOG Result", 1);
                } else if (result.getOverallStatusIndication() == 2) {
                    JOptionPane.showMessageDialog((Component)Frame.getInstance(), topPane, "XOG Result", 0);
                } else {
                    JOptionPane.showMessageDialog((Component)Frame.getInstance(), topPane, "XOG Result", 2);
                }
            }
            if (answer.getIndxSelectedAction() == answer.getIndxSaveToFile() && answer.getIndxSelectedInput() != answer.getIndxUseMultipleFiles()) {
                FileUtil.writeToFile(new File(answer.getOutDir(), answer.getOutFileName()), XOGSoapClient.getContent(soapResult, true));
                if (answer.isOpenFile()) {
                    contentManager = PlugInManager.getInstance();
                    ContentHandler contentHandler = contentManager.getContentHandler("xml");
                    contentHandler.open(new File(answer.getOutDir(), answer.getOutFileName()));
                }
            } else {
                contentManager = PlugInManager.getInstance();
                ContentHandler contentHandler = contentManager.getContentHandler("xml");
                Source source = contentHandler.getSource();
                source.setName("xogresult");
                source.setContents(XOGSoapClient.getContent(soapResult, true));
                source.addProperty((Object)"key1", (Object)"this is important info");
                contentHandler.open(source);
                source.setChanged(true);
            }
        }
    }

    public String addTimeExtension(String filename) {
        String suffix = "_" + this.getCurrentDate("yyyyMMdd_HHmmss");
        int indexExtension = filename.lastIndexOf(".");
        if (indexExtension < 0) {
            indexExtension = filename.length();
        }
        return String.valueOf(filename.substring(0, indexExtension)) + suffix + filename.substring(indexExtension);
    }

    public String getCurrentDate(String format) {
        String DATE_FORMAT = format;
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.format(new Date());
    }

    private void logResults(XOGresult result) {
        log.info((Object)("status " + result.getState()));
        log.info((Object)("failures " + result.getFailureRecords()));
        log.info((Object)("inserts " + result.getInsertedRecords()));
        log.info((Object)("updates " + result.getUpdatedRecords()));
        log.info((Object)("highest severity " + result.getHighestSeverity()));
    }
}

