/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xog.saaj;

import com.dd.gui.components.Frame;
import com.dd.handler.Adapter;
import com.dd.xog.saaj.action.ListXogResultsAction;
import com.dd.xog.saaj.action.ReloadConfigurationAction;
import com.dd.xog.saaj.action.XOGMenuAction;
import com.dd.xog.saaj.action.XOGTreeAction;
import com.dd.xog.saaj.resources.ResourceLoader;
import com.dd.xog.saaj.ssl.StoreCertTrustManager;
import com.dd.xog.saaj.ssl.TrustAllCertManager;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import org.apache.axis.AxisProperties;
import org.apache.log4j.Logger;

public class ClarityPlugIn
extends Adapter {
    public static boolean SHOW_UNICODE_CHARACTERS = false;
    public static boolean USE_ON_TOP_STATUS_DIALOG = false;
    public static boolean USE_ON_TOP_RESULTS_DIALOG = false;
    public static String provider = "DonkeyDevelopment";
    public static final String name = "Clarity XOG PlugIn";
    public static final String version = "3.23";
    public static final String versionDate = "2015/03/24";
    private static Logger log = Logger.getLogger(ClarityPlugIn.class);
    private XOGTreeAction xogTreeAction = null;

    public ClarityPlugIn(Frame frame) {
        super(frame);
        try {
            System.setProperty("java.protocol.handler.pkgs", "javax.net.ssl");
            System.setProperty("org.apache.axis.components.net.TransportClientProperties", "com.dd.xog.saaj.axis.MyHTTPTransportClientProperties");
            Properties props = this.loadProperties();
            boolean trustAllCertificatesBoolean = false;
            X509TrustManager trustManager = null;
            if (props != null) {
                trustAllCertificatesBoolean = Boolean.parseBoolean(props.getProperty("trustAllCertificates"));
                SHOW_UNICODE_CHARACTERS = Boolean.parseBoolean(props.getProperty("showUnicodeCharacters"));
                USE_ON_TOP_STATUS_DIALOG = Boolean.parseBoolean(props.getProperty("useOnTopStatusDialog"));
                USE_ON_TOP_RESULTS_DIALOG = Boolean.parseBoolean(props.getProperty("useOnTopResultsDialog"));
            }
            if (SHOW_UNICODE_CHARACTERS) {
                log.info((Object)"Unicode character notatation will be showed in response");
            }
            if (trustAllCertificatesBoolean) {
                log.info((Object)"All SSL certificates will be accepted !!");
                AxisProperties.setProperty((String)"axis.socketSecureFactory", (String)"org.apache.axis.components.net.SunFakeTrustSocketFactory");
                trustManager = new TrustAllCertManager();
            } else {
                AxisProperties.setProperty((String)"axis.socketSecureFactory", (String)"com.dd.xog.saaj.axis.MyCustomSSLSocketFactory");
                trustManager = new StoreCertTrustManager();
            }
            SSLContext sc = SSLContext.getInstance("SSL", "SunJSSE");
            sc.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    System.out.println("Warning: URL Host: " + urlHostName + " vs. " + (session != null ? session.getPeerHost() : ""));
                    return true;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Properties loadProperties() {
        Properties props = new Properties();
        try {
            File fProps = new File("configurations", "plugin.properties");
            if (fProps.exists()) {
                log.info((Object)"found plugin.props");
                FileInputStream fis = new FileInputStream(fProps);
                props.load(fis);
                fis.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"could not load plugin properties");
        }
        return props;
    }

    public void appReady() {
        log.debug((Object)"appReady");
        JMenu menu = new JMenu("Clarity");
        menu.add(new XOGMenuAction());
        menu.add(new ListXogResultsAction());
        menu.addSeparator();
        menu.add(new ReloadConfigurationAction());
        int menuCount = Frame.getInstance().getMenu().getMenuCount();
        int i = 0;
        while (i < menuCount) {
            JMenu menuItem = Frame.getInstance().getMenu().getMenu(i);
            if (menuItem.getText().equals("Translations") || menuItem.getText().equals("Conversion")) {
                Frame.getInstance().getMenu().add((Component)menu, i + 1);
                break;
            }
            ++i;
        }
        Frame.getInstance().getMenu().revalidate();
    }

    public AbstractAction[] getImportActions() {
        return new AbstractAction[0];
    }

    public AbstractAction[] getExportActions() {
        return new AbstractAction[0];
    }

    public AbstractAction[] getProjectTreeActions(Object object) {
        if (object instanceof File) {
            File file = (File)object;
            if (this.xogTreeAction == null) {
                this.xogTreeAction = new XOGTreeAction(file);
            } else {
                this.xogTreeAction.setFile(file);
            }
            return new AbstractAction[]{this.xogTreeAction};
        }
        return null;
    }

    public String getName() {
        return name;
    }

    public String getProvider() {
        return provider;
    }

    public String getVersion() {
        return version;
    }

    public String getVersionDate() {
        return versionDate;
    }

    public URL getMoreInfo() {
        return ResourceLoader.class.getResource("about.html");
    }
}

