/*
 * Decompiled with CFR 0.152.
 */
package com.dd.xml.handler;

import com.dd.XMLSpear;
import com.dd.gui.components.Frame;
import com.dd.gui.components.SourceComponentManager;
import com.dd.handler.ContentEditor;
import com.dd.resources.html.HTMLResourceLoader;
import com.dd.resources.images.ImageResourceLoader;
import com.dd.resources.xml.XMLResourceLoader;
import com.dd.sources.Source;
import com.dd.xml.sources.XMLSource;
import com.donkeydevelopment.A;
import com.donkeydevelopment.H;
import com.donkeydevelopment.P;
import com.donkeydevelopment.S;
import com.donkeydevelopment.Y;
import com.donkeydevelopment.aD;
import com.donkeydevelopment.ad;
import com.donkeydevelopment.ae;
import com.donkeydevelopment.bF;
import com.donkeydevelopment.bI;
import com.donkeydevelopment.cW;
import com.donkeydevelopment.ca;
import com.donkeydevelopment.dJ;
import com.donkeydevelopment.fw;
import com.donkeydevelopment.hG;
import com.donkeydevelopment.hZ;
import com.donkeydevelopment.iP;
import com.donkeydevelopment.iQ;
import com.donkeydevelopment.im;
import com.donkeydevelopment.ja;
import com.donkeydevelopment.jt;
import com.donkeydevelopment.xmlspear.Preferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.text.Document;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.util.XMLCatalogResolver;

public class XMLHandler
extends ContentEditor {
    public static String provider = "DonkeyDevelopment";
    public static final String name = "XML Editor";
    public static final String version = "3.22";
    public static final String versionDate = "2016/01/26";
    public String[] handledExtensions = new String[]{"xml", "xsd", "xsl", "xslt", "plist", "jnlp", "dict", "gpx"};
    public final String[] handledNewExtensions = new String[]{"xml", "xsl", "xsd"};
    private static File dtdDir = null;
    private static XMLCatalogResolver catalogResolver;

    public XMLHandler(Frame frame) {
        super(frame);
        this.handledExtensions = Preferences.getHandledExtensions(this, this.handledExtensions);
    }

    private void setUpCatalog() {
        dtdDir = P.a();
        if (dtdDir != null) {
            this.prepareLocalSchemas(dtdDir, "PropertyList-1.0.dtd");
            this.prepareLocalSchemas(dtdDir, "XMLSchema.dtd");
            this.prepareLocalSchemas(dtdDir, "XMLSchema.xsd");
            this.prepareLocalSchemas(dtdDir, "datatypes.dtd");
            this.prepareLocalSchemas(dtdDir, "xml.xsd");
            this.prepareLocalSchemas(dtdDir, "xslt20.xsd");
            return;
        }
        JOptionPane.showMessageDialog(Frame.getInstance(), "Could not create direcory for local schemas", "Create directory failed", 0);
    }

    public static XMLCatalogResolver getXMLCatalogResolver() {
        if (catalogResolver == null) {
            catalogResolver = new XMLCatalogResolver();
            boolean bl2 = true;
            ArrayList<String> arrayList = new ArrayList<String>();
            Properties properties = XMLSpear.a();
            if (properties != null) {
                int n2 = 0;
                while (bl2) {
                    String string = properties.getProperty("catalog[" + n2 + "]");
                    if (string == null) {
                        bl2 = false;
                    } else {
                        arrayList.add(string);
                    }
                    ++n2;
                }
            }
            String[] stringArray = new String[arrayList.size()];
            int n3 = 0;
            while (n3 < arrayList.size()) {
                stringArray[n3] = (String)arrayList.get(n3);
                ++n3;
            }
            catalogResolver.setCatalogList(stringArray);
        }
        return catalogResolver;
    }

    public void prepareLocalSchemas(File file, String string) {
        try {
            int n2;
            File file2;
            URL uRL = XMLResourceLoader.class.getResource(string);
            if (uRL != null && !(file2 = new File(file, string.substring((n2 = string.lastIndexOf("/")) + 1))).exists()) {
                P.a(uRL, file2, false);
                return;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            JOptionPane.showMessageDialog(Frame.getInstance(), "Could create local resource " + string + " in folder " + file, "Local resource failed", 0);
        }
    }

    @Override
    public void newDoc(String string) {
        String string2;
        System.out.println("Create new xml document");
        XMLSource xMLSource = new XMLSource();
        xMLSource.setContents("");
        xMLSource.setExtensionNew(string);
        if (string != null && string.endsWith("xsd")) {
            string2 = P.a(XMLResourceLoader.class.getResource("new.xsd"), "UTF-8");
            if (string2 != null) {
                xMLSource.setContents(string2);
            }
            xMLSource.setSchemaValidationType(0);
        }
        if (string != null && string.endsWith("xsl")) {
            string2 = P.a(XMLResourceLoader.class.getResource("new.xsl"), "UTF-8");
            if (string2 != null) {
                xMLSource.setContents(string2);
            }
            xMLSource.setSchemaValidationType(0);
        }
        if (string != null && string.endsWith("xml") && (string2 = P.a(XMLResourceLoader.class.getResource("new.xml"), "UTF-8")) != null) {
            xMLSource.setContents(string2);
        }
        this.setupTabbedFrame(xMLSource);
    }

    public boolean checkSize(File file) {
        if (file != null && file.length() > jt.a) {
            StringBuffer stringBuffer = new StringBuffer();
            Object[] objectArray = BigDecimal.valueOf(file.length()).setScale(2, 4);
            if (file.length() < 1024L) {
                stringBuffer.append(file.length());
                stringBuffer.append(" bytes");
            } else if (file.length() < 0x100000L) {
                objectArray = objectArray.divide(BigDecimal.valueOf(1024L), 4);
                stringBuffer.append(objectArray);
                stringBuffer.append(" KB");
                stringBuffer.append(" (");
                stringBuffer.append(file.length());
                stringBuffer.append(" bytes");
                stringBuffer.append(")");
            } else if (file.length() < 0x40000000L) {
                objectArray = objectArray.divide(BigDecimal.valueOf(0x100000L), 4);
                stringBuffer.append(objectArray);
                stringBuffer.append(" MB");
                stringBuffer.append(" (");
                stringBuffer.append(file.length());
                stringBuffer.append(" bytes");
                stringBuffer.append(")");
            } else {
                objectArray = objectArray.divide(BigDecimal.valueOf(0x40000000L), 4);
                stringBuffer.append(objectArray);
                stringBuffer.append(" GB");
                stringBuffer.append(" (");
                stringBuffer.append(file.length());
                stringBuffer.append(" bytes");
                stringBuffer.append(")");
            }
            objectArray = new Object[]{"Stop", "Continue"};
            int n2 = JOptionPane.showOptionDialog(Frame.getInstance(), "\nXMLSpear is not capable for handling very big files.\nThis file is " + stringBuffer + ", which is greater than the maximum size" + "\nspecified in the configuration (" + jt.a + " bytes)." + "\nOpening of this file may (but not necessary) be slow or freeze the GUI." + "\nIf there are any unsaved changes within XMLSpear then save them first!!" + "\n " + "\nBy the way:" + "\nYou can change the maximum filesize settings in the XMLSpear.properties." + "\nThis file is located in the XMLSpear application folder", "Confirm reload", 0, 3, null, objectArray, objectArray[0]);
            if (n2 == 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void open(File object) {
        if (!this.checkSize((File)object)) {
            return;
        }
        XMLSource xMLSource = new XMLSource((File)object);
        aD aD2 = new aD();
        Object object2 = new ArrayList<String>();
        ((ArrayList)object2).add("System default (" + System.getProperty("file.encoding") + ")");
        ((ArrayList)object2).add("UTF-8");
        if (H.b()) {
            ((ArrayList)object2).add("Binary Property List");
        }
        ((ArrayList)object2).add("UTF-16");
        ((ArrayList)object2).add("UTF-16BE");
        ((ArrayList)object2).add("UTF-16LE");
        ((ArrayList)object2).add("ISO-8859-1");
        ((ArrayList)object2).add("ISO-8859-2");
        ((ArrayList)object2).add("ISO-8859-3");
        ((ArrayList)object2).add("ISO-8859-4");
        ((ArrayList)object2).add("ISO-8859-5");
        ((ArrayList)object2).add("ISO-8859-6");
        ((ArrayList)object2).add("ISO-8859-7");
        ((ArrayList)object2).add("ISO-8859-8");
        ((ArrayList)object2).add("ISO-8859-9");
        ((ArrayList)object2).add("US-ASCII");
        boolean bl2 = jt.f;
        Object object3 = aD2;
        aD2.b = bl2;
        ArrayList<String> arrayList = object2;
        object3 = aD2;
        aD2.a = arrayList;
        int n2 = 1;
        object3 = aD2;
        aD2.a = n2;
        String string = System.getProperty("line.separator");
        object3 = aD2;
        aD2.d = string;
        string = ((File)object).getAbsolutePath();
        object3 = aD2;
        aD2.a = string;
        object2 = new fw((JFrame)Frame.getInstance(), "File Encoding Chooser", true, aD2);
        ((fw)object2).a();
        if (!aD2.isActionOk()) {
            return;
        }
        object3 = aD2;
        xMLSource.setFileEncoding(((aD)object3).b);
        object2 = aD2;
        xMLSource.setFileXMLEncoding(((aD)object2).c);
        object3 = aD2;
        xMLSource.setFileBOM(((aD)object3).a);
        System.out.println("Used encoding " + xMLSource.getFileEncoding());
        object3 = aD2;
        xMLSource.setEndOfLineString(((aD)object3).d);
        if (xMLSource.getFileEncoding().equals("Binary Property List")) {
            xMLSource.setFileEncoding("UTF-8");
            xMLSource.setBinaryPist(true);
            object2 = aD2;
            xMLSource.setFile(((aD)object2).a);
            xMLSource.addProperty("origin", object);
            xMLSource.setName(((File)object).getName());
            xMLSource.setToolTip(((File)object).getAbsolutePath());
        }
        if ((xMLSource.getFile().getAbsolutePath().endsWith(".plist") || xMLSource.isBinaryPist()) && P.a(xMLSource.getFile())) {
            xMLSource.setSchemaValidationType(1);
        }
        try {
            if (!jt.i) {
                object3 = xMLSource.getDocumentModel();
                object = ((dJ)object3).a;
                ((bF)object).a(xMLSource.getFile().getAbsolutePath());
            }
        }
        catch (Exception exception) {
            System.out.println("DomHandler read failed reason " + exception.toString());
        }
        if (xMLSource.getUrl() != null && xMLSource.getUrl().toString().endsWith("xsd")) {
            xMLSource.setSchemaValidationType(0);
        }
        if (xMLSource.getUrl() != null && xMLSource.getUrl().toString().endsWith("xsl")) {
            xMLSource.setSchemaValidationType(0);
        }
        this.setupTabbedFrame(xMLSource);
    }

    @Override
    public void open(Source source) {
        try {
            source.getContents();
        }
        catch (Exception exception) {}
        this.setupTabbedFrame((XMLSource)source);
    }

    public void setupTabbedFrame(XMLSource object) {
        SourceComponentManager sourceComponentManager;
        SourceComponentManager sourceComponentManager2 = sourceComponentManager = new SourceComponentManager(this, (Source)object);
        Object object2 = ((XMLSource)object).getDocumentModel();
        ((XMLSource)object).getDocumentModel().a = sourceComponentManager2;
        object2 = new A(sourceComponentManager, (XMLSource)object);
        sourceComponentManager.addComponentAt((iQ)object2, 1);
        sourceComponentManager.addComponentAt(new cW("Problems", (XMLSource)object), 3);
        sourceComponentManager.setSouthSelectedComponent(sourceComponentManager.getNamedComponent("Problems", 3));
        sourceComponentManager.addComponentAt(new bI("SchemaMappings", (XMLSource)object), 3);
        sourceComponentManager.addComponentAt(new im("Xpath", (XMLSource)object), 3);
        Frame.getInstance().addComponentManager(sourceComponentManager);
        if (((XMLSource)object).getDocument() != null) {
            object = new S((Y)sourceComponentManager, ((XMLSource)object).getDocument());
            sourceComponentManager.fireEvent((hG)object);
        }
    }

    @Override
    public void save() {
        Object object;
        Object object2 = Frame.getInstance().getComponentManager();
        object2 = (XMLSource)((SourceComponentManager)object2).getSource();
        String string = null;
        if (!((Source)object2).isFile()) {
            this.saveAs();
            return;
        }
        System.out.println(this.getClass() + " source.getCurrentXMLEncoding() " + ((XMLSource)object2).getCurrentXMLEncoding());
        System.out.println(this.getClass() + " source.getFileXMLEncoding() " + ((XMLSource)object2).getFileXMLEncoding());
        if (((XMLSource)object2).getFileXMLEncoding() == null) {
            if (((XMLSource)object2).getCurrentXMLEncoding() != null && !((XMLSource)object2).getCurrentXMLEncoding().equals(((XMLSource)object2).getFileEncoding())) {
                string = "XML Encoding changed from " + ((XMLSource)object2).getFileXMLEncoding() + " to " + ((XMLSource)object2).getCurrentXMLEncoding() + "." + "\n" + "The current FileEncoding is " + ((XMLSource)object2).getFileEncoding() + ".\n" + "It is recommended to use the encoding mentioned in the XML.\n" + "To do so, press the Option button in the sava-as dialog.\n";
            }
        } else if (((XMLSource)object2).getCurrentXMLEncoding() == null) {
            if (((XMLSource)object2).getFileEncoding() != "UTF-8") {
                string = "XML Encoding changed from " + ((XMLSource)object2).getFileXMLEncoding() + " to " + ((XMLSource)object2).getCurrentXMLEncoding() + "." + "\n" + "The current FileEncoding is " + ((XMLSource)object2).getFileEncoding() + ".\n" + "In this case it is recommended to use UTF-8.\n" + "To do so, press the Option button in the sava-as dialog.\n";
            }
        } else if (!((XMLSource)object2).getCurrentXMLEncoding().equalsIgnoreCase(((XMLSource)object2).getFileXMLEncoding()) && !((XMLSource)object2).getCurrentXMLEncoding().equalsIgnoreCase(((XMLSource)object2).getFileEncoding())) {
            string = "XML Encoding changed from " + ((XMLSource)object2).getFileXMLEncoding() + " to " + ((XMLSource)object2).getCurrentXMLEncoding() + "." + "\n" + "The current FileEncoding is " + ((XMLSource)object2).getFileEncoding() + ".\n" + "It is recommended to use the encoding mentioned in the XML.\n" + "To do so, press the Option button in the sava-as dialog.\n";
        }
        if (string != null) {
            object = new Object[]{"Cancel save", "Save anyway", "Show saveAs"};
            int n2 = JOptionPane.showOptionDialog(Frame.getInstance(), string, "Save alert", 1, 2, null, (Object[])object, object[2]);
            if (n2 == 2) {
                this.saveAs();
                return;
            }
            if (n2 == 0) {
                return;
            }
        }
        if (this.writeToFile((XMLSource)object2, ((Source)object2).getFile(), ((XMLSource)object2).getFileEncoding(), ((XMLSource)object2).isFileBOM(), ((XMLSource)object2).getEndOfLineString())) {
            ((XMLSource)object2).setFileXMLEncoding(((XMLSource)object2).getCurrentXMLEncoding());
            if (((XMLSource)object2).isBinaryPist()) {
                object = (File)((Source)object2).getProperty("origin");
                if (P.a(((Source)object2).getFile(), (File)object)) {
                    System.out.println("File " + ((File)object).getAbsolutePath() + " successfully saved");
                    ((Source)object2).setChanged(false);
                    return;
                }
                JOptionPane.showMessageDialog(Frame.getInstance(), "Preference file was not save due to error", "Save Failed", 0);
                return;
            }
            System.out.println("File " + ((Source)object2).getFile().getAbsolutePath() + " successfully saved");
            ((Source)object2).setChanged(false);
        }
    }

    @Override
    public void saveAs() {
        Serializable serializable;
        boolean bl2 = false;
        SourceComponentManager sourceComponentManager = Frame.getInstance().getComponentManager();
        XMLSource xMLSource = (XMLSource)sourceComponentManager.getSource();
        ja ja2 = new ja();
        ja2.setDialogTitle("Save As...");
        ja2.setFileSelectionMode(0);
        ja2.addChoosableFileFilter(new hZ());
        if (xMLSource.getFile() != null) {
            if (xMLSource.isBinaryPist()) {
                serializable = (File)xMLSource.getProperty("origin");
                if (serializable != null) {
                    ja2.setSelectedFile((File)serializable);
                }
            } else {
                ja2.setSelectedFile(xMLSource.getFile());
            }
        } else if (Preferences.getLastDirectory() != null) {
            try {
                serializable = new File(Preferences.getLastDirectory());
                if (((File)serializable).exists() && ((File)serializable).canRead()) {
                    ja2.setCurrentDirectory((File)serializable);
                }
            }
            catch (Exception exception) {
            }
            catch (Throwable throwable) {}
        }
        serializable = new JPanel(new BorderLayout());
        Object[] objectArray = new ad(xMLSource);
        Object[] objectArray2 = new JButton((Action)objectArray);
        ((Container)serializable).add((Component)objectArray2, "South");
        objectArray2 = new JPanel();
        ((Container)serializable).add((Component)objectArray2, "Center");
        ja2.setAccessory((JComponent)serializable);
        int n2 = ja2.showSaveDialog(Frame.getInstance());
        if (n2 == 0) {
            if (ja2.getSelectedFile() != null) {
                if (ja2.getSelectedFile().exists() && xMLSource.getFile() != null && !xMLSource.getFile().getAbsolutePath().equals(ja2.getSelectedFile().getAbsolutePath())) {
                    objectArray2 = new Object[]{"Cancel", "Replace"};
                    n2 = JOptionPane.showOptionDialog(Frame.getInstance(), "A file with the same name already exists. If you choose to replace it, the contents will be overwritten", "Replace alert", 1, 2, null, objectArray2, objectArray2[1]);
                    if (n2 == 0) {
                        return;
                    }
                }
                if (ja2.getSelectedFile().getParentFile() != null) {
                    Preferences.setLastDirectory(ja2.getSelectedFile().getParentFile().getAbsolutePath());
                }
            }
            Object object = ja2.getSelectedFile();
            objectArray = objectArray2 = objectArray.a;
            if (objectArray2.a.equals("Binary Property List")) {
                String string = "UTF-8";
                objectArray = objectArray2;
                objectArray2.a = string;
                bl2 = true;
                xMLSource.isBinaryPist();
                try {
                    object = File.createTempFile(ja2.getSelectedFile().getName(), ".xml");
                    ((File)object).deleteOnExit();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(Frame.getInstance(), "Creation of temporary file failed", "Save Failed", 0);
                    iOException.printStackTrace();
                    return;
                }
            }
            objectArray = objectArray2;
            objectArray = objectArray2;
            objectArray = objectArray2;
            if (this.writeToFile(xMLSource, (File)object, objectArray2.a, objectArray2.a, objectArray2.b)) {
                if (bl2) {
                    if (P.a((File)object, ja2.getSelectedFile())) {
                        xMLSource.setSourceFile((File)object);
                        xMLSource.addProperty("origin", ja2.getSelectedFile());
                        objectArray = objectArray2;
                        xMLSource.setFileEncoding(objectArray2.a);
                        objectArray = objectArray2;
                        xMLSource.setFileBOM(objectArray2.a);
                        objectArray = objectArray2;
                        xMLSource.setEndOfLineString(objectArray2.b);
                        xMLSource.setFileXMLEncoding(xMLSource.getCurrentXMLEncoding());
                        System.out.println(this.getClass() + " saveAs");
                        System.out.println(String.valueOf(ja2.getSelectedFile().getAbsolutePath()) + " succesfully saved");
                        xMLSource.setChanged(false);
                        xMLSource.setBinaryPist(true);
                        this.printFileProps(xMLSource);
                        object = sourceComponentManager.getSelectedComponent(1);
                        xMLSource.setName(ja2.getSelectedFile().getName());
                        xMLSource.setToolTip(ja2.getSelectedFile().getAbsolutePath());
                        ((iQ)object).a(xMLSource.getName());
                        ((iQ)object).b(xMLSource.getToolTip());
                        return;
                    }
                    JOptionPane.showMessageDialog(Frame.getInstance(), "Preference file was not save due to error", "Save Failed", 0);
                    return;
                }
                object = null;
                if (xMLSource.isFile()) {
                    object = P.a(xMLSource.getFile());
                } else if (xMLSource.getUrl() != null) {
                    object = xMLSource.getUrl().toString();
                }
                xMLSource.getMappingTableModel().a((String)object, P.a(ja2.getSelectedFile()));
                xMLSource.setSourceFile(ja2.getSelectedFile());
                if (xMLSource.getDocument() != null) {
                    CoreDocumentImpl coreDocumentImpl = (CoreDocumentImpl)xMLSource.getDocument();
                    coreDocumentImpl.setDocumentURI(P.a(ja2.getSelectedFile()));
                }
                objectArray = objectArray2;
                xMLSource.setFileEncoding(objectArray2.a);
                objectArray = objectArray2;
                xMLSource.setFileBOM(objectArray2.a);
                objectArray = objectArray2;
                xMLSource.setEndOfLineString(objectArray2.b);
                xMLSource.setFileXMLEncoding(xMLSource.getCurrentXMLEncoding());
                System.out.println(this.getClass() + " saveAs");
                System.out.println(String.valueOf(ja2.getSelectedFile().getAbsolutePath()) + " succesfully saved");
                xMLSource.setChanged(false);
                xMLSource.setBinaryPist(false);
                this.printFileProps(xMLSource);
                iQ iQ2 = sourceComponentManager.getSelectedComponent(1);
                xMLSource.setName(null);
                xMLSource.setToolTip(null);
                iQ2.a(xMLSource.getName());
                iQ2.b(xMLSource.getToolTip());
            }
        }
    }

    private void printFileProps(XMLSource xMLSource) {
        System.out.println("encoding  + " + xMLSource.getFileEncoding());
        System.out.println("BOM used = " + xMLSource.isFileBOM());
        if (xMLSource.getEndOfLineString().endsWith("\r\n")) {
            System.out.println("lineseparator  = CRLF");
            return;
        }
        if (xMLSource.getEndOfLineString().endsWith("\n")) {
            System.out.println("lineseparator  = LF");
            return;
        }
        if (xMLSource.getEndOfLineString().endsWith("\r")) {
            System.out.println("lineseparator  = CR");
        }
    }

    private boolean writeToFile(XMLSource xMLSource, File file, String string, boolean bl2, String string2) {
        if (xMLSource.getLeadingSource() == 1) {
            if (xMLSource.getDocument() != null) {
                return this.writeDomToFile(file, xMLSource.getDocument(), string, bl2, string2, xMLSource);
            }
            JOptionPane.showMessageDialog(Frame.getInstance(), "Nothing to save", "Save alert", 0);
        } else {
            if (xMLSource.getTextDocument() != null) {
                return this.writeTextToFile(file, xMLSource.getTextDocument(), string, bl2, string2);
            }
            JOptionPane.showMessageDialog(Frame.getInstance(), "Nothing to save", "Save alert", 0);
        }
        return false;
    }

    private boolean writeTextToFile(File object, Document document, String string, boolean bl2, String string2) {
        boolean bl3;
        block22: {
            bl3 = true;
            JEditorPane jEditorPane = new JEditorPane();
            jEditorPane.setDocument(document);
            FileOutputStream fileOutputStream = null;
            BufferedWriter bufferedWriter = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream((File)object);
                    if (bl2 && string.equals("UTF-8")) {
                        System.out.println(this.getClass() + " write BOM in output");
                        object = new byte[]{-17, -69, -65};
                        fileOutputStream.write((byte[])object);
                    }
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, string));
                    document.putProperty("__EndOfLine__", string2);
                    jEditorPane.write(bufferedWriter);
                }
                catch (IOException iOException) {
                    object = iOException;
                    iOException.printStackTrace();
                    bl3 = false;
                    document.putProperty("__EndOfLine__", "\n");
                    if (bufferedWriter != null) {
                        try {
                            bufferedWriter.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                document.putProperty("__EndOfLine__", "\n");
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (Exception exception) {}
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            document.putProperty("__EndOfLine__", "\n");
            try {
                bufferedWriter.close();
            }
            catch (Exception exception) {}
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
        return bl3;
    }

    public boolean writeDomToFile(File object, org.w3c.dom.Document object2, String string, boolean bl2, String object3, XMLSource xMLSource) {
        boolean bl3;
        block24: {
            bl3 = true;
            object2 = iP.a((org.w3c.dom.Document)object2, (String)object3, true);
            object3 = null;
            BufferedWriter bufferedWriter = null;
            try {
                try {
                    object3 = new FileOutputStream((File)object);
                    if (bl2 && string.equals("UTF-8")) {
                        System.out.println(this.getClass() + " write BOM in output");
                        object = new byte[]{-17, -69, -65};
                        ((FileOutputStream)object3).write((byte[])object);
                    }
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object3, string));
                    if (xMLSource.getCurrentXMLEncoding() != null) {
                        int n2 = ((String)object2).indexOf("encoding=\"UTF-16\"");
                        bufferedWriter.write(((String)object2).substring(0, n2));
                        bufferedWriter.write("encoding=\"" + xMLSource.getCurrentXMLEncoding() + "\"");
                        bufferedWriter.write(((String)object2).substring(n2 + "encoding=\"UTF-16\"".length()));
                    } else {
                        int n3 = ((String)object2).indexOf("encoding=\"UTF-16\"");
                        bufferedWriter.write(((String)object2).substring(0, n3));
                        bufferedWriter.write(((String)object2).substring(n3 + "encoding=\"UTF-16\"".length()));
                    }
                }
                catch (IOException iOException) {
                    object = iOException;
                    iOException.printStackTrace();
                    bl3 = false;
                    if (bufferedWriter != null) {
                        try {
                            bufferedWriter.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (object3 != null) {
                        try {
                            ((FileOutputStream)object3).close();
                        }
                        catch (Exception exception) {}
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (Exception exception) {}
                }
                if (object3 != null) {
                    try {
                        ((FileOutputStream)object3).close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                bufferedWriter.close();
            }
            catch (Exception exception) {}
            try {
                ((FileOutputStream)object3).close();
            }
            catch (Exception exception) {}
        }
        return bl3;
    }

    private String setExtension(File object, String string) {
        String string2 = ((File)object).getPath();
        int n2 = ((String)(object = ((File)object).getName())).lastIndexOf(46);
        if (n2 > 0 && n2 < ((String)object).length() - 1) {
            return string2;
        }
        return String.valueOf(string2) + "." + string;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public String getVersionDate() {
        return versionDate;
    }

    @Override
    public String getProvider() {
        return provider;
    }

    @Override
    public URL getMoreInfo() {
        return HTMLResourceLoader.class.getResource("XMLHandler.html");
    }

    @Override
    public String getExtensionDescription(String string) {
        if (string == null) {
            return "";
        }
        if (string.endsWith("xml")) {
            return "XML File";
        }
        if (string.endsWith("xsd")) {
            return "W3C XML Schema";
        }
        if (string.endsWith("xsl")) {
            return "XSLT stylesheet";
        }
        return "";
    }

    @Override
    public String[] getHandledExtensions() {
        return this.handledExtensions;
    }

    @Override
    public void setHandledExtensions(String[] stringArray) {
        this.handledExtensions = stringArray;
        Preferences.setHandledExtensions(this, stringArray);
    }

    @Override
    public String[] getHandeldNewExtensions() {
        return this.handledNewExtensions;
    }

    @Override
    public ImageIcon getContentIcon() {
        return new ImageIcon(ImageResourceLoader.class.getResource("spear.png"));
    }

    @Override
    public Source getSource() {
        return new XMLSource();
    }

    public static File getDtdDir() {
        return dtdDir;
    }

    @Override
    public void reload() {
        if (Frame.getInstance().getComponentManager() != null) {
            Object object = Frame.getInstance().getComponentManager();
            if (((Source)(object = ((SourceComponentManager)object).getSource())).getUrl() != null) {
                if (((Source)object).isChanged()) {
                    Object[] objectArray = new Object[]{"Yes", "No"};
                    int n2 = JOptionPane.showOptionDialog(Frame.getInstance(), "Reload document from " + ((Source)object).getUrl() + ". \nAll changes will be lost!!", "Confirm reload", 0, 3, null, objectArray, objectArray[0]);
                    if (n2 == 1) {
                        return;
                    }
                }
                if (((XMLSource)object).getLeadingSource() == 1) {
                    Frame.getInstance().getComponentManager().fireEvent(new ae(null, 0));
                    ((XMLSource)object).setLoaded(false);
                    try {
                        Object object2 = ((XMLSource)object).getDocumentModel();
                        object2 = ((dJ)object2).a;
                        ((bF)object2).a(((Source)object).getFile().getAbsolutePath());
                    }
                    catch (Exception exception) {
                        System.out.println("DomHandler read failed reason " + exception.toString());
                    }
                    if (((XMLSource)object).getDocument() == null) {
                        Frame.getInstance().getComponentManager().fireEvent(new ca(null, 0));
                    }
                }
                if (((XMLSource)object).getLeadingSource() == 0) {
                    Frame.getInstance().getComponentManager().fireEvent(new ae(null, 0));
                    ((XMLSource)object).validateXML();
                }
                ((Source)object).setChanged(false);
            }
        }
    }

    @Override
    public String getContentTypeDescription() {
        return "XML";
    }

    @Override
    public ImageIcon getExtensionIcon(String string) {
        if (string == null) {
            return null;
        }
        if (string.endsWith("xml")) {
            return new ImageIcon(ImageResourceLoader.class.getResource("document_xml16.png"));
        }
        if (string.endsWith("xsd")) {
            return new ImageIcon(ImageResourceLoader.class.getResource("document_xsd16.png"));
        }
        if (string.endsWith("xsl")) {
            return new ImageIcon(ImageResourceLoader.class.getResource("document_xsl16.png"));
        }
        return null;
    }
}

