/*
 * Decompiled with CFR 0.152.
 */
package com.dd.text;

import com.dd.gui.components.Frame;
import com.dd.gui.components.SourceComponentManager;
import com.dd.handler.ContentEditor;
import com.dd.resources.html.HTMLResourceLoader;
import com.dd.resources.images.ImageResourceLoader;
import com.dd.sources.Source;
import com.dd.text.TextSource;
import com.donkeydevelopment.aD;
import com.donkeydevelopment.ae;
import com.donkeydevelopment.bJ;
import com.donkeydevelopment.cn;
import com.donkeydevelopment.eh;
import com.donkeydevelopment.fw;
import com.donkeydevelopment.hc;
import com.donkeydevelopment.iQ;
import com.donkeydevelopment.ja;
import com.donkeydevelopment.jt;
import com.donkeydevelopment.xmlspear.Preferences;
import java.awt.BorderLayout;
import java.awt.Container;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.text.Document;

public class TextHandler
extends ContentEditor {
    public static String provider = "DonkeyDevelopment";
    public static final String name = "Text Editor";
    public static final String version = "2.00";
    public static final String versionDate = "2007/09/21";
    public String[] handledExtensions = new String[]{"txt", "ini", "properties", "log", "bat", "sh"};
    public final String[] handledNewExtensions = new String[]{"txt"};

    public TextHandler(Frame frame) {
        super(frame);
        this.handledExtensions = Preferences.getHandledExtensions(this, this.handledExtensions);
    }

    @Override
    public void newDoc(String string) {
        TextSource textSource = new TextSource(null);
        textSource.setContents("");
        textSource.setExtensionNew(string);
        this.setupTabbedFrame(textSource);
    }

    public boolean checkSize(File file) {
        if (file != null && file.length() > jt.b) {
            StringBuffer stringBuffer = new StringBuffer();
            Object[] objectArray = BigDecimal.valueOf(file.length()).setScale(2, 4);
            if (file.length() < 1024L) {
                stringBuffer.append(file.length());
                stringBuffer.append(" bytes");
            } else if (file.length() < 0x100000L) {
                objectArray = objectArray.divide(BigDecimal.valueOf(1024L), 4);
                stringBuffer.append(objectArray);
                stringBuffer.append(" KB");
                stringBuffer.append(" (");
                stringBuffer.append(file.length());
                stringBuffer.append(" bytes");
                stringBuffer.append(")");
            } else if (file.length() < 0x40000000L) {
                objectArray = objectArray.divide(BigDecimal.valueOf(0x100000L), 4);
                stringBuffer.append(objectArray);
                stringBuffer.append(" MB");
                stringBuffer.append(" (");
                stringBuffer.append(file.length());
                stringBuffer.append(" bytes");
                stringBuffer.append(")");
            } else {
                objectArray = objectArray.divide(BigDecimal.valueOf(0x40000000L), 4);
                stringBuffer.append(objectArray);
                stringBuffer.append(" GB");
                stringBuffer.append(" (");
                stringBuffer.append(file.length());
                stringBuffer.append(" bytes");
                stringBuffer.append(")");
            }
            objectArray = new Object[]{"Stop", "Continue"};
            int n2 = JOptionPane.showOptionDialog(Frame.getInstance(), "\nXMLSpear is not capable for handling very big files.\nThis file is " + stringBuffer + ", which is greater than the maximum size" + "\nspecified in the configuration (" + jt.b + " bytes)." + "\nOpening and especially scrolling or editing of this file may be slow or freeze the GUI." + "\nIf there are any unsaved changes within XMLSpear then save them first!!" + "\n " + "\nBy the way:" + "\nYou can change the maximum filesize settings in the XMLSpear.properties." + "\nThis file is located in the XMLSpear application folder", "Confirm reload", 0, 3, null, objectArray, objectArray[0]);
            if (n2 == 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void open(File file) {
        if (!this.checkSize(file)) {
            return;
        }
        TextSource textSource = new TextSource(file);
        aD aD2 = new aD();
        Serializable serializable = new ArrayList<String>();
        serializable.add("System default (" + System.getProperty("file.encoding") + ")");
        serializable.add("UTF-8");
        serializable.add("UTF-16");
        serializable.add("UTF-16BE");
        serializable.add("UTF-16LE");
        serializable.add("ISO-8859-1");
        serializable.add("ISO-8859-2");
        serializable.add("ISO-8859-3");
        serializable.add("ISO-8859-4");
        serializable.add("ISO-8859-5");
        serializable.add("ISO-8859-6");
        serializable.add("ISO-8859-7");
        serializable.add("ISO-8859-8");
        serializable.add("ISO-8859-9");
        serializable.add("US-ASCII");
        boolean bl2 = jt.g;
        aD aD3 = aD2;
        aD2.b = bl2;
        ArrayList<String> arrayList = serializable;
        aD3 = aD2;
        aD2.a = arrayList;
        int n2 = 0;
        aD3 = aD2;
        aD2.a = n2;
        String string = file.getAbsolutePath();
        aD3 = aD2;
        aD2.a = string;
        string = System.getProperty("line.separator");
        aD3 = aD2;
        aD2.d = string;
        serializable = new fw((JFrame)Frame.getInstance(), "File Encoding Chooser", true, aD2);
        ((fw)serializable).a();
        if (!aD2.isActionOk()) {
            return;
        }
        aD3 = aD2;
        textSource.setFileEncoding(aD3.b);
        aD3 = aD2;
        textSource.setFileBOM(aD3.a);
        System.out.println(this.getClass() + " used encoding " + textSource.getFileEncoding());
        aD3 = aD2;
        textSource.setEndOfLineString(aD3.d);
        System.out.println("length of endOfLineString of " + file.getAbsolutePath() + " = " + textSource.getEndOfLineString().length());
        this.setupTabbedFrame(textSource);
    }

    public void setupTabbedFrame(TextSource object) {
        SourceComponentManager sourceComponentManager = new SourceComponentManager(this, (Source)object);
        object = new eh(sourceComponentManager, (TextSource)object);
        sourceComponentManager.addComponentAt((iQ)object, 1);
        Frame.getInstance().addComponentManager(sourceComponentManager);
    }

    @Override
    public void save() {
        Object object = Frame.getInstance().getComponentManager();
        if (!((Source)(object = (TextSource)((SourceComponentManager)object).getSource())).isFile()) {
            this.saveAs();
            return;
        }
        if (this.writeTextToFile(((Source)object).getFile(), ((TextSource)object).getTextDocument(), ((TextSource)object).getFileEncoding(), ((TextSource)object).isFileBOM(), ((TextSource)object).getEndOfLineString())) {
            ((Source)object).setChanged(false);
        }
    }

    @Override
    public void saveAs() {
        Serializable serializable;
        SourceComponentManager sourceComponentManager = Frame.getInstance().getComponentManager();
        TextSource textSource = (TextSource)sourceComponentManager.getSource();
        ja ja2 = new ja();
        ja2.setDialogTitle("Save As...");
        ja2.setFileSelectionMode(0);
        ja2.addChoosableFileFilter(new hc());
        if (textSource.getFile() != null) {
            ja2.setSelectedFile(textSource.getFile());
        } else if (Preferences.getLastDirectory() != null) {
            try {
                serializable = new File(Preferences.getLastDirectory());
                if (((File)serializable).exists() && ((File)serializable).canRead()) {
                    ja2.setCurrentDirectory((File)serializable);
                }
            }
            catch (Exception exception) {
            }
            catch (Throwable throwable) {}
        }
        serializable = new JPanel(new BorderLayout());
        Object object = new bJ(textSource);
        JComponent jComponent = new JButton((Action)object);
        ((Container)serializable).add(jComponent, "South");
        jComponent = new JPanel();
        ((Container)serializable).add(jComponent, "Center");
        ja2.setAccessory((JComponent)serializable);
        int n2 = ja2.showSaveDialog(Frame.getInstance());
        if (n2 == 0) {
            Object object2;
            Object object3;
            if (ja2.getSelectedFile() != null) {
                if (ja2.getSelectedFile().exists() && textSource.getFile() != null && !textSource.getFile().getAbsolutePath().equals(ja2.getSelectedFile().getAbsolutePath())) {
                    Object[] objectArray = new Object[]{"Cancel", "Replace"};
                    n2 = JOptionPane.showOptionDialog(Frame.getInstance(), "A file with the same name already exists. If you choose to replace it, the contents will be overwritten", "Replace alert", 1, 2, null, objectArray, objectArray[1]);
                    if (n2 == 0) {
                        return;
                    }
                }
                if (ja2.getSelectedFile().getParentFile() != null) {
                    Preferences.setLastDirectory(ja2.getSelectedFile().getParentFile().getAbsolutePath());
                }
            }
            Object object4 = object;
            object = object4 = ((bJ)object4).a;
            object = object4;
            object = object4;
            if (this.writeTextToFile(ja2.getSelectedFile(), textSource.getTextDocument(), ((cn)object3).a, ((cn)object2).a, ((cn)object).b)) {
                textSource.setSourceFile(ja2.getSelectedFile());
                object = object4;
                textSource.setFileEncoding(((cn)object).a);
                object = object4;
                textSource.setFileBOM(((cn)object).a);
                object = object4;
                textSource.setEndOfLineString(((cn)object).b);
                System.out.println(this.getClass() + " saveAs");
                System.out.println(String.valueOf(ja2.getSelectedFile().getAbsolutePath()) + " succesfully saved");
                this.printFileProps(textSource);
                object4 = sourceComponentManager.getSelectedComponent(1);
                textSource.setName(null);
                textSource.setToolTip(null);
                textSource.setChanged(false);
                ((iQ)object4).a(textSource.getName());
                ((iQ)object4).b(ja2.getSelectedFile().getAbsolutePath());
            }
        }
    }

    private void printFileProps(TextSource textSource) {
        System.out.println("encoding  + " + textSource.getFileEncoding());
        System.out.println("BOM used = " + textSource.isFileBOM());
        if (textSource.getEndOfLineString().endsWith("\r\n")) {
            System.out.println("lineseparator  = CRLF");
            return;
        }
        if (textSource.getEndOfLineString().endsWith("\n")) {
            System.out.println("lineseparator  = LF");
            return;
        }
        if (textSource.getEndOfLineString().endsWith("\r")) {
            System.out.println("lineseparator  = CR");
        }
    }

    private void printDocumentProps(Document document) {
        if (document == null) {
            return;
        }
        if (document.getProperty("__EndOfLine__") == null) {
            System.out.println("lineseparator  = null");
            return;
        }
        if (document.getProperty("__EndOfLine__").equals("\r\n")) {
            System.out.println("lineseparator  = CRLF");
            return;
        }
        if (document.getProperty("__EndOfLine__").equals("\n")) {
            System.out.println("lineseparator  = LF");
            return;
        }
        if (document.getProperty("__EndOfLine__").equals("\r")) {
            System.out.println("lineseparator  = CR");
            return;
        }
        System.out.println("lineseparator  = " + document.getProperty("__EndOfLine__"));
    }

    private String setExtension(File object, String string) {
        String string2 = ((File)object).getPath();
        int n2 = ((String)(object = ((File)object).getName())).lastIndexOf(46);
        if (n2 > 0 && n2 < ((String)object).length() - 1) {
            return string2;
        }
        return String.valueOf(string2) + "." + string;
    }

    public static boolean writeFile(File object, String string) {
        try {
            object = new PrintWriter(new BufferedWriter(new FileWriter((File)object)));
            ((PrintWriter)object).print(string);
            ((PrintWriter)object).flush();
            ((PrintWriter)object).close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private boolean writeTextToFile(File object, Document document, String string, boolean bl2, String string2) {
        boolean bl3;
        block22: {
            bl3 = true;
            JEditorPane jEditorPane = new JEditorPane();
            jEditorPane.setDocument(document);
            FileOutputStream fileOutputStream = null;
            BufferedWriter bufferedWriter = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream((File)object);
                    if (bl2 && string.equals("UTF-8")) {
                        System.out.println(this.getClass() + " write BOM in output");
                        object = new byte[]{-17, -69, -65};
                        fileOutputStream.write((byte[])object);
                    }
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, string));
                    document.putProperty("__EndOfLine__", string2);
                    jEditorPane.write(bufferedWriter);
                }
                catch (IOException iOException) {
                    object = iOException;
                    iOException.printStackTrace();
                    bl3 = false;
                    document.putProperty("__EndOfLine__", "\n");
                    if (bufferedWriter != null) {
                        try {
                            bufferedWriter.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                document.putProperty("__EndOfLine__", "\n");
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (Exception exception) {}
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            document.putProperty("__EndOfLine__", "\n");
            try {
                bufferedWriter.close();
            }
            catch (Exception exception) {}
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
        return bl3;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public String getVersionDate() {
        return versionDate;
    }

    @Override
    public String getProvider() {
        return provider;
    }

    @Override
    public URL getMoreInfo() {
        return HTMLResourceLoader.class.getResource("TextHandler.html");
    }

    @Override
    public String getContentTypeDescription() {
        return "text";
    }

    @Override
    public String[] getHandledExtensions() {
        return this.handledExtensions;
    }

    @Override
    public void setHandledExtensions(String[] stringArray) {
        this.handledExtensions = stringArray;
        Preferences.setHandledExtensions(this, stringArray);
    }

    @Override
    public ImageIcon getContentIcon() {
        return new ImageIcon(ImageResourceLoader.class.getResource("textObject.gif"));
    }

    @Override
    public void open(Source source) {
        this.setupTabbedFrame((TextSource)source);
    }

    @Override
    public Source getSource() {
        return new TextSource(null);
    }

    @Override
    public void reload() {
        if (Frame.getInstance().getComponentManager() != null) {
            Object object = Frame.getInstance().getComponentManager();
            if (((Source)(object = ((SourceComponentManager)object).getSource())).getUrl() != null) {
                if (((Source)object).isChanged()) {
                    Object[] objectArray = new Object[]{"Yes", "No"};
                    int n2 = JOptionPane.showOptionDialog(Frame.getInstance(), "Reload document from " + ((Source)object).getUrl() + ". \nAll changes will be lost!!", "Confirm reload", 0, 3, null, objectArray, objectArray[0]);
                    if (n2 == 1) {
                        return;
                    }
                }
                Frame.getInstance().getComponentManager().fireEvent(new ae(null, 0));
            }
        }
    }

    @Override
    public String[] getHandeldNewExtensions() {
        return this.handledNewExtensions;
    }

    @Override
    public String getExtensionDescription(String string) {
        if (string == null) {
            return "";
        }
        if (string.endsWith("txt")) {
            return "Text File";
        }
        return "";
    }

    @Override
    public ImageIcon getExtensionIcon(String string) {
        if (string == null) {
            return null;
        }
        if (string.endsWith("txt")) {
            return new ImageIcon(ImageResourceLoader.class.getResource("textObject.gif"));
        }
        return null;
    }
}

