/*
 * Decompiled with CFR 0.152.
 */
package com.dd.sources;

import com.dd.gui.components.SourceComponentManager;
import com.donkeydevelopment.P;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.EventListener;
import java.util.Hashtable;
import javax.swing.event.EventListenerList;

public abstract class Source {
    protected URL url;
    public String contents;
    protected SourceComponentManager sourceComponentManager;
    protected String name;
    protected String toolTip;
    protected Hashtable propList = new Hashtable();
    protected boolean changed = false;
    protected String extensionNew = "";
    protected EventListenerList listenerList = new EventListenerList();

    public Source() {
    }

    public Source(URL uRL) {
        this.setUrl(uRL);
    }

    public Source(File serializable) {
        if (serializable != null) {
            try {
                this.setUrl(serializable.toURI().toURL());
                return;
            }
            catch (MalformedURLException malformedURLException) {
                serializable = malformedURLException;
                malformedURLException.printStackTrace();
            }
        }
    }

    public void setFile(File serializable) {
        if (serializable != null) {
            try {
                this.setUrl(serializable.toURI().toURL());
                return;
            }
            catch (MalformedURLException malformedURLException) {
                serializable = malformedURLException;
                malformedURLException.printStackTrace();
            }
        }
    }

    public void addProperty(Object object, Object object2) {
        this.propList.put(object, object2);
    }

    public Object getProperty(Object object) {
        return this.propList.get(object);
    }

    public boolean isFile() {
        return this.url != null && this.url.getProtocol() != null && this.url.getProtocol().equals("file");
    }

    public File getFile() {
        File file = null;
        if (this.url != null) {
            try {
                file = P.a(this.url.toURI());
            }
            catch (Exception exception) {
                System.out.println("Error getting file from Source :" + exception);
                System.out.println("URL.toURI failed for URL :" + this.url.toString());
                System.out.println("File will be resolved by using url.getFile() instead url.toURI");
                file = new File(this.url.getFile());
            }
        }
        return file;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public String getContents() {
        if (this.contents == null) {
            this.contents = this.fetchURL(this.url);
        }
        return this.contents;
    }

    public void setContents(String string) {
        this.contents = string;
    }

    private String read(File object) {
        String string;
        object = new BufferedReader(new FileReader((File)object));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = ((BufferedReader)object).readLine()) != null) {
            stringBuffer.append(string);
        }
        ((BufferedReader)object).close();
        return stringBuffer.toString();
    }

    private String fetchURL(URL object) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        try {
            String string;
            object = (InputStream)((URL)object).getContent();
            object = new BufferedReader(new InputStreamReader((InputStream)object));
            while ((string = ((BufferedReader)object).readLine()) != null) {
                printWriter.println(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            object = malformedURLException;
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
        }
        return stringWriter.toString();
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.url != null) {
            String string;
            if (this.url.getProtocol().equals("file")) {
                File file;
                try {
                    file = new File(URLDecoder.decode(this.url.getFile(), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    UnsupportedEncodingException unsupportedEncodingException2 = unsupportedEncodingException;
                    unsupportedEncodingException.printStackTrace();
                    file = new File(this.url.getFile());
                }
                return file.getName();
            }
            if (this.url.getProtocol().toString().startsWith("jar")) {
                int n2 = this.url.toExternalForm().lastIndexOf("/");
                string = this.url.toExternalForm().substring(n2 + 1);
            } else {
                string = this.url.toExternalForm();
            }
            try {
                return URLDecoder.decode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                UnsupportedEncodingException unsupportedEncodingException3 = unsupportedEncodingException;
                unsupportedEncodingException.printStackTrace();
                return string;
            }
        }
        return "Untitled";
    }

    public String getToolTip() {
        if (this.toolTip != null) {
            return this.toolTip;
        }
        if (this.url != null) {
            if (this.url.getProtocol().equals("file")) {
                Serializable serializable;
                try {
                    serializable = new File(URLDecoder.decode(this.url.getFile(), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    serializable = unsupportedEncodingException;
                    unsupportedEncodingException.printStackTrace();
                    serializable = new File(this.url.getFile());
                }
                return ((File)serializable).getAbsolutePath();
            }
            try {
                return URLDecoder.decode(this.url.toString(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                UnsupportedEncodingException unsupportedEncodingException2 = unsupportedEncodingException;
                unsupportedEncodingException.printStackTrace();
                return this.url.toString();
            }
        }
        return "Document is not saved yet";
    }

    public void setSourceFile(File serializable) {
        try {
            this.setUrl(serializable.toURI().toURL());
            return;
        }
        catch (MalformedURLException malformedURLException) {
            serializable = malformedURLException;
            malformedURLException.printStackTrace();
            return;
        }
    }

    public File getSourceFile() {
        if (this.isFile()) {
            return new File(this.url.getFile());
        }
        return null;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
        this.firePropertyChange("url", null, uRL);
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setToolTip(String string) {
        this.toolTip = string;
    }

    public SourceComponentManager getSourceComponentManager() {
        return this.sourceComponentManager;
    }

    public void setSourceComponentManager(SourceComponentManager sourceComponentManager) {
        this.sourceComponentManager = sourceComponentManager;
    }

    public void addChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerList.add(PropertyChangeListener.class, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerList.remove(PropertyChangeListener.class, propertyChangeListener);
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(PropertyChangeListener.class);
        int n2 = 0;
        while (n2 < eventListenerArray.length) {
            ((PropertyChangeListener)eventListenerArray[n2]).propertyChange(new PropertyChangeEvent(this, string, object, object2));
            ++n2;
        }
    }

    public void setChanged(boolean bl2) {
        this.changed = bl2;
        this.firePropertyChange("changed", Boolean.FALSE, Boolean.TRUE);
    }

    public String getExtensionNew() {
        return this.extensionNew;
    }

    public void setExtensionNew(String string) {
        this.extensionNew = string;
    }
}

