/*
 * Decompiled with CFR 0.152.
 */
package com.dd.html;

import com.dd.gui.components.Frame;
import com.dd.gui.components.SourceComponentManager;
import com.dd.handler.ContentHandler;
import com.dd.html.HTMLSource;
import com.dd.resources.html.HTMLResourceLoader;
import com.dd.resources.images.ImageResourceLoader;
import com.dd.sources.Source;
import com.donkeydevelopment.ae;
import com.donkeydevelopment.bH;
import com.donkeydevelopment.iQ;
import com.donkeydevelopment.k;
import com.donkeydevelopment.xmlspear.Preferences;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class HTMLHandler
extends ContentHandler {
    public static String provider = "DonkeyDevelopment";
    public static final String name = "HTML Viewer";
    public static final String version = "1.00";
    public static final String versionDate = "2005/12/08";
    public String[] handledExtensions = Preferences.getHandledExtensions(this, this.handledExtensions);

    public HTMLHandler(Frame frame) {
        super(frame);
    }

    public void newDoc() {
        HTMLSource hTMLSource = new HTMLSource();
        try {
            String string;
            Object object = HTMLResourceLoader.class.getResource("Untitled.html");
            object = new BufferedReader(new InputStreamReader(((URL)object).openStream()));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string = ((BufferedReader)object).readLine()) != null) {
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            ((BufferedReader)object).close();
            hTMLSource.setContents(stringBuffer.toString());
            this.setupTabbedFrame(hTMLSource);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            MalformedURLException malformedURLException2 = malformedURLException;
            malformedURLException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    @Override
    public void open(File object) {
        object = new HTMLSource((File)object);
        this.setupTabbedFrame((HTMLSource)object);
    }

    public void open(URL object) {
        object = new HTMLSource((URL)object);
        this.setupTabbedFrame((HTMLSource)object);
    }

    public void setupTabbedFrame(HTMLSource object) {
        SourceComponentManager sourceComponentManager = new SourceComponentManager(this, (Source)object);
        object = new k(sourceComponentManager, (HTMLSource)object);
        sourceComponentManager.addComponentAt((iQ)object, 1);
        Frame.getInstance().addComponentManager(sourceComponentManager);
    }

    public void save() {
        Object object = Frame.getInstance().getComponentManager();
        if (!((Source)(object = ((SourceComponentManager)object).getSource())).isFile()) {
            this.saveAs();
            return;
        }
        this.writeFile(((Source)object).getSourceFile(), (Source)object);
    }

    @Override
    public void saveAs() {
        SourceComponentManager sourceComponentManager = Frame.getInstance().getComponentManager();
        Source source = sourceComponentManager.getSource();
        if (source != null) {
            int n2;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Save As...");
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.addChoosableFileFilter(new bH());
            if (Preferences.getLastDirectory() != null) {
                try {
                    File file = new File(Preferences.getLastDirectory());
                    if (file.exists() && file.canRead()) {
                        jFileChooser.setCurrentDirectory(file);
                    }
                }
                catch (Exception exception) {
                }
                catch (Throwable throwable) {}
            }
            if ((n2 = jFileChooser.showSaveDialog(Frame.getInstance())) == 0) {
                String string;
                if (jFileChooser.getSelectedFile() != null) {
                    if (jFileChooser.getSelectedFile().exists() && source.getFile() != null && !source.getFile().getAbsolutePath().equals(jFileChooser.getSelectedFile().getAbsolutePath())) {
                        Object[] objectArray = new Object[]{"Cancel", "Replace"};
                        int n3 = JOptionPane.showOptionDialog(Frame.getInstance(), "A file with the same name already exists. If you choose to replace it, the contents will be overwritten", "Replace alert", 1, 2, null, objectArray, objectArray[1]);
                        if (n3 == 0) {
                            return;
                        }
                    }
                    if (jFileChooser.getSelectedFile().getParentFile() != null) {
                        Preferences.setLastDirectory(jFileChooser.getSelectedFile().getParentFile().getAbsolutePath());
                    }
                }
                if (this.writeFile(new File(string = this.setExtension(jFileChooser.getSelectedFile(), "htm")), source)) {
                    source.setSourceFile(new File(string));
                    iQ iQ2 = sourceComponentManager.getSelectedComponent(1);
                    source.setName(null);
                    source.setToolTip(null);
                    iQ2.a(source.getName());
                    iQ2.b(string);
                }
            }
        }
    }

    private String setExtension(File object, String string) {
        String string2 = ((File)object).getPath();
        int n2 = ((String)(object = ((File)object).getName())).lastIndexOf(46);
        if (n2 > 0 && n2 < ((String)object).length() - 1) {
            return string2;
        }
        return String.valueOf(string2) + "." + string;
    }

    public boolean writeFile(File serializable, Source source) {
        block4: {
            if (source != null) {
                try {
                    if (!HTMLHandler.writeFile(serializable, source.getContents())) {
                        JOptionPane.showMessageDialog(Frame.getInstance(), "Saving failed", "Save alert", 0);
                        break block4;
                    }
                    return true;
                }
                catch (IOException iOException) {
                    serializable = iOException;
                    iOException.printStackTrace();
                    JOptionPane.showMessageDialog(Frame.getInstance(), "Saving failed", "Save alert", 0);
                }
            }
        }
        return false;
    }

    public static boolean writeFile(File object, String string) {
        try {
            object = new PrintWriter(new BufferedWriter(new FileWriter((File)object)));
            ((PrintWriter)object).print(string);
            ((PrintWriter)object).flush();
            ((PrintWriter)object).close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public String getVersionDate() {
        return versionDate;
    }

    @Override
    public String getProvider() {
        return provider;
    }

    @Override
    public URL getMoreInfo() {
        return HTMLResourceLoader.class.getResource("HTMLHandler.html");
    }

    @Override
    public String getContentTypeDescription() {
        return "HTML";
    }

    @Override
    public String[] getHandledExtensions() {
        return this.handledExtensions;
    }

    @Override
    public void setHandledExtensions(String[] stringArray) {
        this.handledExtensions = stringArray;
        Preferences.setHandledExtensions(this, stringArray);
    }

    @Override
    public ImageIcon getContentIcon() {
        return new ImageIcon(ImageResourceLoader.class.getResource("htmlObject.gif"));
    }

    @Override
    public void open(Source source) {
        this.setupTabbedFrame((HTMLSource)source);
    }

    @Override
    public Source getSource() {
        return new HTMLSource();
    }

    @Override
    public void reload() {
        if (Frame.getInstance().getComponentManager() != null) {
            Object object = Frame.getInstance().getComponentManager();
            if (((Source)(object = ((SourceComponentManager)object).getSource())).getUrl() != null) {
                Frame.getInstance().getComponentManager().fireEvent(new ae(null, 0));
            }
        }
    }

    @Override
    public String getExtensionDescription(String string) {
        if (string == null) {
            return "";
        }
        if (string.endsWith("htm")) {
            return "HTML File";
        }
        if (string.endsWith("html")) {
            return "HTML File";
        }
        return "";
    }

    @Override
    public ImageIcon getExtensionIcon(String string) {
        if (string == null) {
            return null;
        }
        if (string.endsWith("htm")) {
            return new ImageIcon(ImageResourceLoader.class.getResource("htmlObject.gif"));
        }
        if (string.endsWith("html")) {
            return new ImageIcon(ImageResourceLoader.class.getResource("htmlObject.gif"));
        }
        return null;
    }
}

