/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.services.psk;

import com.ibm.mq.jms.services.psk.PrintWriterTracer;
import com.ibm.mq.jms.services.psk.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

class TraceRecord {
    private static final String sccsid = "common/jms/com/ibm/mq/jms/services/psk/TraceRecord.java, jms, j521, j521-L020126  02/01/25 15:28:45 @(#)";
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1998     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String traceLine;
    private BufferedReader traceReader;
    private String traceInputFile;
    private boolean deletingFiles = false;
    private String tempTraceFile = "temptrace.txt";
    private boolean isFile;
    private boolean usedAFile = false;

    public TraceRecord(String string) {
        Object object;
        Object object2;
        this.traceInputFile = string;
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream();
        try {
            pipedOutputStream.connect(pipedInputStream);
        }
        catch (IOException iOException) {
            System.err.println("Unable to connect to trace stream." + iOException);
        }
        if (this.traceInputFile.equals("TraceStream")) {
            object2 = new InputStreamReader(pipedInputStream);
            object2 = new InputStreamReader(pipedInputStream);
            this.traceReader = new BufferedReader((Reader)object2);
            this.isFile = false;
        } else {
            try {
                object2 = new FileInputStream(this.traceInputFile);
                object = new FileReader(this.traceInputFile);
                this.traceReader = new BufferedReader((Reader)object);
                this.isFile = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Trace File Doesn't Exist" + fileNotFoundException);
            }
        }
        object2 = Trace.getTracer();
        if (object2 instanceof PrintWriterTracer) {
            object = (PrintWriterTracer)object2;
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(pipedOutputStream);
            ((PrintWriterTracer)object).setTraceWriter(new PrintWriter(outputStreamWriter));
        }
    }

    public void createMemoryBuffer(DefaultMutableTreeNode defaultMutableTreeNode) {
        try {
            PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(this.tempTraceFile), true);
            this.printEachLine(printWriter, defaultMutableTreeNode);
            printWriter.close();
            this.traceInputFile = this.tempTraceFile;
            this.usedAFile = true;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public String getNextRecord() {
        try {
            if (this.traceReader.ready() && !this.deletingFiles) {
                this.traceLine = this.traceReader.readLine();
                return this.traceLine;
            }
            if (!this.traceReader.ready() && !this.isFile && this.usedAFile && !this.deletingFiles) {
                File file = new File(this.tempTraceFile);
                this.traceReader.close();
                boolean bl = file.delete();
                this.usedAFile = false;
            }
            return null;
        }
        catch (Exception exception) {
            if (exception.equals("java.io.IOException: Stream closed")) {
                return null;
            }
            return null;
        }
    }

    private String getTraceFilename() {
        return this.traceInputFile;
    }

    public boolean isDeletingFiles() {
        return this.deletingFiles;
    }

    private void printEachLine(PrintWriter printWriter, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode.isLeaf()) {
            printWriter.println(defaultMutableTreeNode.toString());
        } else {
            int n = 0;
            while (n < defaultMutableTreeNode.getChildCount()) {
                this.printEachLine(printWriter, (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n));
                ++n;
            }
        }
    }

    public synchronized DefaultMutableTreeNode resetTraceFile(DefaultMutableTreeNode defaultMutableTreeNode, DefaultTreeModel defaultTreeModel, JTree jTree) {
        Object object;
        try {
            while (this.deletingFiles) {
            }
            if (this.traceReader.ready()) {
                this.traceReader.close();
            }
            this.deletingFiles = true;
            if (this.traceInputFile.equals("TraceStream")) {
                this.createMemoryBuffer(defaultMutableTreeNode);
            }
            defaultMutableTreeNode.removeAllChildren();
            jTree.updateUI();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream();
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
        try {
            pipedOutputStream.connect(pipedInputStream);
        }
        catch (IOException iOException) {
            System.err.println("Unable to connect to trace stream." + iOException);
        }
        InputStreamReader inputStreamReader = new InputStreamReader(pipedInputStream);
        try {
            object = new FileInputStream(this.traceInputFile);
            inputStreamReader = new InputStreamReader((InputStream)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Trace File Doesn't Exist" + fileNotFoundException);
        }
        object = Trace.getTracer();
        if (object instanceof PrintWriterTracer) {
            PrintWriterTracer printWriterTracer = (PrintWriterTracer)object;
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(pipedOutputStream);
            printWriterTracer.setTraceWriter(new PrintWriter(outputStreamWriter));
        }
        this.traceReader = new BufferedReader(inputStreamReader);
        return defaultMutableTreeNode2;
    }

    public void setDeletingFiles(boolean bl) {
        this.deletingFiles = bl;
    }

    public synchronized void setTraceFile(String string) {
        this.traceInputFile = string;
    }
}

