/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.services.psk;

import com.ibm.mq.jms.services.psk.CallStackTrace;
import com.ibm.mq.jms.services.psk.Tracer;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;

public class PrintWriterTracer
implements Tracer {
    private static final String sccsid = "common/jms/com/ibm/mq/jms/services/psk/PrintWriterTracer.java, jms, j521, j521-L020126  02/01/25 15:28:20 @(#)";
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1998     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String traceFileExt = ".TRC";
    private Hashtable indentsTable;
    protected boolean isMethodTracing = false;
    protected int methodTraceThreshold = 5;
    protected int format = 15;
    protected PrintWriter traceWriter = new PrintWriter(System.err, true);
    protected int traceLevel = 1;

    public PrintWriterTracer() {
        this.indentsTable = new Hashtable();
    }

    public synchronized void dataTrace(int n, Object object, byte[] byArray) {
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
        if (this.traceLevel >= n) {
            this.indent();
            this.traceTime();
            if ((this.format & 4) != 0) {
                this.traceWriter.print("[" + Thread.currentThread().getName() + "] ");
            }
            if (object != null && (this.format & 8) != 0) {
                this.traceWriter.print(object + " ");
            }
            this.traceWriter.println("Data trace, " + byArray.length + " bytes of data follow: \n");
            this.printHexBytes(this.traceWriter, byArray);
            this.traceWriter.println();
            this.traceWriter.flush();
        }
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(true);
        }
    }

    private final void decrementIndents() {
        int n = this.getIndentationLevel();
        if (n > 0) {
            --n;
        }
        this.indentsTable.put(Thread.currentThread(), new Integer(n));
    }

    public synchronized void dumpCallStack() {
        this.dumpCallStack(null);
    }

    public synchronized void dumpCallStack(String string) {
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
        CallStackTrace callStackTrace = new CallStackTrace();
        try {
            throw callStackTrace;
        }
        catch (CallStackTrace callStackTrace2) {
            this.indent();
            this.traceTime();
            if ((this.format & 4) != 0) {
                this.traceWriter.println("[" + Thread.currentThread().getName() + "] ");
            }
            this.traceWriter.println("Stack Trace Follows: (stack trace requires java_g or appletviewer_g)");
            if (string != null) {
                this.traceWriter.println(string);
            }
            callStackTrace.printStackTrace(this.traceWriter);
            this.traceWriter.flush();
            if (this.isMethodTracing) {
                Runtime.getRuntime().traceMethodCalls(true);
            }
            return;
        }
    }

    public synchronized void entry(int n, Object object, String string) {
        if (this.traceLevel >= n) {
            this.entry(object, string);
        }
    }

    public synchronized void entry(int n, Object object, String string, String string2) {
        if (this.traceLevel >= n) {
            this.entry(object, string);
            int n2 = this.getIndentationLevel();
            int n3 = 0;
            while (n3 < n2) {
                this.traceWriter.print("  ");
                ++n3;
            }
            this.traceWriter.println("params: " + string2);
            this.traceWriter.flush();
        }
    }

    public synchronized void entry(int n, String string, String string2) {
        if (this.traceLevel >= n) {
            this.entry(string, string2);
        }
    }

    public synchronized void entry(int n, String string, String string2, String string3) {
        if (this.traceLevel >= n) {
            this.entry(string, string2);
            int n2 = this.getIndentationLevel();
            int n3 = 0;
            while (n3 < n2) {
                this.traceWriter.print("  ");
                ++n3;
            }
            this.traceWriter.println("params: " + string3);
            this.traceWriter.flush();
        }
    }

    public synchronized void entry(Object object, String string) {
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
        String string2 = "";
        if ((this.format & 4) != 0) {
            string2 = "[" + Thread.currentThread().getName() + "] ";
        }
        String string3 = "";
        if ((this.format & 8) != 0) {
            string3 = this.objectToString(object) + " ";
        }
        this.indent();
        this.traceTime();
        this.traceWriter.println(string2 + string3 + "==> " + string + "() entry");
        this.incrementIndents();
        this.traceWriter.flush();
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(true);
        }
    }

    public synchronized void entry(Object object, String string, String string2) {
        this.entry(object, string);
        int n = this.getIndentationLevel();
        int n2 = 0;
        while (n2 < n) {
            this.traceWriter.print("  ");
            ++n2;
        }
        this.traceWriter.println("params: " + string2);
        this.traceWriter.flush();
    }

    public synchronized void entry(String string, String string2) {
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
        String string3 = "";
        if ((this.format & 4) != 0) {
            string3 = "[" + Thread.currentThread().getName() + "] ";
        }
        this.indent();
        this.traceTime();
        String string4 = "";
        if ((this.format & 8) != 0) {
            string4 = string + "::";
        }
        this.traceWriter.println(string3 + string4 + string2 + "() ==> entry");
        this.incrementIndents();
        this.traceWriter.flush();
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(true);
        }
    }

    public synchronized void entry(String string, String string2, String string3) {
        this.entry(string, string2);
        int n = this.getIndentationLevel();
        int n2 = 0;
        while (n2 < n) {
            this.traceWriter.print("  ");
            ++n2;
        }
        this.traceWriter.println("params: " + string3);
        this.traceWriter.flush();
    }

    public synchronized void exception(int n, Object object, String string, Throwable throwable) {
        if (this.traceLevel >= n) {
            this.exception(object, string, throwable);
        }
    }

    public synchronized void exception(int n, String string, String string2, Throwable throwable) {
        if (this.traceLevel >= n) {
            this.exception(string, string2, throwable);
        }
    }

    public synchronized void exception(Object object, String string, Throwable throwable) {
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
        String string2 = "";
        if ((this.format & 4) != 0) {
            string2 = "[" + Thread.currentThread().getName() + "] ";
        }
        this.indent();
        this.traceTime();
        String string3 = "";
        if ((this.format & 8) != 0) {
            string3 = this.objectToString(object) + " ";
        }
        this.traceWriter.println(string2 + string3 + " " + string + "() " + throwable.getClass().getName() + " exception caught: " + throwable.getMessage());
        throwable.printStackTrace(this.traceWriter);
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(true);
        }
    }

    public synchronized void exception(String string, String string2, Throwable throwable) {
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
        String string3 = "";
        if ((this.format & 4) != 0) {
            string3 = "[" + Thread.currentThread().getName() + "] ";
        }
        this.indent();
        this.traceTime();
        String string4 = "";
        if ((this.format & 8) != 0) {
            string4 = string + "::";
        }
        this.traceWriter.println(string3 + string4 + " " + string2 + "() " + throwable.getClass().getName() + " exception caught: " + throwable.getMessage());
        throwable.printStackTrace(this.traceWriter);
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(true);
        }
    }

    public synchronized void exit(int n, Object object, String string) {
        if (this.traceLevel >= n) {
            this.exit(object, string);
        }
    }

    public synchronized void exit(int n, Object object, String string, String string2) {
        if (this.traceLevel >= n) {
            this.exit(object, string);
            int n2 = this.getIndentationLevel();
            int n3 = 0;
            while (n3 <= n2) {
                this.traceWriter.print("  ");
                ++n3;
            }
            this.traceWriter.println("return=" + string2);
            this.traceWriter.flush();
        }
    }

    public synchronized void exit(int n, String string, String string2) {
        if (this.traceLevel >= n) {
            this.exit(string, string2);
        }
    }

    public synchronized void exit(int n, String string, String string2, String string3) {
        if (this.traceLevel >= n) {
            this.exit(string, string2);
            int n2 = this.getIndentationLevel();
            int n3 = 0;
            while (n3 <= n2) {
                this.traceWriter.print("  ");
                ++n3;
            }
            this.traceWriter.println("return=" + string3);
            this.traceWriter.flush();
        }
    }

    public synchronized void exit(Object object, String string) {
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
        this.decrementIndents();
        String string2 = "";
        if ((this.format & 4) != 0) {
            string2 = "[" + Thread.currentThread().getName() + "] ";
        }
        this.indent();
        this.traceTime();
        String string3 = "";
        if ((this.format & 8) != 0) {
            string3 = this.objectToString(object) + " ";
        }
        this.traceWriter.println(string2 + string3 + "<== " + string + "() exit");
        this.traceWriter.flush();
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(true);
        }
    }

    public synchronized void exit(Object object, String string, String string2) {
        this.exit(object, string);
        int n = this.getIndentationLevel();
        int n2 = 0;
        while (n2 <= n) {
            this.traceWriter.print("  ");
            ++n2;
        }
        this.traceWriter.println("return=" + string2);
        this.traceWriter.flush();
    }

    public synchronized void exit(String string, String string2) {
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
        this.decrementIndents();
        String string3 = "";
        if ((this.format & 4) != 0) {
            string3 = "[" + Thread.currentThread().getName() + "] ";
        }
        this.indent();
        this.traceTime();
        String string4 = "";
        if ((this.format & 8) != 0) {
            string4 = string + "::";
        }
        this.traceWriter.println(string3 + string4 + string2 + "() <== exit");
        this.traceWriter.flush();
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(true);
        }
    }

    public synchronized void exit(String string, String string2, String string3) {
        this.exit(string, string2);
        int n = this.getIndentationLevel();
        int n2 = 0;
        while (n2 <= n) {
            this.traceWriter.print("  ");
            ++n2;
        }
        this.traceWriter.println("return=" + string3);
        this.traceWriter.flush();
    }

    public void finalize() {
        this.stop();
    }

    public synchronized int getFormat() {
        return this.format;
    }

    protected int getIndentationLevel() {
        int n = 0;
        if (this.indentsTable.containsKey(Thread.currentThread())) {
            Integer n2 = (Integer)this.indentsTable.get(Thread.currentThread());
            n = n2;
        }
        return n;
    }

    public synchronized int getMethodTraceThreshold() {
        return this.methodTraceThreshold;
    }

    public synchronized int getTraceLevel() {
        return this.traceLevel;
    }

    public synchronized PrintWriter getTraceWriter() {
        return this.traceWriter;
    }

    private final void incrementIndents() {
        int n = this.getIndentationLevel();
        this.indentsTable.put(Thread.currentThread(), new Integer(++n));
    }

    protected void indent() {
        int n = this.getIndentationLevel();
        int n2 = 0;
        while (n2 < n) {
            this.traceWriter.print("  ");
            ++n2;
        }
    }

    protected void printHexBytes(PrintWriter printWriter, byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            int n2;
            int n3;
            int n4;
            int n5 = Math.min(n + 16, byArray.length);
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n6 = n;
            while (n6 < n5) {
                n4 = byArray[n6];
                n4 = (n4 + 256) % 256;
                n3 = n4 / 16;
                n2 = n4 % 16;
                stringBuffer.append(n3 < 10 ? (char)(48 + n3) : (char)(97 + n3 - 10));
                stringBuffer.append(n2 < 10 ? (char)(48 + n2) : (char)(97 + n2 - 10));
                if (n6 % 2 == 1) {
                    stringBuffer.append(' ');
                }
                if (n4 >= 32 && n4 <= 126) {
                    stringBuffer2.append((char)n4);
                } else {
                    stringBuffer2.append('.');
                }
                ++n6;
            }
            n4 = 16 - (n5 - n);
            n3 = (n4 * 5 + n4 % 2) / 2;
            n3 += 3;
            n2 = 0;
            while (n2 < n3) {
                stringBuffer.append(' ');
                ++n2;
            }
            String string = "0000" + Integer.toHexString(n);
            string = string.substring(string.length() - 4);
            printWriter.print(string);
            printWriter.print(":  ");
            printWriter.print(stringBuffer.toString());
            printWriter.println(stringBuffer2.toString());
            n += 16;
        }
        printWriter.flush();
    }

    public synchronized void setFormat(int n) {
        this.format = n;
    }

    public synchronized void setMethodTraceThreshold(int n) {
        this.methodTraceThreshold = n;
    }

    public synchronized void setTraceLevel(int n) {
        this.traceLevel = n;
    }

    public synchronized void setTraceWriter(FileWriter fileWriter) {
        if (fileWriter != null) {
            this.traceWriter = new PrintWriter(fileWriter);
        }
    }

    public synchronized void setTraceWriter(PrintWriter printWriter) {
        if (printWriter != null) {
            this.traceWriter = printWriter;
        }
    }

    public void start() {
    }

    public void stop() {
        this.traceWriter.flush();
    }

    public synchronized void trace(int n, Object object, String string) {
        if (this.traceLevel >= n) {
            this.trace(object, string);
        }
    }

    public synchronized void trace(int n, String string, String string2) {
        if (this.traceLevel >= n) {
            this.trace(string, string2);
        }
    }

    public synchronized void trace(Object object, String string) {
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
        String string2 = "";
        if ((this.format & 4) != 0) {
            string2 = "[" + Thread.currentThread().getName() + "] ";
        }
        this.indent();
        this.traceTime();
        String string3 = "";
        if ((this.format & 8) != 0) {
            string3 = this.objectToString(object) + " ";
        }
        this.traceWriter.println(string2 + string3 + string);
        this.traceWriter.flush();
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(true);
        }
    }

    public synchronized void trace(String string, String string2) {
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
        String string3 = "";
        if ((this.format & 4) != 0) {
            string3 = "[" + Thread.currentThread().getName() + "] ";
        }
        this.indent();
        this.traceTime();
        String string4 = "";
        if ((this.format & 8) != 0) {
            string4 = string + " ";
        }
        this.traceWriter.println(string3 + string4 + string2);
        this.traceWriter.flush();
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(true);
        }
    }

    protected void traceTime() {
        Date date = new Date();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        if ((this.format & 1) != 0) {
            int n = gregorianCalendar.get(10);
            int n2 = gregorianCalendar.get(12);
            int n3 = gregorianCalendar.get(13);
            if (n < 10) {
                this.traceWriter.print("0" + n + ":");
            } else {
                this.traceWriter.print(n + ":");
            }
            if (n2 < 10) {
                this.traceWriter.print("0" + n2 + ":");
            } else {
                this.traceWriter.print(n2 + ":");
            }
            if (n3 < 10) {
                this.traceWriter.print("0" + n3 + " ");
            } else {
                this.traceWriter.print(n3 + " ");
            }
        }
        if ((this.format & 2) != 0) {
            this.traceWriter.print("[" + date.getTime() + "] ");
        }
    }

    public synchronized void turnMethodTracingOff() {
        Runtime.getRuntime().traceMethodCalls(false);
        this.isMethodTracing = false;
    }

    public synchronized void turnMethodTracingOn() {
        Runtime.getRuntime().traceMethodCalls(true);
        this.isMethodTracing = true;
    }

    private String objectToString(Object object) {
        if (object == null) {
            return "<null object>";
        }
        StringBuffer stringBuffer = new StringBuffer(object.getClass().getName());
        stringBuffer.append("@");
        stringBuffer.append(Integer.toHexString(object.hashCode()));
        return stringBuffer.toString();
    }
}

