/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.services.psk;

import com.ibm.mq.jms.services.psk.InvalidCommandLineArgument;
import com.ibm.mq.jms.services.psk.NLSServices;
import com.ibm.mq.jms.services.psk.PSK;
import com.ibm.mq.jms.services.psk.Trace;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class CommandLineParser {
    private static final String sccsid = "common/jms/com/ibm/mq/jms/services/psk/CommandLineParser.java, jms, j521, j521-L020126  02/01/25 15:27:55 @(#)";
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1998     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String flags = "";
    private String options = "";
    private String[] permissibleFlags;
    private String[] permissibleOptions;
    private Vector detectedFlags = new Vector();
    private Hashtable detectedOptions = new Hashtable();
    private char switchCharacter = (char)45;
    private String usage = "";

    private boolean flagMatch(String string) {
        boolean bl = false;
        String string2 = "" + this.getSwitchCharacter();
        while (string.startsWith(string2)) {
            string = string.substring(1);
        }
        int n = 0;
        while (n < this.permissibleFlags.length) {
            if (string.equals(this.permissibleFlags[n])) {
                bl = true;
                this.detectedFlags.addElement(string);
                Trace.trace(2, this, "Flag matched: " + string);
                break;
            }
            ++n;
        }
        if (!bl) {
            bl = true;
            int n2 = 0;
            while (n2 < string.length()) {
                String string3 = "" + string.charAt(n2);
                boolean bl2 = false;
                int n3 = 0;
                while (n3 < this.permissibleFlags.length) {
                    if (this.permissibleFlags[n3].equals(string3)) {
                        this.detectedFlags.addElement(string3);
                        bl2 = true;
                        Trace.trace(2, this, "Flag matched: " + string3);
                        break;
                    }
                    ++n3;
                }
                if (!bl2) {
                    bl = false;
                }
                ++n2;
            }
        }
        return bl;
    }

    public String getFlags() {
        return this.flags;
    }

    public String getOption(String string) {
        return (String)this.detectedOptions.get(string);
    }

    public String getOptions() {
        return this.options;
    }

    public char getSwitchCharacter() {
        return this.switchCharacter;
    }

    public String getUsage() {
        return this.usage;
    }

    public boolean isFlagSet(String string) {
        return this.detectedFlags.contains(string);
    }

    public boolean isOptionSet(String string) {
        return this.detectedOptions.containsKey(string);
    }

    private String optionMatch(String string) {
        String string2 = null;
        if (string.startsWith("" + this.getSwitchCharacter())) {
            string = string.substring(1);
        }
        int n = 0;
        while (n < this.permissibleOptions.length) {
            if (string.equals(this.permissibleOptions[n])) {
                string2 = string;
                break;
            }
            ++n;
        }
        return string2;
    }

    public void parseCommandLine(String[] stringArray) throws InvalidCommandLineArgument {
        Trace.entry(this, "parseCommandLine");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            String string2 = this.optionMatch(string);
            if (string2 != null) {
                String string3;
                if (++n2 < n) {
                    string3 = stringArray[n2];
                    if (string3.startsWith("" + this.getSwitchCharacter())) {
                        string3 = "";
                        --n2;
                    }
                } else {
                    string3 = "";
                }
                this.detectedOptions.put(string2, string3);
                Trace.trace(2, this, "Option found: " + string2 + " = " + string3);
            } else {
                boolean bl = this.flagMatch(string);
                if (!bl) {
                    Trace.trace(this, "Invalid argument: " + string);
                    Trace.exit(this, "parseCommandLine");
                    throw new InvalidCommandLineArgument(string);
                }
            }
            ++n2;
        }
        Trace.exit(this, "parseCommandLine");
    }

    public void printUsage() {
        NLSServices.out.println(PSK.getPSKMessage("usage", "Usage: " + this.getUsage(), this.getUsage()));
    }

    public void setFlags(String string) {
        Trace.entry(this, "setFlags", string);
        this.flags = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.permissibleFlags = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.permissibleFlags[n] = stringTokenizer.nextToken().trim();
            ++n;
        }
        Trace.exit(this, "setFlags");
    }

    public void setOptions(String string) {
        Trace.entry(this, "setOptions", string);
        this.options = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.permissibleOptions = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.permissibleOptions[n] = stringTokenizer.nextToken().trim();
            ++n;
        }
        Trace.exit(this, "setOptions");
    }

    public void setSwitchCharacter(char c) {
        this.switchCharacter = c;
    }

    public void setUsage(String string) {
        if (string != null) {
            this.usage = string;
        }
    }
}

