/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.services;

import com.ibm.disthubmq.impl.client.BaseConfig;
import com.ibm.disthubmq.impl.util.DebugState;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.jms.JMSMessage;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.jms.ConnectionImpl;
import com.ibm.mq.jms.MQThreadProvider;
import com.ibm.mq.jms.services.JMSTraceAdapter;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.MQJMSTranslator;
import com.ibm.mq.jms.services.WASLogger;
import com.ibm.mq.jms.services.WASManager;
import com.ibm.mq.jms.services.WASTraceAdapter;
import com.ibm.mq.jms.services.psk.FileLogServiceProvider;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogServiceProvider;
import com.ibm.mq.jms.services.psk.MessageCatalogue;
import com.ibm.mq.jms.services.psk.NLSServices;
import com.ibm.mq.jms.services.psk.PrintWriterLogServiceProvider;
import com.ibm.mq.jms.services.psk.PrintWriterTracer;
import com.ibm.mq.jms.services.psk.Trace;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.MissingResourceException;
import javax.jms.JMSException;

public final class ConfigEnvironment {
    private static final String sccsid = "common/jms/com/ibm/mq/jms/services/ConfigEnvironment.java, jms, j521, j521-L020226  02/02/25 14:24:59 @(#)";
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002.    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int MQJMS_LOG_FILES = 3;
    private static final long MQJMS_LOG_SIZE = 5120L;
    private static final String MQJMS_LOG_MSGCAT_DEFAULT_FILE = "MQJMS_MessageResourceBundle";
    private static final String MQJMS_LOG_MSGCAT_PATH = "com.ibm.mq.jms.services.resources.";
    private static final String MQJMS_LOG_FILE = "mqjms";
    private static final String MQJMS_LOG_SERVICE_NAME = "mqjms_log";
    private static final String MQJMS_TRACE_FILE = "mqjms.trc";
    private static boolean wasTracingAndLogging = false;
    private static FileWriter traceFileWriter;
    private static PrintWriterTracer tracePrintWriterTracer;
    private static LogServiceProvider logSP;
    private static MessageCatalogue logMsgCat;
    private static WASTraceAdapter wasTrcAdpt;
    private static WASManager wasMgr;

    private static void initialiseJMSTrace(String string, String string2) {
        try {
            traceFileWriter = new FileWriter(string);
            tracePrintWriterTracer = new PrintWriterTracer();
            tracePrintWriterTracer.setTraceWriter(traceFileWriter);
            Trace.setTracer(tracePrintWriterTracer);
            com.ibm.mqservices.Trace.setTraceStream((FileWriter)traceFileWriter);
        }
        catch (Exception exception) {
            System.err.println("Failed to initialise trace to " + string);
        }
        ConfigEnvironment.setTracingOn(string2);
        BaseConfig.setParameter("DEBUG_LEVEL", String.valueOf(-1));
        BaseConfig.setParameter("DEBUG_NAME", "*");
        DebugState.update();
        com.ibm.disthubmq.impl.client.Logger.start();
    }

    private static void initialiseJMSLogger(String string) {
        boolean bl = false;
        logSP = null;
        if (string != null) {
            try {
                final String string2 = string;
                FileLogServiceProvider fileLogServiceProvider = (FileLogServiceProvider)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new FileLogServiceProvider(ConfigEnvironment.MQJMS_LOG_SERVICE_NAME, new File(string2));
                    }
                });
                fileLogServiceProvider.setNumLogFiles(3);
                fileLogServiceProvider.setLogFilePrefix(MQJMS_LOG_FILE);
                fileLogServiceProvider.setMaxLogFileSize(5120L);
                logSP = fileLogServiceProvider;
            }
            catch (Exception exception) {
                System.err.println("error " + exception);
                bl = true;
            }
        }
        if (string == null || bl) {
            try {
                logSP = new PrintWriterLogServiceProvider(MQJMS_LOG_SERVICE_NAME, new PrintWriter(System.err));
            }
            catch (LogException logException) {
                System.err.println("error, failed to initialise stderr log");
            }
        }
        if (logSP != null) {
            com.ibm.mq.jms.services.psk.Logger.addLogServiceProvider(logSP);
            com.ibm.mq.jms.services.psk.Logger.addLogCatalogue(logMsgCat);
        }
    }

    public static void start() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("MQJMS_TRACE_LEVEL");
                }
                catch (AccessControlException accessControlException) {
                    return "";
                }
            }
        });
        if (string != null) {
            if (!(string = string.toLowerCase()).equals("on") && !string.equals("base")) {
                string = "base";
            }
        } else {
            string = "base";
        }
        ConfigEnvironment.start(string);
    }

    public static void start(String string) {
        String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("MQJMS_TRACE_DIR");
            }
        });
        if (string2 == null) {
            string2 = "./";
        }
        if (!string2.endsWith("/") && !string2.endsWith("\\")) {
            string2 = string2 + "/";
        }
        String string3 = string2 + MQJMS_TRACE_FILE;
        ConfigEnvironment.initialiseJMSTrace(string3, string);
    }

    public static void stop() {
        com.ibm.mq.jms.services.Trace.turnTracingOff();
        MQEnvironment.disableTracing();
    }

    public static void close() {
        com.ibm.mq.jms.services.Trace.turnTracingOff();
        if (!wasTracingAndLogging) {
            try {
                logSP.closeLog();
            }
            catch (Exception exception) {
                // empty catch block
            }
            com.ibm.mq.jms.services.psk.Logger.removeLogServiceProvider(MQJMS_LOG_SERVICE_NAME);
            try {
                traceFileWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String getMessage(String string) {
        String string2;
        try {
            string2 = logMsgCat.getMessage(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "<message not found>";
        }
        return string2;
    }

    public static String getMessage(String string, Object object) {
        String string2;
        try {
            string2 = logMsgCat.getMessage(string, object);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "<message not found>";
        }
        return string2;
    }

    public static String getMessage(String string, Object object, Object object2) {
        String string2;
        try {
            string2 = logMsgCat.getMessage(string, object, object2);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "<message not found>";
        }
        return string2;
    }

    public static String getErrorMessage(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(": ");
        try {
            stringBuffer.append(logMsgCat.getMessage(string));
        }
        catch (MissingResourceException missingResourceException) {
            stringBuffer.append("<message not found>");
        }
        return stringBuffer.toString();
    }

    public static String getErrorMessage(String string, Object object) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(": ");
        try {
            stringBuffer.append(logMsgCat.getMessage(string, object));
        }
        catch (MissingResourceException missingResourceException) {
            stringBuffer.append("<message not found>");
        }
        return stringBuffer.toString();
    }

    public static String getErrorMessage(String string, Object object, Object object2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(": ");
        try {
            stringBuffer.append(logMsgCat.getMessage(string, object, object2));
        }
        catch (MissingResourceException missingResourceException) {
            stringBuffer.append("<message not found>");
        }
        return stringBuffer.toString();
    }

    public static String getErrorMessage(String string, Object object, Object object2, Object object3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(": ");
        try {
            stringBuffer.append(logMsgCat.getMessage(string, object, object2, object3));
        }
        catch (MissingResourceException missingResourceException) {
            stringBuffer.append("<message not found>");
        }
        return stringBuffer.toString();
    }

    public static JMSException newException(String string) {
        return new JMSException(ConfigEnvironment.getErrorMessage(string), string);
    }

    public static JMSException newException(String string, Object object) {
        return new JMSException(ConfigEnvironment.getErrorMessage(string, object), string);
    }

    public static JMSException newException(String string, Object object, Object object2) {
        return new JMSException(ConfigEnvironment.getErrorMessage(string, object, object2), string);
    }

    public static void enableWebSphereTracingAndLogging() {
        try {
            wasMgr = new WASManager();
            wasTrcAdpt = new WASTraceAdapter();
            wasTrcAdpt.initialise(wasMgr);
            WASLogger.initialise(wasMgr, logMsgCat);
            try {
                logSP.closeLog();
            }
            catch (Exception exception) {
                // empty catch block
            }
            com.ibm.mq.jms.services.psk.Logger.removeLogServiceProvider(MQJMS_LOG_SERVICE_NAME);
            try {
                traceFileWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.setWasEnv(true);
            com.ibm.mq.jms.services.Trace._setTrace(wasTrcAdpt);
            com.ibm.mqservices.Trace.setWasEnv((boolean)true);
            JMSMessage._setTrace(wasTrcAdpt);
            com.ibm.mq.jms.services.Trace.turnTracingOn();
            MQEnvironment.enableTracing((int)5);
            wasTracingAndLogging = true;
        }
        catch (Throwable throwable) {
            wasMgr = null;
            wasTrcAdpt = null;
            System.err.println("ERROR: Unable to initialize Websphere Application Server for tracing and logging: using JMS tracing and logging: " + throwable.getMessage());
        }
    }

    public static void setTracingOn(String string) {
        JMSMessage._setTrace(com.ibm.mq.jms.services.Trace._getTrace());
        if (!string.equals("on")) {
            MQEnvironment.enableTracing((int)5);
        }
        com.ibm.mq.jms.services.Trace.turnTracingOn();
    }

    public static void setTracingOff() {
        MQEnvironment.disableTracing();
        com.ibm.mq.jms.services.Trace.turnTracingOff();
        JMSMessage._setTrace(null);
    }

    static {
        wasTrcAdpt = null;
        wasMgr = null;
        String string = "com.ibm.mq.jms.services.resources.MQJMS_MessageResourceBundle";
        try {
            logMsgCat = NLSServices.getMessageCatalogue(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("ERROR: unable to locate resource bundle '" + string + "'. Probable installation problem.");
        }
        MQJMSTranslator mQJMSTranslator = new MQJMSTranslator();
        ExceptionBuilder.setTranslator(mQJMSTranslator);
        JMSTraceAdapter jMSTraceAdapter = new JMSTraceAdapter();
        com.ibm.mq.jms.services.Trace._setTrace(jMSTraceAdapter);
        JMSMessage._setTrace(jMSTraceAdapter);
        ConnectionImpl.threadProvider = new MQThreadProvider();
        String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("MQJMS_LOG_DIR");
                }
                catch (AccessControlException accessControlException) {
                    return "";
                }
            }
        });
        if (string2 != null && !string2.endsWith("/") && !string2.endsWith("\\")) {
            string2 = string2 + "/";
        }
        ConfigEnvironment.initialiseJMSLogger(string2);
        String string3 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("MQJMS_TRACE_LEVEL");
                }
                catch (AccessControlException accessControlException) {
                    return "";
                }
            }
        });
        if (string3 != null) {
            if (!(string3 = string3.toLowerCase()).equals("off") && !string3.equals("")) {
                ConfigEnvironment.start(string3);
            } else {
                JMSMessage._setTrace(null);
            }
        } else {
            JMSMessage._setTrace(null);
        }
        if (MQEnvironment.runningInWS()) {
            ConfigEnvironment.enableWebSphereTracingAndLogging();
        }
    }
}

