/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.admin;

import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.ibm.mq.jms.admin.AP;
import com.ibm.mq.jms.admin.BAOException;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Hashtable;
import javax.jms.JMSException;

public class APMRET
extends AP {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2001, 2002.    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/admin/APMRET.java, jms, j521, j521-L020126 02/01/25 15:47:07 @(#) 1.2.1.1";
    public static final String LONGNAME = "MSGRETENTION";
    public static final String SHORTNAME = "MRET";
    public static final String YES = "YES";
    public static final String NO = "NO";

    public static String valToString(int n) throws JMSException {
        String string;
        if (n == 1) {
            string = YES;
        } else if (n == 0) {
            string = NO;
        } else {
            String string2 = "mret unexpected value " + n;
            String string3 = "MQJMS1016";
            String string4 = ConfigEnvironment.getErrorMessage(string3, string2);
            JMSException jMSException = new JMSException(string4, string3);
            throw jMSException;
        }
        return string;
    }

    public static int stringToVal(String string) throws BAOException {
        int n;
        String string2 = string.toUpperCase();
        if (string2.equals(YES)) {
            n = 1;
        } else if (string2.equals(NO)) {
            n = 0;
        } else {
            throw new BAOException(4, SHORTNAME, string2);
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setObjectFromProperty(Object object, Hashtable hashtable) throws BAOException, JMSException {
        try {
            try {
                Object object2;
                if (Trace.isOn) {
                    Trace.entry(this, "setObjectFromProperty");
                }
                if ((object2 = AP.getProperty(SHORTNAME, hashtable)) != null) {
                    String string;
                    int n;
                    if (object2 instanceof Integer) {
                        n = (Integer)object2;
                    } else {
                        if (!(object2 instanceof String)) {
                            String string2 = "value supplied as an unexpected object type";
                            String string3 = "MQJMS1016";
                            String string4 = ConfigEnvironment.getErrorMessage(string3, string2);
                            JMSException jMSException = new JMSException(string4, string3);
                            throw jMSException;
                        }
                        string = (String)object2;
                        n = APMRET.stringToVal(string);
                    }
                    if (!(object instanceof MQQueueConnectionFactory)) {
                        string = "object supplied as an unexpected type";
                        String string5 = "MQJMS1016";
                        String string6 = ConfigEnvironment.getErrorMessage(string5, string);
                        JMSException jMSException = new JMSException(string6, string5);
                        throw jMSException;
                    }
                    try {
                        ((MQQueueConnectionFactory)object).setMessageRetention(n);
                    }
                    catch (JMSException jMSException) {
                        BAOException bAOException = new BAOException(4, SHORTNAME, Integer.toString(n));
                    }
                }
                Object var10_17 = null;
                if (!Trace.isOn) return;
            }
            catch (BAOException bAOException) {
                if (!Trace.isOn) throw bAOException;
                Trace.trace(this, "throwing " + bAOException);
                throw bAOException;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var10_18 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setObjectFromProperty");
            throw throwable;
        }
        Trace.exit(this, "setObjectFromProperty");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPropertyFromObject(Hashtable hashtable, Object object) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setPropertyFromObject");
            }
            if (!(object instanceof MQQueueConnectionFactory)) {
                String string = "object is an unexpected type";
                String string2 = "MQJMS1016";
                String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                JMSException jMSException = new JMSException(string3, string2);
                throw jMSException;
            }
            int n = ((MQQueueConnectionFactory)object).getMessageRetention();
            String string = APMRET.valToString(n);
            hashtable.put(LONGNAME, string);
            Object var9_9 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setPropertyFromObject");
            throw throwable;
        }
        Trace.exit(this, "setPropertyFromObject");
    }

    public String longName() {
        return LONGNAME;
    }

    public String shortName() {
        return SHORTNAME;
    }
}

