/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.admin;

import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.admin.AP;
import com.ibm.mq.jms.admin.BAOException;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Hashtable;
import javax.jms.JMSException;

public class APEXP
extends AP {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2001, 2002.    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/admin/APEXP.java, jms, j521, j521-L020126 02/01/25 15:42:54 @(#) 1.2.1.1";
    public static final String LONGNAME = "EXPIRY";
    public static final String SHORTNAME = "EXP";
    public static final String EXP_APP = "APP";
    public static final String EXP_UNLIMITED = "UNLIM";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setObjectFromProperty(Object object, Hashtable hashtable) throws BAOException, JMSException {
        try {
            try {
                Object object2;
                if (Trace.isOn) {
                    Trace.entry(this, "setObjectFromProperty");
                }
                if ((object2 = AP.getProperty(SHORTNAME, hashtable)) != null) {
                    String string;
                    long l;
                    if (object2 instanceof Long) {
                        l = (Long)object2;
                    } else {
                        if (!(object2 instanceof String)) {
                            String string2 = "value supplied as an unexpected object type";
                            String string3 = "MQJMS1016";
                            String string4 = ConfigEnvironment.getErrorMessage(string3, string2);
                            JMSException jMSException = new JMSException(string4, string3);
                            throw jMSException;
                        }
                        string = ((String)object2).toUpperCase();
                        if (string.equals(EXP_APP)) {
                            l = -2L;
                        } else if (string.equals(EXP_UNLIMITED)) {
                            l = 0L;
                        } else {
                            try {
                                l = Long.parseLong(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                BAOException bAOException = new BAOException(4, SHORTNAME, string);
                                throw bAOException;
                            }
                        }
                    }
                    if (!(object instanceof MQDestination)) {
                        string = "object supplied as an unexpected type";
                        String string5 = "MQJMS1016";
                        String string6 = ConfigEnvironment.getErrorMessage(string5, string);
                        JMSException jMSException = new JMSException(string6, string5);
                        throw jMSException;
                    }
                    try {
                        ((MQDestination)object).setExpiry(l);
                    }
                    catch (JMSException jMSException) {
                        BAOException bAOException = new BAOException(4, SHORTNAME, Long.toString(l));
                    }
                }
                Object var11_19 = null;
                if (!Trace.isOn) return;
            }
            catch (BAOException bAOException) {
                if (!Trace.isOn) throw bAOException;
                Trace.trace(this, "throwing " + bAOException);
                throw bAOException;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var11_20 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setObjectFromProperty");
            throw throwable;
        }
        Trace.exit(this, "setObjectFromProperty");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPropertyFromObject(Hashtable hashtable, Object object) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setPropertyFromObject");
            }
            if (!(object instanceof MQDestination)) {
                String string = "object is an unexpected type";
                String string2 = "MQJMS1016";
                String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                JMSException jMSException = new JMSException(string3, string2);
                throw jMSException;
            }
            long l = ((MQDestination)object).getExpiry();
            String string = APEXP.valToString(l);
            hashtable.put(LONGNAME, string);
            Object var10_9 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setPropertyFromObject");
            throw throwable;
        }
        Trace.exit(this, "setPropertyFromObject");
    }

    public String longName() {
        return LONGNAME;
    }

    public String shortName() {
        return SHORTNAME;
    }

    public static String valToString(long l) {
        String string = l == -2L ? EXP_APP : (l == 0L ? EXP_UNLIMITED : String.valueOf(l));
        return string;
    }

    public static long stringToVal(String string) throws BAOException {
        long l;
        String string2 = string.toUpperCase();
        if (string2.equals(EXP_APP)) {
            l = -2L;
        } else if (string2.equals(EXP_UNLIMITED)) {
            l = 0L;
        } else {
            try {
                l = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                BAOException bAOException = new BAOException(4, SHORTNAME, string2);
                throw bAOException;
            }
        }
        return l;
    }
}

