/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.admin;

import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.admin.AP;
import com.ibm.mq.jms.admin.BAOException;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Hashtable;
import javax.jms.JMSException;

public class APCLS
extends AP {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2001.    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/admin/APCLS.java, jms, j521, j521-L020126 02/01/25 15:58:43 @(#) 1.1.1.1";
    private static final String CLASSNAME = "APCLS";
    public static final String LONGNAME = "CLONESUPP";
    public static final String SHORTNAME = "CLS";
    public static final String CLONE_ENABLED = "ENABLED";
    public static final String CLONE_DISABLED = "DISABLED";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setObjectFromProperty(Object object, Hashtable hashtable) throws BAOException, JMSException {
        try {
            try {
                Object object2;
                if (Trace.isOn) {
                    Trace.entry(this, "setObjectFromProperty");
                }
                if ((object2 = AP.getProperty(SHORTNAME, hashtable)) != null) {
                    int n = APCLS.objToInt(object2);
                    if (!(object instanceof MQTopicConnectionFactory)) {
                        String string = "object supplied as an unexpected type";
                        String string2 = "MQJMS1016";
                        String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                        JMSException jMSException = new JMSException(string3, string2);
                        throw jMSException;
                    }
                    try {
                        ((MQTopicConnectionFactory)object).setCloneSupport(n);
                    }
                    catch (JMSException jMSException) {
                        BAOException bAOException = new BAOException(4, SHORTNAME, Integer.toString(n));
                    }
                }
                Object var10_13 = null;
                if (!Trace.isOn) return;
            }
            catch (BAOException bAOException) {
                if (!Trace.isOn) throw bAOException;
                Trace.trace(this, "throwing " + bAOException);
                throw bAOException;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setObjectFromProperty");
            throw throwable;
        }
        Trace.exit(this, "setObjectFromProperty");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPropertyFromObject(Hashtable hashtable, Object object) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setPropertyFromObject");
            }
            if (!(object instanceof MQTopicConnectionFactory)) {
                String string = "object is an unexpected type";
                String string2 = "MQJMS1016";
                String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                JMSException jMSException = new JMSException(string3, string2);
                throw jMSException;
            }
            int n = ((MQTopicConnectionFactory)object).getCloneSupport();
            String string = APCLS.valToString(n);
            hashtable.put(LONGNAME, string);
            Object var9_9 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setPropertyFromObject");
            throw throwable;
        }
        Trace.exit(this, "setPropertyFromObject");
    }

    public String longName() {
        return LONGNAME;
    }

    public String shortName() {
        return SHORTNAME;
    }

    public static int stringToVal(String string) throws BAOException {
        int n;
        String string2 = string.toUpperCase();
        if (string2.equals(CLONE_ENABLED)) {
            n = 1;
        } else if (string2.equals(CLONE_DISABLED)) {
            n = 0;
        } else {
            throw new BAOException(4, SHORTNAME, string2);
        }
        return n;
    }

    public static String valToString(int n) throws JMSException {
        String string;
        if (n == 1) {
            string = CLONE_ENABLED;
        } else if (n == 0) {
            string = CLONE_DISABLED;
        } else {
            String string2 = "broker version unexpected value " + n;
            String string3 = "MQJMS1016";
            String string4 = ConfigEnvironment.getErrorMessage(string3, string2);
            JMSException jMSException = new JMSException(string4, string3);
            throw jMSException;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int objToInt(Object object) throws BAOException, JMSException {
        int n;
        try {
            int n2;
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "objToInt");
            }
            if (object instanceof Integer) {
                n2 = (Integer)object;
            } else if (object instanceof String) {
                String string = (String)object;
                n2 = APCLS.stringToVal(string);
            } else {
                String string = "value supplied as an unexpected object type";
                String string2 = "MQJMS1016";
                String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                JMSException jMSException = new JMSException(string3, string2);
                throw jMSException;
            }
            n = n2;
            Object var7_8 = null;
            if (!Trace.isOn) return n;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLASSNAME, "objToInt");
            throw throwable;
        }
        Trace.exit(CLASSNAME, "objToInt");
        return n;
    }
}

