/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQC;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.PCF;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.GregorianCalendar;
import javax.jms.JMSException;
import javax.transaction.TransactionManager;

class Utils {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2000, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/Utils.java, jms, j521, j521-L020126 02/01/25 15:19:41 @(#) 1.20.1.1";
    static final int MQCA_BASE_Q_NAME = 2002;
    static final int MQCA_Q_MGR_NAME = 2015;
    static final int MQCA_Q_NAME = 2016;
    static final int MQCA_DEAD_LETTER_Q_NAME = 2006;
    static final int MQCA_BACKOUT_REQ_Q_NAME = 2019;
    static final int MQIA_DEFINITION_TYPE = 7;
    static final int MQIA_Q_TYPE = 20;
    static final int MQIA_BACKOUT_THRESHOLD = 22;
    private static final String CLASSNAME = "com.ibm.mq.jms.Utils";
    private static final int BUFSIZE = 128;
    private static final String BLANK48 = "                                                ";
    private static Object xactionManager = null;
    private static boolean wasNotDetected = false;
    private static final Object xactionManagerLock = new Object();

    Utils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void clearQueue(MQQueueManager mQQueueManager, String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "clearQueue");
            Trace.trace(CLASSNAME, "Queue to clear is '" + string + "'");
        }
        try {
            try {
                MQQueue mQQueue = mQQueueManager.accessQueue(mQQueueManager.getCommandInputQueueName(), 16);
                MQQueue mQQueue2 = mQQueueManager.accessQueue("SYSTEM.DEFAULT.MODEL.QUEUE", 4, null, "JMS.UTILS.TEMP.*", null);
                PCF pCF = new PCF(9);
                pCF.addParameter(2016, string);
                MQMessage mQMessage = new MQMessage();
                mQMessage.replyToQueueName = mQQueue2.name;
                pCF.write(mQMessage);
                mQQueue.put(mQMessage, new MQPutMessageOptions());
                mQQueue.close();
                MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                mQGetMessageOptions.options = 1;
                mQGetMessageOptions.waitInterval = 5000;
                mQMessage.messageId = MQC.MQMI_NONE;
                mQQueue2.get(mQMessage, mQGetMessageOptions);
                mQQueue2.close();
                PCF pCF2 = null;
                if (mQMessage != null) {
                    pCF2 = new PCF(mQMessage);
                }
                if (pCF2 == null) {
                    throw new Exception("PCF command failed. No response!");
                }
                if (pCF2.reason != 0) {
                    throw new Exception("PCF command failed. Reason was " + pCF2.reason);
                }
                Object var9_10 = null;
                if (!Trace.isOn) return;
            }
            catch (Exception exception) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                jMSException.setLinkedException(exception);
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Create and Throwing " + (Object)((Object)jMSException));
                }
                if (!Trace.isOn) throw jMSException;
                Trace.trace(CLASSNAME, "Linked Exception " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLASSNAME, "clearQueue");
            throw throwable;
        }
        Trace.exit(CLASSNAME, "clearQueue");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] listMatchingQueues(MQQueueManager mQQueueManager, String string) {
        String string2;
        StringBuffer stringBuffer;
        String[] stringArray = null;
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "listMatchingQueues");
        }
        try {
            try {
                MQQueue mQQueue = mQQueueManager.accessQueue("SYSTEM.DEFAULT.MODEL.QUEUE", 4, null, "JMS.UTILS.TEMP.*", null);
                stringArray = Utils.listMatchingQueues(mQQueueManager, mQQueue, string);
                mQQueue.closeOptions = 2;
                mQQueue.close();
            }
            catch (Exception exception) {
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Exception in listMatchingQueues: " + exception);
                    Trace.trace(CLASSNAME, "Consume and continue");
                }
                Object var5_6 = null;
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "listMatchingQueues returning " + (stringArray == null ? "<null>" : stringArray.length + " queue names"));
                    Trace.exit(CLASSNAME, "listMatchingQueues");
                }
                return stringArray;
            }
            Object var5_5 = null;
            if (!Trace.isOn) return stringArray;
            stringBuffer = new StringBuffer().append("listMatchingQueues returning ");
            string2 = stringArray == null ? "<null>" : stringArray.length + " queue names";
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!Trace.isOn) return stringArray;
            Trace.trace(CLASSNAME, "listMatchingQueues returning " + (stringArray == null ? "<null>" : stringArray.length + " queue names"));
            Trace.exit(CLASSNAME, "listMatchingQueues");
            return stringArray;
        }
        Trace.trace(CLASSNAME, stringBuffer.append(string2).toString());
        Trace.exit(CLASSNAME, "listMatchingQueues");
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] listMatchingQueues(MQQueueManager mQQueueManager, MQQueue mQQueue, String string) {
        String[] stringArray;
        block8: {
            String string2;
            StringBuffer stringBuffer;
            stringArray = null;
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "listMatchingQueues");
                Trace.trace(CLASSNAME, "Using replyQ '" + mQQueue.name + "'");
                Trace.trace(CLASSNAME, "filter is '" + string + "'");
            }
            try {
                try {
                    PCF pCF;
                    MQQueue mQQueue2 = mQQueueManager.accessQueue("SYSTEM.ADMIN.COMMAND.QUEUE", 16);
                    PCF pCF2 = new PCF(18);
                    pCF2.addParameter(2016, string);
                    pCF2.addParameter(20, 1);
                    MQMessage mQMessage = new MQMessage();
                    mQMessage.replyToQueueName = mQQueue.name;
                    mQMessage.expiry = 5000;
                    pCF2.write(mQMessage);
                    mQQueue2.put(mQMessage, new MQPutMessageOptions());
                    mQQueue2.close();
                    MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                    mQGetMessageOptions.options = 1;
                    mQGetMessageOptions.waitInterval = 5000;
                    mQMessage.correlationId = mQMessage.messageId;
                    mQMessage.messageId = MQC.MQMI_NONE;
                    mQQueue.get(mQMessage, mQGetMessageOptions);
                    if (mQMessage != null && (pCF = new PCF(mQMessage)).getParameterCount() == 1 && pCF.getParameterType(0) == 6) {
                        stringArray = ((PCF.MQCFSL)pCF.getParameterAt(0)).getStrings();
                    }
                }
                catch (Exception exception) {
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Exception in listMatchingQueues: " + exception);
                        Trace.trace(CLASSNAME, "Consume and continue");
                    }
                    Object var10_11 = null;
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "listMatchingQueues returning " + (stringArray == null ? "<null>" : stringArray.length + " queue names"));
                        Trace.exit(CLASSNAME, "listMatchingQueues");
                    }
                    return stringArray;
                }
                Object var10_10 = null;
                if (!Trace.isOn) break block8;
                stringBuffer = new StringBuffer().append("listMatchingQueues returning ");
                string2 = stringArray == null ? "<null>" : stringArray.length + " queue names";
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (!Trace.isOn) return stringArray;
                Trace.trace(CLASSNAME, "listMatchingQueues returning " + (stringArray == null ? "<null>" : stringArray.length + " queue names"));
                Trace.exit(CLASSNAME, "listMatchingQueues");
                return stringArray;
            }
            Trace.trace(CLASSNAME, stringBuffer.append(string2).toString());
            Trace.exit(CLASSNAME, "listMatchingQueues");
        }
        return stringArray;
    }

    static String bytesToHex(byte[] byArray, int n) {
        if (byArray == null) {
            return "<null>";
        }
        int n2 = byArray.length;
        if (n != -1 && n < n2) {
            n2 = n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = byArray[n3];
            if (n4 < 0) {
                n4 += 256;
            }
            if (n4 < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n4).toUpperCase());
            ++n3;
        }
        return stringBuffer.toString();
    }

    static String bytesToHex(byte[] byArray) {
        return Utils.bytesToHex(byArray, -1);
    }

    static byte[] hexToBytes(String string) throws JMSException {
        byte[] byArray = null;
        if (string != null) {
            int n = string.length();
            if (n % 2 != 0) {
                throw ConfigEnvironment.newException("MQJMS1044");
            }
            byArray = new byte[n /= 2];
            int n2 = 0;
            while (n2 < n) {
                int n3 = Character.digit(string.charAt(2 * n2), 16);
                int n4 = Character.digit(string.charAt(2 * n2 + 1), 16);
                if (n3 == -1 || n4 == -1) {
                    throw ConfigEnvironment.newException("MQJMS1044");
                }
                byArray[n2] = (byte)(n3 * 16 + n4);
                ++n2;
            }
        }
        return byArray;
    }

    static String inquireString(MQManagedObject mQManagedObject, int n) {
        String string;
        block2: {
            string = null;
            try {
                string = mQManagedObject.getAttributeString(n, 128).trim();
            }
            catch (Exception exception) {
                if (!Trace.isOn) break block2;
                Trace.exception(CLASSNAME, "inquireString", (Throwable)exception);
            }
        }
        return string;
    }

    static int inquireInt(MQManagedObject mQManagedObject, int n) {
        int n2;
        block2: {
            n2 = -1;
            try {
                int[] nArray = new int[]{n};
                int[] nArray2 = new int[1];
                byte[] byArray = null;
                mQManagedObject.inquire(nArray, nArray2, byArray);
                n2 = nArray2[0];
            }
            catch (Exception exception) {
                if (!Trace.isOn) break block2;
                Trace.exception(CLASSNAME, "inquireInt", (Throwable)exception);
            }
        }
        return n2;
    }

    static String padString(String string, int n) {
        if (n > 0) {
            int n2;
            if (string == null) {
                string = "";
            }
            if ((n2 = string.length()) > n) {
                string = string.substring(0, n);
            } else if (n2 < n) {
                int n3 = n - n2;
                while (n3 > 0) {
                    string = string + BLANK48.substring(0, n3 < 48 ? n3 : 48);
                    n3 = n - string.length();
                }
            }
        }
        return string;
    }

    static String getDate(GregorianCalendar gregorianCalendar) {
        String string;
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "getDate");
        }
        if (gregorianCalendar != null) {
            int n = gregorianCalendar.get(1);
            int n2 = gregorianCalendar.get(2) + 1;
            int n3 = gregorianCalendar.get(5);
            string = "00000000" + (n * 10000 + n2 * 100 + n3);
            string = string.substring(string.length() - 8);
        } else {
            string = "        ";
        }
        if (Trace.isOn) {
            Trace.trace(CLASSNAME, "Date string is '" + string + "'");
            Trace.exit(CLASSNAME, "getDate");
        }
        return string;
    }

    static String getTime(GregorianCalendar gregorianCalendar) {
        String string;
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "getTime");
        }
        if (gregorianCalendar != null) {
            int n = gregorianCalendar.get(11);
            int n2 = gregorianCalendar.get(12);
            int n3 = gregorianCalendar.get(13);
            int n4 = gregorianCalendar.get(14) / 10;
            string = "00000000" + (n * 1000000 + n2 * 10000 + n3 * 100 + n4);
            string = string.substring(string.length() - 8);
        } else {
            string = "        ";
        }
        if (Trace.isOn) {
            Trace.trace(CLASSNAME, "Time string is '" + string + "'");
            Trace.exit(CLASSNAME, "getTime");
        }
        return string;
    }

    static boolean byteArraysEqual(byte[] byArray, byte[] byArray2) {
        boolean bl;
        if (byArray == byArray2) {
            bl = true;
        } else if (byArray.length != byArray2.length) {
            bl = false;
        } else {
            bl = true;
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (byArray[n2] != byArray2[n2]) {
                    bl = false;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    static boolean isRRSTransactionInProgress() {
        Object object;
        Object object2;
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "isRRSTransactionInProgress");
        }
        if (wasNotDetected) {
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Previous call did not detect a WAS OS/390 TransactionManager");
                Trace.trace(CLASSNAME, "Returning false");
                Trace.exit(CLASSNAME, "isRRSTransactionInProgress");
            }
            return false;
        }
        if (xactionManager == null) {
            object2 = xactionManagerLock;
            synchronized (object2) {
                if (xactionManager == null) {
                    TransactionManager transactionManager;
                    try {
                        Class.forName("javax.transaction.TransactionManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "Class javax.transaction.TransactionManager not found; WAS OS/390 not detected");
                            Trace.trace(CLASSNAME, "Returning false");
                            Trace.exit(CLASSNAME, "isRRSTransactionInProgress");
                        }
                        wasNotDetected = true;
                        boolean bl = false;
                        return bl;
                    }
                    object = (String)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return System.getProperty("com.ibm.ws390.jta.TransactionManager", "com.ibm.ws390.tx.TransactionManagerImpl");
                        }
                    });
                    Method method = null;
                    try {
                        transactionManager = Class.forName((String)object);
                        method = transactionManager.getMethod("getTransactionManager", null);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "Class " + (String)object + " not found; WAS OS/390 not detected");
                            Trace.trace(CLASSNAME, "Returning false");
                            Trace.exit(CLASSNAME, "isRRSTransactionInProgress");
                        }
                        wasNotDetected = true;
                        boolean bl = false;
                        return bl;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "Method getTransactionManager() not found on tm implementation");
                            Trace.exception(CLASSNAME, "isRRSTransactionInProgress", (Throwable)noSuchMethodException);
                            Trace.trace(CLASSNAME, "Returning false");
                            Trace.exit(CLASSNAME, "isRRSTransactionInProgress");
                        }
                        wasNotDetected = true;
                        boolean bl = false;
                        return bl;
                    }
                    try {
                        transactionManager = (TransactionManager)method.invoke(null, null);
                        if (transactionManager == null) {
                            if (Trace.isOn) {
                                Trace.trace(CLASSNAME, "No TransactionManager present. Reverting to local transaction behaviour for this JVM");
                                Trace.trace(CLASSNAME, "Returning false");
                                Trace.exit(CLASSNAME, "isRRSTransactionInProgress");
                            }
                            wasNotDetected = true;
                            boolean bl = false;
                            return bl;
                        }
                        xactionManager = transactionManager;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "Error when finding TransactionManager");
                            Trace.exception(CLASSNAME, "isRRSTransactionInProgress", (Throwable)invocationTargetException);
                            Trace.trace(CLASSNAME, "Returning false");
                            Trace.exit(CLASSNAME, "isRRSTransactionInProgress");
                        }
                        wasNotDetected = true;
                        boolean bl = false;
                        return bl;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "Error when finding TransactionManager");
                            Trace.exception(CLASSNAME, "isRRSTransactionInProgress", (Throwable)illegalAccessException);
                            Trace.trace(CLASSNAME, "Returning false");
                            Trace.exit(CLASSNAME, "isRRSTransactionInProgress");
                        }
                        wasNotDetected = true;
                        boolean bl = false;
                        return bl;
                    }
                }
            }
        }
        object2 = null;
        try {
            object = (TransactionManager)xactionManager;
            object2 = object.getTransaction();
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Unexpected exception while getting Transaction");
                Trace.exception(CLASSNAME, "isRRSTransactionInProgress", (Throwable)exception);
                Trace.trace(CLASSNAME, "Returning false");
                Trace.exit(CLASSNAME, "isRRSTransactionInProgress");
            }
            return false;
        }
        if (Trace.isOn) {
            if (object2 == null) {
                Trace.trace(CLASSNAME, "No global transaction present; returning false");
            } else {
                Trace.trace(CLASSNAME, "Global transaction active on this thread; returning true");
            }
            Trace.exit(CLASSNAME, "isRRSTransactionInProgress");
        }
        return object2 != null;
    }
}

