/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.matching.InvalidTopicSyntaxException;
import com.ibm.disthubmq.impl.matching.MatchingException;
import com.ibm.disthubmq.impl.matching.QuerySyntaxException;
import com.ibm.disthubmq.impl.matching.parser.Environment;
import com.ibm.disthubmq.impl.matching.parser.TypeCheckException;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.disthubmq.spi.ExceptionConstants;
import com.ibm.mq.jms.ConnectionImpl;
import com.ibm.mq.jms.JMSWrappedException;
import com.ibm.mq.jms.JmsIpFieldProcessor;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MessageConsumerImpl;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.TemporaryTopicImpl;
import com.ibm.mq.jms.TopicSessionImpl;
import com.ibm.mq.jms.services.Trace;
import java.io.IOException;
import java.io.Serializable;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class TopicSubscriberImpl
extends MessageConsumerImpl
implements TopicSubscriber,
ClientExceptionConstants,
ExceptionConstants,
Serializable {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM 5648-C60(c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/TopicSubscriberImpl.java, jms, j521, j521-L020702 02/07/01 17:27:42 @(#) 1.7.1.5";
    private static final long serialVersionUID = -7718791450874296380L;
    private static final DebugObject debug = new DebugObject("TopicSubscriberImpl");
    private MQTopic topic;
    private boolean noLocalMessages;
    private final Environment initEnv = new Environment();
    private int subId = -1;

    TopicSubscriberImpl(MQTopic mQTopic, String string, boolean bl, TopicSessionImpl topicSessionImpl) throws JMSException {
        super(mQTopic.toStringInternal(), string, topicSessionImpl);
        this.noLocalMessages = bl;
        this.topic = mQTopic;
        String string2 = "";
        if (mQTopic != null) {
            string2 = mQTopic.toStringInternal();
        }
        if (topicSessionImpl != null) {
            ConnectionImpl connectionImpl = topicSessionImpl.getConnection();
            try {
                this.initEnv.bind("JMSDeliveryMode", 2);
                this.initEnv.bind("JMSPriority", 2);
                this.initEnv.bind("JMSMessageID", 4);
                this.initEnv.bind("JMSTimestamp", 2);
                this.initEnv.bind("JMSCorrelationID", 4);
                this.initEnv.bind("JMSType", 4);
            }
            catch (TypeCheckException typeCheckException) {
                // empty catch block
            }
            try {
                connectionImpl.matchSpace.put(string2, string, this, null, this.initEnv, new JmsIpFieldProcessor());
            }
            catch (MatchingException matchingException) {
                if (Trace.isOn) {
                    Trace.entry(this, "TopicSubscriberImpl");
                    Trace.trace(this, "Exception - " + matchingException + " \n throwing JMSWrappedException.");
                    Trace.exit(this, "TopicSubscriberImpl");
                }
                throw new JMSWrappedException(ExceptionBuilder.buildReasonString(1232, new Object[]{matchingException}), matchingException);
            }
            catch (InvalidTopicSyntaxException invalidTopicSyntaxException) {
                if (Trace.isOn) {
                    Trace.entry(this, "TopicSubscriberImpl");
                    Trace.trace(this, "Exception - " + invalidTopicSyntaxException + " \n throwing JMSWrappedException.");
                    Trace.exit(this, "TopicSubscriberImpl");
                }
                throw new JMSWrappedException(ExceptionBuilder.buildReasonString(1122, new Object[]{string2, string, invalidTopicSyntaxException}), invalidTopicSyntaxException);
            }
            catch (QuerySyntaxException querySyntaxException) {
                if (Trace.isOn) {
                    Trace.entry(this, "TopicSubscriberImpl");
                    Trace.trace(this, "Exception - " + querySyntaxException + " \n throwing InvalidSelectorException.");
                    Trace.exit(this, "TopicSubscriberImpl");
                }
                throw new InvalidSelectorException(ExceptionBuilder.buildReasonString(1122, new Object[]{string2, string, querySyntaxException}));
            }
            try {
                this.subId = connectionImpl.subscribe(string2, string);
            }
            catch (IOException iOException) {
                int n = ExceptionBuilder.extractType(iOException.toString());
                try {
                    connectionImpl.matchSpace.remove(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (Trace.isOn) {
                    Trace.entry(this, "TopicSubscriberImpl");
                    Trace.trace(this, "Exception - " + iOException + " \n throwing JMSWrappedException.");
                    Trace.exit(this, "TopicSubscriberImpl");
                }
                if (n == 1312 || n == 1313) {
                    throw new JMSSecurityException(ExceptionBuilder.buildReasonString(1121, new Object[]{iOException}));
                }
                throw new JMSWrappedException(ExceptionBuilder.buildReasonString(1121, new Object[]{iOException}), iOException);
            }
        }
    }

    public void newMessage(MessageImpl messageImpl) {
        if (!this.noLocalMessages || !this.getSession().getConnection().isLocalMid(messageImpl.getMessageID())) {
            super.newMessage(messageImpl);
        }
    }

    public Topic getTopic() {
        return this.topic;
    }

    public boolean getNoLocal() {
        return this.noLocalMessages;
    }

    public void close() throws JMSException {
        TopicSessionImpl topicSessionImpl;
        if (this.isClosed()) {
            return;
        }
        if (this.topic != null && this.topic instanceof TemporaryTopicImpl) {
            ((TemporaryTopicImpl)this.topic).decUse();
        }
        if ((topicSessionImpl = (TopicSessionImpl)this.getSession()) == null) {
            return;
        }
        ConnectionImpl connectionImpl = topicSessionImpl.getConnection();
        try {
            connectionImpl.matchSpace.remove(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (connectionImpl.isActive() && this.subId != -1) {
            try {
                connectionImpl.unsubscribe(this.subId);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.close();
    }

    public void close(Exception exception, boolean bl) throws JMSException {
        if (this.isClosed()) {
            return;
        }
        TopicSessionImpl topicSessionImpl = (TopicSessionImpl)this.getSession();
        if (topicSessionImpl == null) {
            return;
        }
        if (this.topic != null && this.topic instanceof TemporaryTopicImpl) {
            ((TemporaryTopicImpl)this.topic).decUse();
        }
        ConnectionImpl connectionImpl = topicSessionImpl.getConnection();
        try {
            connectionImpl.matchSpace.remove(this);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        if (connectionImpl.isActive() && this.subId != -1) {
            try {
                connectionImpl.unsubscribe(this.subId);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.close(exception, bl);
    }
}

