/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.security.ICrypto;
import com.ibm.disthubmq.impl.security.MinCrypto;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.mq.jms.JMSInvalidParameterException;
import com.ibm.mq.jms.JMSNotSupportedException;
import com.ibm.mq.jms.JMSParameterIsNullException;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.SessionImpl;
import com.ibm.mq.jms.TemporaryTopicImpl;
import com.ibm.mq.jms.TopicConnectionImpl;
import com.ibm.mq.jms.TopicPublisherImpl;
import com.ibm.mq.jms.TopicSubscriberImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.Serializable;
import java.util.Vector;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public final class TopicSessionImpl
extends SessionImpl
implements TopicSession,
ClientExceptionConstants,
Serializable {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM 5648-C60(c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/TopicSessionImpl.java, jms, j521, j521-L020622 02/06/21 18:22:57 @(#) 1.13.1.8";
    private static final long serialVersionUID = -707352621412550726L;
    private static final DebugObject debug = new DebugObject("TopicSessionImpl");
    private static final ICrypto cryptorand = new MinCrypto();
    private String unlikely;
    private int topicCounter;

    TopicSessionImpl(TopicConnectionImpl topicConnectionImpl, boolean bl, int n) throws JMSInvalidParameterException, JMSNotSupportedException {
        super(topicConnectionImpl, bl, n);
    }

    private void makeUnlikely() {
        byte[] byArray = cryptorand.random(20);
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        int n = 0;
        while (n < byArray.length) {
            char c = (char)(byArray[n] & 0xFF);
            if (c != '/' && c != '#' && c != '+' && c >= '0' && c <= 'z') {
                stringBuffer.append(c);
            }
            ++n;
        }
        this.unlikely = stringBuffer.toString();
    }

    public Topic createTopic(String string) throws JMSParameterIsNullException, JMSInvalidParameterException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createTopic");
        }
        if (string == null || string.length() == 0) {
            if (Trace.isOn) {
                Trace.trace(this, "No topic Name - JMSParameterIsNullException");
                Trace.exit(this, "createTopic");
            }
            String string2 = "MQJMS4124";
            String string3 = ConfigEnvironment.getErrorMessage(string2, "TopicName");
            throw new JMSParameterIsNullException(string3);
        }
        if (Trace.isOn) {
            Trace.exit(this, "createTopic");
        }
        return new MQTopic(string);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.createSubscriber(topic, null, false);
    }

    public TopicSubscriber createSubscriber(Topic topic, String string) throws JMSException {
        return this.createSubscriber(topic, string, false);
    }

    public TopicSubscriber createSubscriber(Topic topic, String string, boolean bl) throws JMSException {
        MQTopic mQTopic = null;
        Object var5_5 = null;
        Trace.checkForTurnTracingOn();
        if (Trace.isOn) {
            Trace.entry(this, "createSubscriber");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "createSubscriber");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString(1116, null));
        }
        if (topic == null || topic.toString().length() == 0) {
            if (Trace.isOn) {
                Trace.trace(this, "Topic is Null - InvalidDestinationException");
                Trace.exit(this, "createSubscriber");
            }
            String string2 = "MQJMS4124";
            String string3 = ConfigEnvironment.getErrorMessage(string2, "Topic");
            throw new InvalidDestinationException(string3, string2);
        }
        if (!(topic instanceof MQTopic)) {
            if (Trace.isOn) {
                Trace.trace(this, "Not an MQTopic - InvalidDestinationException");
                Trace.exit(this, "createSubscriber");
            }
            String string4 = "MQJMS0003";
            String string5 = ConfigEnvironment.getErrorMessage(string4);
            throw new InvalidDestinationException(string5, string4);
        }
        mQTopic = (MQTopic)topic;
        if (mQTopic.containsAnyWildcard() && mQTopic.getBrokerVersion() == 0) {
            if (Trace.isOn) {
                Trace.trace(this, "Invalid wildcard - InvalidDestinationException");
                Trace.exit(this, "createSubscriber");
            }
            String string6 = "MQJMS0003";
            String string7 = ConfigEnvironment.getErrorMessage(string6);
            throw new InvalidDestinationException(string7, string6);
        }
        if (topic instanceof TemporaryTopicImpl && !((TemporaryTopicImpl)topic).isCreatedOnThisConnection(this)) {
            if (Trace.isOn) {
                Trace.trace(this, "Temporary Topic not created on this connection - JMSException");
                Trace.exit(this, "createSubscriber");
            }
            throw new JMSException(ExceptionBuilder.buildReasonString(1120, null));
        }
        if (topic instanceof TemporaryTopicImpl) {
            ((TemporaryTopicImpl)topic).incUse();
        }
        TopicSubscriberImpl topicSubscriberImpl = new TopicSubscriberImpl(mQTopic, string, bl, this);
        TopicSessionImpl topicSessionImpl = this;
        synchronized (topicSessionImpl) {
            this.consumers.addElement(topicSubscriberImpl);
            if (!this.isStopped()) {
                topicSubscriberImpl.start();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "createSubscriber");
        }
        return topicSubscriberImpl;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createDurableSubscriber");
            Trace.trace(this, "JMSException");
            Trace.exit(this, "createDurableSubscriber");
        }
        String string2 = "MQJMS6311";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        throw new JMSException(string3, string2);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createDurableSubscriber");
            Trace.trace(this, "JMSException");
            Trace.exit(this, "createDurableSubscriber");
        }
        String string3 = "MQJMS6311";
        String string4 = ConfigEnvironment.getErrorMessage(string3);
        throw new JMSException(string4, string3);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2) throws JMSParameterIsNullException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createDurableSubscriber");
            Trace.trace(this, "JMSException");
            Trace.exit(this, "createDurableSubscriber");
        }
        String string3 = "MQJMS6311";
        String string4 = ConfigEnvironment.getErrorMessage(string3);
        throw new JMSException(string4, string3);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createPublisher");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed - IllegalStateException");
                Trace.exit(this, "createPublisher");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString(1116, null));
        }
        if (topic instanceof TemporaryTopicImpl) {
            ((TemporaryTopicImpl)topic).incUse();
        }
        TopicPublisherImpl topicPublisherImpl = new TopicPublisherImpl(topic, this);
        this.producers.addElement(topicPublisherImpl);
        if (Trace.isOn) {
            Trace.exit(this, "createPublisher");
        }
        return topicPublisherImpl;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.unlikely == null) {
            this.makeUnlikely();
        }
        String string = this.unlikely + '/' + this.topicCounter++;
        return new TemporaryTopicImpl(this, this.getConnection().getTemporaryTopicString(string));
    }

    public void unsubscribe(String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "unsubscribe");
            Trace.trace(this, "JMSException");
            Trace.exit(this, "unsubscribe");
        }
        String string2 = "MQJMS6311";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        throw new JMSException(string3, string2);
    }

    public void close() throws JMSException {
        TopicSubscriber topicSubscriber;
        int n;
        Vector vector;
        if (this.isClosed()) {
            return;
        }
        if (this.consumers != null) {
            vector = (Vector)this.consumers.clone();
            n = 0;
            while (n < vector.size()) {
                topicSubscriber = (TopicSubscriber)vector.elementAt(n);
                try {
                    topicSubscriber.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                ++n;
            }
        }
        if (this.producers != null) {
            vector = (Vector)this.producers.clone();
            n = 0;
            while (n < vector.size()) {
                topicSubscriber = (TopicPublisher)vector.elementAt(n);
                try {
                    topicSubscriber.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                ++n;
            }
        }
        this.consumers.removeAllElements();
        this.producers.removeAllElements();
        super.close();
    }

    public void close(Exception exception, boolean bl) throws JMSException {
        TopicSubscriberImpl topicSubscriberImpl;
        int n;
        Vector vector;
        if (this.isClosed()) {
            return;
        }
        if (this.consumers != null) {
            vector = (Vector)this.consumers.clone();
            n = 0;
            while (n < vector.size()) {
                topicSubscriberImpl = (TopicSubscriberImpl)vector.elementAt(n);
                try {
                    topicSubscriberImpl.close(exception, bl);
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                ++n;
            }
        }
        if (this.producers != null) {
            vector = (Vector)this.producers.clone();
            n = 0;
            while (n < vector.size()) {
                topicSubscriberImpl = (TopicPublisher)vector.elementAt(n);
                try {
                    topicSubscriberImpl.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                ++n;
            }
        }
        this.consumers.removeAllElements();
        this.producers.removeAllElements();
        super.close(exception, bl);
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    void closed(TopicSubscriberImpl topicSubscriberImpl) throws JMSException {
        Assert.condition(this.consumers.removeElement(topicSubscriberImpl));
    }

    void closed(TopicPublisherImpl topicPublisherImpl) throws JMSException {
        Assert.condition(this.producers.removeElement(topicPublisherImpl));
    }
}

