/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.mq.jms.BytesMessageImpl;
import com.ibm.mq.jms.JMSNotActiveException;
import com.ibm.mq.jms.JMSNotSupportedException;
import com.ibm.mq.jms.JMSParameterIsNullException;
import com.ibm.mq.jms.JMSWrappedException;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MapMessageImpl;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.MessageProducerImpl;
import com.ibm.mq.jms.ObjectMessageImpl;
import com.ibm.mq.jms.SessionImpl;
import com.ibm.mq.jms.StreamMessageImpl;
import com.ibm.mq.jms.TemporaryTopicImpl;
import com.ibm.mq.jms.TextMessageImpl;
import com.ibm.mq.jms.TopicSessionImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;

public class TopicPublisherImpl
extends MessageProducerImpl
implements TopicPublisher,
ClientExceptionConstants {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM 5648-C60(c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/TopicPublisherImpl.java, jms, j521, j521-L020205 02/02/04 15:32:39 @(#) 1.16.1.2";
    private static final DebugObject debug = new DebugObject("TopicPublisherImpl");
    private MQTopic topic;

    TopicPublisherImpl(Topic topic, TopicSessionImpl topicSessionImpl) throws JMSNotActiveException, InvalidDestinationException {
        super(topicSessionImpl);
        if (Trace.isOn) {
            Trace.entry(this, "TopicPublisherImpl");
        }
        if (topic != null) {
            if (!(topic instanceof MQTopic)) {
                if (Trace.isOn) {
                    Trace.trace(this, "Not an MQTopic - InvalidDestinationException");
                    Trace.exit(this, "TopicPublisherImpl");
                }
                throw new InvalidDestinationException(ExceptionBuilder.buildReasonString(1117, new Object[]{topic.getClass().toString()}));
            }
            this.topic = (MQTopic)topic;
            if (this.topic.containsWildcard()) {
                if (Trace.isOn) {
                    Trace.trace(this, "Not an MQTopic - InvalidDestinationException");
                    Trace.exit(this, "TopicPublisherImpl");
                }
                throw new InvalidDestinationException(ExceptionBuilder.buildReasonString(1118, new Object[]{this.topic}));
            }
        }
    }

    public Topic getTopic() {
        return this.topic;
    }

    public void publish(Message message) throws JMSException {
        Trace.checkForTurnTracingOn();
        if (Trace.isOn) {
            Trace.entry(this, "publish");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "publish");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString(1116, null));
        }
        if (this.topic == null) {
            if (Trace.isOn) {
                Trace.trace(this, "this.topic == null - JMSNotSupportedException");
                Trace.exit(this, "publish");
            }
            String string = "MQJMS4124";
            String string2 = ConfigEnvironment.getErrorMessage(string, "Topic");
            throw new JMSNotSupportedException(string2);
        }
        this.publish(message, this.deliveryMode, this.priority, this.timeToLive);
        if (Trace.isOn) {
            Trace.exit(this, "publish");
        }
    }

    public void publish(Message message, int n, int n2, long l) throws JMSException {
        Trace.checkForTurnTracingOn();
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "publish");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString(1116, null));
        }
        if (this.topic == null) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "this.topic == null - JMSNotSupportedException");
                Trace.exit(this, "publish");
            }
            String string = "MQJMS4124";
            String string2 = ConfigEnvironment.getErrorMessage(string, "Topic");
            throw new JMSNotSupportedException(string2);
        }
        MessageImpl.validateDeliveryMode(n);
        MessageImpl.validatePriority(n2);
        if (l > 0L) {
            String string = "MQJMS1010";
            String string3 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string3, string);
        }
        if (l != -1L && l < 0L) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Time to Live", String.valueOf(l));
            throw jMSException;
        }
        MessageImpl messageImpl = message instanceof MessageImpl ? (MessageImpl)message : this.createGryphonDomesticMessage(message);
        this.publishInternal(this.topic, messageImpl, n, n2, l);
    }

    private MessageImpl createGryphonDomesticMessage(Message message) throws JMSException {
        Object object;
        if (message instanceof MessageImpl) {
            return (MessageImpl)message;
        }
        MessageImpl messageImpl = null;
        SessionImpl sessionImpl = this.getSession();
        Class<?> clazz = message.getClass();
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n].getName().equals("javax.jms.ByteMessage")) {
                messageImpl = (BytesMessageImpl)sessionImpl.createBytesMessage();
                object = new byte[256];
                int n2 = -1;
                while ((n2 = ((BytesMessage)message).readBytes((byte[])object)) == ((Object)object).length) {
                    ((BytesMessage)messageImpl).writeBytes((byte[])object);
                }
                if (n2 == -1) break;
                ((BytesMessage)messageImpl).writeBytes((byte[])object, 0, n2);
                break;
            }
            if (classArray[n].getName().equals("javax.jms.StreamMessage")) {
                messageImpl = (StreamMessageImpl)sessionImpl.createStreamMessage();
                try {
                    while (true) {
                        ((StreamMessage)messageImpl).writeObject(((StreamMessage)message).readObject());
                    }
                }
                catch (MessageEOFException messageEOFException) {
                    break;
                }
            }
            if (classArray[n].getName().equals("javax.jms.TextMessage")) {
                messageImpl = (TextMessageImpl)sessionImpl.createTextMessage();
                ((TextMessage)messageImpl).setText(((TextMessage)message).getText());
                break;
            }
            if (classArray[n].getName().equals("javax.jms.ObjectMessage")) {
                messageImpl = (ObjectMessageImpl)sessionImpl.createObjectMessage();
                ((ObjectMessage)messageImpl).setObject(((ObjectMessage)message).getObject());
                break;
            }
            if (classArray[n].getName().equals("javax.jms.MapMessage")) {
                messageImpl = (MapMessageImpl)sessionImpl.createMapMessage();
                object = ((MapMessage)messageImpl).getMapNames();
                while (object.hasMoreElements()) {
                    String string = (String)object.nextElement();
                    ((MapMessage)messageImpl).setObject(string, ((MapMessage)message).getObject(string));
                }
                break;
            }
            ++n;
        }
        if (messageImpl == null) {
            messageImpl = new MessageImpl();
        }
        messageImpl.setJMSCorrelationID(message.getJMSCorrelationID());
        messageImpl.setJMSPriority(message.getJMSPriority());
        messageImpl.setJMSType(message.getJMSType());
        object = message.getPropertyNames();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            messageImpl.setObjectProperty(string, message.getObjectProperty(string));
        }
        return messageImpl;
    }

    public void publish(Topic topic, Message message) throws JMSException {
        Trace.checkForTurnTracingOn();
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "publish");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString(1116, null));
        }
        if (topic == null) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "topic == null, JMSParameterIsNullException");
                Trace.exit(this, "publish");
            }
            String string = "MQJMS4124";
            String string2 = ConfigEnvironment.getErrorMessage(string, "Topic");
            throw new JMSParameterIsNullException(string2);
        }
        if (!(topic instanceof MQTopic)) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "Not an MQ Topic");
                Trace.exit(this, "publish");
            }
            throw new InvalidDestinationException(ExceptionBuilder.buildReasonString(1117, new Object[]{topic.getClass().toString()}));
        }
        MQTopic mQTopic = (MQTopic)topic;
        if (mQTopic.containsWildcard()) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "InvalidDestinationException");
                Trace.exit(this, "publish");
            }
            throw new InvalidDestinationException(ExceptionBuilder.buildReasonString(1118, new Object[]{topic}));
        }
        this.publish(mQTopic, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void publish(Topic topic, Message message, int n, int n2, long l) throws JMSException {
        Trace.checkForTurnTracingOn();
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "publish");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString(1116, null));
        }
        if (topic != null && topic instanceof TemporaryTopicImpl && ((TemporaryTopicImpl)topic).isDeleted()) {
            String string = "MQJMS3019";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string2, string);
        }
        if (topic == null) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "topic == null JMSParameterIsNullException");
                Trace.exit(this, "publish");
            }
            String string = "MQJMS4124";
            String string3 = ConfigEnvironment.getErrorMessage(string, "Topic");
            throw new JMSParameterIsNullException(string3);
        }
        if (!(topic instanceof MQTopic)) {
            throw new InvalidDestinationException(ExceptionBuilder.buildReasonString(1117, new Object[]{topic.getClass().toString()}));
        }
        MQTopic mQTopic = (MQTopic)topic;
        if (mQTopic.containsWildcard()) {
            throw new InvalidDestinationException(ExceptionBuilder.buildReasonString(1118, new Object[]{topic}));
        }
        MessageImpl.validateDeliveryMode(n);
        MessageImpl.validatePriority(n2);
        if (l > 0L) {
            String string = "MQJMS1010";
            String string4 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string4, string);
        }
        if (l != -1L && l < 0L) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Time to Live", String.valueOf(l));
            throw jMSException;
        }
        MessageImpl messageImpl = message instanceof MessageImpl ? (MessageImpl)message : this.createGryphonDomesticMessage(message);
        this.publishInternal(mQTopic, messageImpl, n, n2, l);
    }

    private void publishInternal(MQTopic mQTopic, MessageImpl messageImpl, int n, int n2, long l) throws JMSException {
        int n3;
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.entry(this, "publishInternal");
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "publishInternal");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString(1116, null));
        }
        if (messageImpl == null) {
            if (Trace.isOn) {
                Trace.entry(this, "publishInternal");
                Trace.trace(this, "message == null MessageFormatException");
                Trace.exit(this, "publishInternal");
            }
            String string = "MQJMS4124";
            String string2 = ConfigEnvironment.getErrorMessage(string, "Message");
            throw new MessageFormatException(string2, string);
        }
        if (messageImpl instanceof BytesMessageImpl) {
            ((BytesMessageImpl)messageImpl).prepareMessage();
        }
        messageImpl.setTopic(mQTopic);
        long l2 = mQTopic.getExpiry();
        if (l2 == -2L) {
            if (l == -1L) {
                messageImpl.setJMSExpiration(this.getTimeToLive());
            } else {
                messageImpl.setJMSExpiration(l);
            }
        } else {
            if (l2 > 0L) {
                String string = "MQJMS1010";
                String string3 = ConfigEnvironment.getErrorMessage(string);
                throw new JMSException(string3, string);
            }
            messageImpl.setJMSExpiration(l2);
        }
        int n4 = mQTopic.getPriority();
        if (n4 == -2) {
            if (n2 == -1) {
                messageImpl.setPriority(this.getPriority());
            } else {
                messageImpl.setPriority(n2);
            }
        } else if (n4 == -1) {
            messageImpl.setJMSPriority(4);
        } else {
            messageImpl.setJMSPriority(n4);
        }
        int n5 = mQTopic.getPersistence();
        if (n5 == -2) {
            if (n == -1) {
                messageImpl.setJMSDeliveryMode(this.getDeliveryMode());
            } else {
                messageImpl.setJMSDeliveryMode(n);
            }
        } else {
            MessageImpl.validateDeliveryMode(n5);
            messageImpl.setJMSDeliveryMode(n5);
        }
        Integer n6 = (Integer)messageImpl.getObjectProperty("JMS_IBM_Encoding");
        if (n6 == null) {
            n3 = mQTopic.getEncoding();
            messageImpl.setIntProperty("JMS_IBM_Encoding", n3);
        } else {
            n3 = n6;
        }
        if (messageImpl.getStringProperty("JMS_IBM_Character_Set") == null) {
            int n7 = mQTopic.getCCSID();
            String string = MQJMSMessage.getCharacterSetString(n7, n3);
            messageImpl.setStringProperty("JMS_IBM_Character_Set", string);
        }
        if (!this.getDisableMessageTimestamp()) {
            messageImpl.setJMSTimestamp(System.currentTimeMillis());
        } else {
            messageImpl.resetJMSTimestamp();
        }
        try {
            if (messageImpl instanceof BytesMessageImpl) {
                ((BytesMessageImpl)messageImpl).reset();
            }
            if (messageImpl instanceof StreamMessageImpl) {
                ((StreamMessageImpl)messageImpl).reset();
            }
            this.getSession().getConnection().send(messageImpl);
            messageImpl.messageId = null;
        }
        catch (IOException iOException) {
            if (Trace.isOn) {
                Trace.entry(this, "publishInternal");
                Trace.trace(this, "IOException - " + iOException + ".");
                Trace.exit(this, "publishInternal");
            }
            throw new JMSWrappedException(ExceptionBuilder.buildReasonString(1119, new Object[]{iOException}), iOException);
        }
    }

    public void close() throws JMSException {
        TopicSessionImpl topicSessionImpl;
        if (this.isClosed()) {
            return;
        }
        if (this.topic != null && this.topic instanceof TemporaryTopicImpl) {
            ((TemporaryTopicImpl)this.topic).decUse();
        }
        if ((topicSessionImpl = (TopicSessionImpl)this.getSession()) != null) {
            topicSessionImpl.closed(this);
        }
        this.topic = null;
        super.close();
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }
}

