/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.mq.jms.ConnectionImpl;
import com.ibm.mq.jms.SessionImpl;
import com.ibm.mq.jms.TopicSessionImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import java.io.IOException;
import java.util.Vector;
import javax.jms.ConnectionConsumer;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;

class TopicConnectionImpl
extends ConnectionImpl
implements TopicConnection,
ClientExceptionConstants {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM 5648-C60(c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/TopicConnectionImpl.java, jms, j521, j521-L020622 02/06/21 18:22:50 @(#) 1.11.1.5";
    public static final DebugObject debug = new DebugObject("TopicConnectionImpl");
    private Vector sessions;

    TopicConnectionImpl(String string, String string2, int n, String string3, String string4) throws IOException {
        super(string, string2, n, string3, string4);
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "TopicConnectionImpl", string, string2, new Integer(n), string3, "********");
        }
        this.sessions = new Vector();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "TopicConnectionImpl");
        }
    }

    public TopicSession createTopicSession(boolean bl, int n) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "createTopicSession", new Boolean(bl), new Integer(n));
        }
        if (this.isClosed()) {
            throw new IllegalStateException(ExceptionBuilder.buildReasonString(1116, null));
        }
        TopicSessionImpl topicSessionImpl = new TopicSessionImpl(this, bl, n);
        TopicConnectionImpl topicConnectionImpl = this;
        synchronized (topicConnectionImpl) {
            this.sessions.addElement(topicSessionImpl);
            if (!this.stopped) {
                topicSessionImpl.start();
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "createTopicSession", topicSessionImpl);
        }
        return topicSessionImpl;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "createConnectionConsumer", topic, string, serverSessionPool, new Integer(n));
        }
        String string2 = "MQJMS1010";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        throw new JMSException(string3, string2);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "createDurableConnectionConsumer", topic, string, serverSessionPool, new Integer(n));
        }
        String string2 = "MQJMS6311";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        throw new JMSException(string3, string2);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "createDurableConnectionConsumer", topic, string, string2, serverSessionPool, new Integer(n));
        }
        String string3 = "MQJMS6311";
        String string4 = ConfigEnvironment.getErrorMessage(string3);
        throw new JMSException(string4, string3);
    }

    public void start() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "start");
        }
        if (this.isClosed()) {
            throw new IllegalStateException(ExceptionBuilder.buildReasonString(1116, null));
        }
        TopicConnectionImpl topicConnectionImpl = this;
        synchronized (topicConnectionImpl) {
            if (!this.stopped) {
                if (debug.debugIt(64)) {
                    debug.debug(-175921860444054L, "start");
                }
                return;
            }
            Vector vector = (Vector)this.sessions.clone();
            int n = 0;
            while (n < vector.size()) {
                TopicSessionImpl topicSessionImpl = (TopicSessionImpl)vector.elementAt(n);
                topicSessionImpl.start();
                ++n;
            }
            this.stopped = false;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "start");
        }
    }

    public void stop() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "stop");
        }
        if (this.isClosed()) {
            throw new IllegalStateException(ExceptionBuilder.buildReasonString(1116, null));
        }
        TopicConnectionImpl topicConnectionImpl = this;
        synchronized (topicConnectionImpl) {
            if (this.stopped) {
                if (debug.debugIt(64)) {
                    debug.debug(-175921860444054L, "stop");
                }
                return;
            }
            Vector vector = (Vector)this.sessions.clone();
            int n = 0;
            while (n < vector.size()) {
                TopicSessionImpl topicSessionImpl = (TopicSessionImpl)vector.elementAt(n);
                topicSessionImpl.stop();
                ++n;
            }
            this.stopped = true;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "stop");
        }
    }

    public void close() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "close");
        }
        TopicConnectionImpl topicConnectionImpl = this;
        synchronized (topicConnectionImpl) {
            if (this.isClosed()) {
                if (debug.debugIt(64)) {
                    debug.debug(-175921860444054L, "close");
                }
                return;
            }
            this.deactivate();
        }
        Vector vector = (Vector)this.sessions.clone();
        int n = 0;
        while (n < vector.size()) {
            Object var6_6;
            TopicSessionImpl topicSessionImpl = (TopicSessionImpl)vector.elementAt(n);
            try {
                topicSessionImpl.close(this.eConnectionClosed, this.appConnectionClosed);
                var6_6 = null;
            }
            catch (Throwable throwable) {
                var6_6 = null;
                throw throwable;
            }
            ++n;
        }
        this.sessions.removeAllElements();
        super.close();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "close");
        }
    }

    void closed(SessionImpl sessionImpl) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "closed", sessionImpl);
        }
        Assert.condition(this.sessions.removeElement(sessionImpl));
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "closed");
        }
    }
}

