/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.SessionImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.JMSException;
import javax.jms.TemporaryTopic;

public class TemporaryTopicImpl
extends MQTopic
implements TemporaryTopic,
ClientExceptionConstants {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM 5648-C60(c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/TemporaryTopicImpl.java, jms, j521, j521-L020126 02/01/25 15:21:07 @(#) 1.10.1.1";
    private static final DebugObject debug = new DebugObject("TemporaryTopicImpl");
    private SessionImpl session;
    private int useCount = 0;
    private boolean deleted = false;

    TemporaryTopicImpl(SessionImpl sessionImpl, String string) throws JMSException {
        super(string);
        this.session = sessionImpl;
    }

    TemporaryTopicImpl(String string) throws JMSException {
        super(string);
    }

    synchronized void incUse() throws JMSException {
        if (this.deleted) {
            if (Trace.isOn) {
                Trace.entry(this, "incUse");
                Trace.trace(this, "JMS Exception - deleted");
                Trace.exit(this, "incUse");
            }
            String string = "MQJMS3019";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string2, string);
        }
        ++this.useCount;
    }

    synchronized void decUse() {
        Assert.condition(!this.deleted);
        --this.useCount;
    }

    boolean isCreatedOnThisConnection(SessionImpl sessionImpl) {
        return this.session != null && (this.session == sessionImpl || this.session.getConnection() == sessionImpl.getConnection());
    }

    boolean isDeleted() {
        return this.deleted;
    }

    public void delete() throws JMSException {
        if (this.useCount > 0) {
            if (Trace.isOn) {
                Trace.entry(this, "delete");
                Trace.trace(this, "JMS Exception - useCount > 0");
                Trace.exit(this, "delete");
            }
            String string = "MQJMS3025";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string2, string);
        }
        this.session = null;
        this.deleted = true;
    }
}

