/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSNullMessage;
import com.ibm.jms.JMSStringResources;
import com.ibm.mq.MQC;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.BrokerCommandFailedException;
import com.ibm.mq.jms.BrokerConnectionInfo;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQJMSStringResources;
import com.ibm.mq.jms.MQQueueSubscription;
import com.ibm.mq.jms.MQSubAdmin;
import com.ibm.mq.jms.MQSubEntry;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.NoBrokerResponseException;
import com.ibm.mq.jms.PCF;
import com.ibm.mq.jms.RFH;
import com.ibm.mq.jms.SubscriptionInfo;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class SubscriptionHelper {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2001, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/SubscriptionHelper.java, jms, j521, j521-L020621 02/06/20 15:36:41 @(#) 1.28.1.4";
    static final int NON_DURABLE = 0;
    static final int DURABLE = 1;
    static final int REGISTER_SUBSCRIBER = 0;
    static final int DEREGISTER_SUBSCRIBER = 1;
    static final int REGISTER_SHAREDQ_SUBSCRIBER = 2;
    static final int DEREGISTER_SHAREDQ_SUBSCRIBER = 3;
    private static final String[] CMD_PREFIX = new String[]{"MQPSCommand RegSub MQPSTopic ", "MQPSCommand DeregSub MQPSTopic ", "MQPSCommand RegSub MQPSRegOpts CorrelAsId MQPSTopic ", "MQPSCommand DeregSub MQPSRegOpts CorrelAsId MQPSTopic "};
    private static final String MQPS_STREAM_NAME_B = " MQPSStreamName ";
    private static final String MQPS_Q_NAME_B = " MQPSQName ";
    private static final String CLASSNAME = "com.ibm.mq.jms.SubscriptionHelper";
    private static final int BROKER_TIMEOUT = 120000;
    private static JMSStringResources jmsStrings = new MQJMSStringResources();

    /*
     * Loose catch block
     */
    public static Vector getBrokerSubs(String string, TopicSession topicSession) throws Exception {
        TopicSubscriber topicSubscriber;
        Throwable throwable;
        Vector vector;
        block23: {
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "getBrokerSubs");
            }
            vector = new Vector();
            String string2 = Utils.padString(string, 48);
            String string3 = "MQ/S/" + string2 + "/Subscribers/Identities";
            MQTopic mQTopic = new MQTopic();
            mQTopic.setBaseTopicName("\"" + string3 + "/*\"");
            throwable = null;
            topicSubscriber = null;
            topicSubscriber = topicSession.createSubscriber((Topic)mQTopic);
            BytesMessage bytesMessage = null;
            do {
                if ((bytesMessage = (BytesMessage)topicSubscriber.receiveNoWait()) == null) continue;
                SubscriptionHelper.interpretMetaMessage(bytesMessage, vector, string3);
            } while (bytesMessage != null);
            Object var10_10 = null;
            try {
                if (topicSubscriber != null) {
                    topicSubscriber.close();
                }
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) break block23;
                Trace.trace(CLASSNAME, "getBrokerSubs was unable to close our meta-topic subscriber due to: " + (Object)((Object)jMSException));
                if (throwable != null) {
                    Trace.trace(CLASSNAME, "Consuming the above exception and throwing the original one");
                    break block23;
                }
                throwable = jMSException;
            }
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "getBrokerSubs");
        }
        if (throwable != null) {
            throw throwable;
        }
        return vector;
        {
            catch (Exception exception) {
                block24: {
                    throwable = exception;
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Subscription or message receipt failed due to: " + exception);
                    }
                    Object var10_11 = null;
                    try {
                        if (topicSubscriber != null) {
                            topicSubscriber.close();
                        }
                    }
                    catch (JMSException jMSException) {
                        if (!Trace.isOn) break block24;
                        Trace.trace(CLASSNAME, "getBrokerSubs was unable to close our meta-topic subscriber due to: " + (Object)((Object)jMSException));
                        if (throwable != null) {
                            Trace.trace(CLASSNAME, "Consuming the above exception and throwing the original one");
                            break block24;
                        }
                        throwable = jMSException;
                    }
                }
                if (Trace.isOn) {
                    Trace.exit(CLASSNAME, "getBrokerSubs");
                }
                if (throwable != null) {
                    throw throwable;
                }
                return vector;
            }
        }
        catch (Throwable throwable2) {
            block25: {
                Object var10_12 = null;
                try {
                    if (topicSubscriber != null) {
                        topicSubscriber.close();
                    }
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) break block25;
                    Trace.trace(CLASSNAME, "getBrokerSubs was unable to close our meta-topic subscriber due to: " + (Object)((Object)jMSException));
                    if (throwable != null) {
                        Trace.trace(CLASSNAME, "Consuming the above exception and throwing the original one");
                        break block25;
                    }
                    throwable = jMSException;
                }
            }
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "getBrokerSubs");
            }
            if (throwable != null) {
                throw throwable;
            }
            return vector;
        }
    }

    public static Vector getMatchingSubs(Vector vector, SubscriptionInfo subscriptionInfo) {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "getMatchingSubs");
            Trace.trace(CLASSNAME, "objs has " + vector.size() + " elements");
            Trace.trace(CLASSNAME, "match is:\n" + subscriptionInfo);
        }
        Vector<SubscriptionInfo> vector2 = null;
        int n = 0;
        while (n < vector.size()) {
            SubscriptionInfo subscriptionInfo2 = (SubscriptionInfo)vector.elementAt(n);
            if (subscriptionInfo2.wildcardMatch(subscriptionInfo)) {
                if (vector2 == null) {
                    vector2 = new Vector<SubscriptionInfo>();
                }
                vector2.addElement(subscriptionInfo2);
            }
            ++n;
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "getMatchingSubs");
        }
        return vector2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String validateQueueName(String string, int n) throws JMSException {
        String string2;
        try {
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "validateQueueName");
            }
            String string3 = null;
            if (string.trim().equals("")) {
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "queueName is blank; reverting to MQJMSv1 approach");
                }
                string3 = n == 0 ? "SYSTEM.JMS.ND.*" : "SYSTEM.JMS.D.*";
            } else {
                if (n == 0 && !string.startsWith("SYSTEM.JMS.ND.") || n == 1 && !string.startsWith("SYSTEM.JMS.D.")) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3021", string);
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(CLASSNAME, "Create and Throwing " + (Object)((Object)jMSException));
                    throw jMSException;
                }
                string3 = string;
            }
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "validateQueueName returning '" + string3 + "'");
            }
            string2 = string3;
            Object var5_5 = null;
            if (!Trace.isOn) return string2;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLASSNAME, "validateQueueName");
            throw throwable;
        }
        Trace.exit(CLASSNAME, "validateQueueName");
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String createSubscriberQueue(MQQueueManager mQQueueManager, String string) throws JMSException {
        String string2;
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(CLASSNAME, "createSubscriberQueue");
                }
                String string3 = null;
                if (!string.endsWith("*")) {
                    throw ConfigEnvironment.newException("MQJMS3021", string);
                }
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Creating a new PERMDYN queue");
                    Trace.trace(CLASSNAME, "Model:  SYSTEM.JMS.MODEL.QUEUE");
                    Trace.trace(CLASSNAME, "Prefix: " + string);
                }
                MQQueue mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.MODEL.QUEUE", 33, null, string, null);
                string3 = mQQueue.name;
                mQQueue.close();
                string2 = string3;
                Object var6_7 = null;
                if (!Trace.isOn) return string2;
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2008");
                jMSException.setLinkedException((Exception)((Object)mQException));
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Create and Throwing " + (Object)((Object)jMSException));
                }
                Trace.trace(CLASSNAME, "Linked Exception " + (Object)((Object)mQException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLASSNAME, "createSubscriberQueue");
            throw throwable;
        }
        Trace.exit(CLASSNAME, "createSubscriberQueue");
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static MQQueue getSubscriberQueue(MQQueueManager mQQueueManager, String string) throws JMSException {
        MQQueue mQQueue;
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(CLASSNAME, "getSubscriberQueue");
                }
                MQQueue mQQueue2 = null;
                if (string.endsWith("*")) {
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Using multi-queue approach");
                        Trace.trace(CLASSNAME, "Model:  SYSTEM.JMS.MODEL.QUEUE");
                        Trace.trace(CLASSNAME, "Prefix: " + string);
                    }
                    mQQueue2 = mQQueueManager.accessQueue("SYSTEM.JMS.MODEL.QUEUE", 33, null, string, null);
                } else {
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Using shared-queue approach");
                    }
                    mQQueue2 = mQQueueManager.accessQueue(string, 33);
                }
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "QName:  " + mQQueue2.name);
                }
                mQQueue = mQQueue2;
                Object var5_6 = null;
                if (!Trace.isOn) return mQQueue;
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2008");
                jMSException.setLinkedException((Exception)((Object)mQException));
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Create and Throwing " + (Object)((Object)jMSException));
                }
                Trace.trace(CLASSNAME, "Linked Exception " + (Object)((Object)mQException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLASSNAME, "getSubscriberQueue");
            throw throwable;
        }
        Trace.exit(CLASSNAME, "getSubscriberQueue");
        return mQQueue;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static void sendBrokerCommand(MQQueueManager var0, BrokerConnectionInfo var1_1, int var2_2, String var3_3, String var4_4, byte[] var5_5, boolean var6_6, String var7_7) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry("com.ibm.mq.jms.SubscriptionHelper", "sendBrokerCommand");
            }
            var8_8 = SubscriptionHelper.CMD_PREFIX[var2_2] + var3_3 + " MQPSStreamName " + var1_1.streamQ + " MQPSQName " + var4_4;
            var9_9 = SubscriptionHelper.buildPubSubMessage(var8_8, var5_5, var6_6);
            try {
                if (var7_7 != null) {
                    var9_9.setUserId(var7_7);
                }
                var10_10 = var7_7 != null;
                SubscriptionHelper.MQPUT1(var0, var1_1.qmName, var1_1.controlQ, var9_9, var10_10);
            }
            catch (JMSException var10_11) {
                var11_13 = false;
                var12_16 = var10_11.getLinkedException();
                if (var12_16 instanceof MQException) {
                    var13_19 /* !! */  = (MQException)var12_16;
                    if (var13_19 /* !! */ .completionCode == 1 && var13_19 /* !! */ .reasonCode == 2104) {
                        var11_13 = true;
                    }
                }
                if (!var11_13) {
                    if (Trace.isOn) {
                        Trace.trace("com.ibm.mq.jms.SubscriptionHelper", "Throwing " + (Object)var10_11);
                    }
                    throw var10_11;
                }
            }
            catch (MQException var11_14) {
                var12_17 = ConfigEnvironment.newException("MQJMS0006");
                var12_17.setLinkedException((Exception)var11_14);
                if (Trace.isOn) {
                    Trace.trace("com.ibm.mq.jms.SubscriptionHelper", "Create and Throwing " + (Object)var12_17);
                }
                if (Trace.isOn) {
                    Trace.trace("com.ibm.mq.jms.SubscriptionHelper", "Linked Exception " + (Object)var11_14);
                }
                throw var12_17;
            }
            if (var6_6) {
                block28: {
                    var10_12 = new MQMsg2();
                    var11_15 = null;
                    try {
                        var11_15 = var0.accessQueue("SYSTEM.JMS.REPORT.QUEUE", 1);
                        var10_12.setCorrelationId(var9_9.getMessageId());
                        var12_16 = new MQGetMessageOptions();
                        var12_16.options = 1;
                        var12_16.waitInterval = 120000;
                        var11_15.getMsg2(var10_12, (MQGetMessageOptions)var12_16);
                        var15_20 = null;
                        ** if (var11_15 == null) goto lbl-1000
                    }
                    catch (Throwable var14_24) {
                        block29: {
                            var15_21 = null;
                            if (var11_15 != null) {
                                try {
                                    var11_15.close();
                                }
                                catch (MQException var16_23) {
                                    if (!Trace.isOn) break block29;
                                    Trace.trace("com.ibm.mq.jms.SubscriptionHelper", "sendBrokerCommand failed to close replyQ due to: " + (Object)var16_23);
                                }
                            }
                        }
                        throw var14_24;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            var11_15.close();
                        }
                        catch (MQException var16_22) {
                            if (Trace.isOn) {
                                Trace.trace("com.ibm.mq.jms.SubscriptionHelper", "sendBrokerCommand failed to close replyQ due to: " + (Object)var16_22);
                            }
                        }
                    }
lbl-1000:
                    // 4 sources

                    {
                        break block28;
                        catch (MQException var12_18) {
                            var13_19 /* !! */  = new NoBrokerResponseException("Unable to retreive report message");
                            var13_19 /* !! */ .setLinkedException((Exception)var12_18);
                            if (Trace.isOn) {
                                Trace.trace("com.ibm.mq.jms.SubscriptionHelper", "Create and Throwing " + (Object)var13_19 /* !! */ );
                            }
                            if (Trace.isOn) {
                                Trace.trace("com.ibm.mq.jms.SubscriptionHelper", "Linked Exception " + (Object)var12_18);
                            }
                            throw var13_19 /* !! */ ;
                        }
                    }
                }
                SubscriptionHelper.checkResponse(var10_12);
            }
            var18_25 = null;
            ** if (!Trace.isOn) goto lbl-1000
        }
        catch (Throwable var17_27) {
            var18_26 = null;
            if (Trace.isOn) {
                Trace.exit("com.ibm.mq.jms.SubscriptionHelper", "sendBrokerCommand");
            }
            throw var17_27;
        }
lbl-1000:
        // 1 sources

        {
            Trace.exit("com.ibm.mq.jms.SubscriptionHelper", "sendBrokerCommand");
        }
lbl-1000:
        // 2 sources

        {
        }
    }

    static void sendBrokerCommand(MQQueueManager mQQueueManager, BrokerConnectionInfo brokerConnectionInfo, int n, String string, String string2, byte[] byArray, boolean bl) throws JMSException {
        SubscriptionHelper.sendBrokerCommand(mQQueueManager, brokerConnectionInfo, n, string, string2, byArray, bl, null);
    }

    static void deleteSubscriber(MQQueueSubscription mQQueueSubscription) throws JMSException {
        String string = mQQueueSubscription.isDurable() ? mQQueueSubscription.getClientId() + ":" + mQQueueSubscription.getSubName() : "";
        MQSubEntry mQSubEntry = new MQSubEntry(string, mQQueueSubscription.getTopic(), mQQueueSubscription.getQueueName(), mQQueueSubscription.getSelector(), mQQueueSubscription.getNoLocal(), mQQueueSubscription.getStatusMgrId(), mQQueueSubscription.isSharedQueue());
        MQQueueManager mQQueueManager = mQQueueSubscription.getMQTopicSession().qm;
        BrokerConnectionInfo brokerConnectionInfo = mQQueueSubscription.getMQTopicSession().getBrk();
        MQQueue mQQueue = mQQueueSubscription.getSubscriberQueue();
        mQSubEntry.setSubscriberId(mQQueueSubscription.getCorrelationId());
        SubscriptionHelper.deleteSubscriber(mQQueueManager, brokerConnectionInfo, mQSubEntry, mQQueue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void deleteSubscriber(MQQueueManager mQQueueManager, BrokerConnectionInfo brokerConnectionInfo, MQSubEntry mQSubEntry) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "deleteSubscriber(qm,e)");
            }
            MQQueue mQQueue = SubscriptionHelper.accessQueue(mQQueueManager, mQSubEntry);
            SubscriptionHelper.deleteSubscriber(mQQueueManager, brokerConnectionInfo, mQSubEntry, mQQueue);
            Object var5_4 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLASSNAME, "deleteSubscriber(qm,e)");
            throw throwable;
        }
        Trace.exit(CLASSNAME, "deleteSubscriber(qm,e)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void deleteSubscriber(MQQueueManager mQQueueManager, BrokerConnectionInfo brokerConnectionInfo, MQSubEntry mQSubEntry, MQQueue mQQueue) throws JMSException {
        JMSException jMSException = null;
        try {
            try {
                block21: {
                    if (Trace.isOn) {
                        Trace.entry(CLASSNAME, "deleteSubscriber(qm,bci,e,q)");
                        Trace.trace(CLASSNAME, "Deregistering on '" + mQSubEntry.getQName() + "'");
                    }
                    int n = mQSubEntry.getSharedQueue() ? 3 : 1;
                    try {
                        SubscriptionHelper.sendBrokerCommand(mQQueueManager, brokerConnectionInfo, n, mQSubEntry.getTopic(), mQSubEntry.getQName(), mQSubEntry.getSubscriberId(), true);
                    }
                    catch (BrokerCommandFailedException brokerCommandFailedException) {
                        int n2 = brokerCommandFailedException.getReason();
                        switch (n2) {
                            case 3073: {
                                break;
                            }
                            case 3078: {
                                try {
                                    if (Trace.isOn) {
                                        Trace.trace(CLASSNAME, "retrying deregister with set_id_ctxt");
                                    }
                                    SubscriptionHelper.sendBrokerCommand(mQQueueManager, brokerConnectionInfo, n, mQSubEntry.getTopic(), mQSubEntry.getQName(), mQSubEntry.getSubscriberId(), true, brokerCommandFailedException.getUserId());
                                }
                                catch (JMSException jMSException2) {
                                    if (Trace.isOn) {
                                        Trace.trace(CLASSNAME, "failed with " + (Object)((Object)jMSException2));
                                        Exception exception = jMSException2.getLinkedException();
                                        if (exception != null) {
                                            Trace.trace(CLASSNAME, "linked exception " + exception);
                                        }
                                    }
                                    jMSException = jMSException2;
                                }
                                break;
                            }
                            default: {
                                jMSException = brokerCommandFailedException;
                                if (Trace.isOn) {
                                    Trace.trace(CLASSNAME, "Failed to deregister due to " + (Object)((Object)brokerCommandFailedException));
                                    break;
                                }
                            }
                        }
                    }
                    catch (JMSException jMSException3) {
                        jMSException = jMSException3;
                        if (!Trace.isOn) break block21;
                        Trace.trace(CLASSNAME, "Failed to deregister due to " + (Object)((Object)jMSException3));
                    }
                }
                SubscriptionHelper.deleteSubscriberMessages(mQSubEntry, mQQueue);
                if (jMSException != null) {
                    throw jMSException;
                }
                Object var11_13 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException4) {
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Throwing from deleteSubscriber: " + (Object)((Object)jMSException4));
                    Exception exception = jMSException4.getLinkedException();
                    if (exception != null) {
                        Trace.trace(CLASSNAME, "Linked exception: " + exception);
                    }
                }
                if (jMSException == null || jMSException4 == jMSException) throw jMSException4;
                if (!Trace.isOn) throw jMSException;
                Trace.trace(CLASSNAME, "NOTE! Throwing pending deregException instead!");
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLASSNAME, "deleteSubscriber(qm,bci,e,q)");
            throw throwable;
        }
        Trace.exit(CLASSNAME, "deleteSubscriber(qm,bci,e,q)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void deleteSubscriberMessages(MQQueueManager mQQueueManager, MQSubEntry mQSubEntry) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "deleteSubscriberMessages(qm,e)");
            }
            MQQueue mQQueue = null;
            String string = mQSubEntry.getQName();
            try {
                if (mQSubEntry.getSharedQueue()) {
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Opening queue AS_Q_DEF");
                    }
                    mQQueue = mQQueueManager.accessQueue(string, 1);
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Opened OK");
                    }
                } else {
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Opening queue EXCLUSIVE");
                    }
                    mQQueue = mQQueueManager.accessQueue(string, 4);
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Opened OK");
                    }
                }
            }
            catch (MQException mQException) {
                switch (mQException.reasonCode) {
                    case 2052: 
                    case 2085: {
                        if (!Trace.isOn) break;
                        Trace.trace(CLASSNAME, "Warning: SubQ '" + string + "' missing. Continuing though.");
                        break;
                    }
                    default: {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS3014", string);
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "Create and Throwing " + (Object)((Object)jMSException));
                        }
                        Trace.trace(CLASSNAME, "Linked Exception " + (Object)((Object)mQException));
                        throw jMSException;
                    }
                }
            }
            SubscriptionHelper.deleteSubscriberMessages(mQSubEntry, mQQueue);
            Object var7_6 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLASSNAME, "deleteSubscriberMessages(qm,e)");
            throw throwable;
        }
        Trace.exit(CLASSNAME, "deleteSubscriberMessages(qm,e)");
    }

    static void deleteSubscriberMessages(MQQueueSubscription mQQueueSubscription) throws JMSException {
        String string = mQQueueSubscription.isDurable() ? mQQueueSubscription.getClientId() + ":" + mQQueueSubscription.getSubName() : "";
        MQSubEntry mQSubEntry = new MQSubEntry(string, mQQueueSubscription.getTopic(), mQQueueSubscription.getQueueName(), mQQueueSubscription.getSelector(), mQQueueSubscription.getNoLocal(), mQQueueSubscription.getStatusMgrId(), mQQueueSubscription.isSharedQueue());
        MQQueue mQQueue = mQQueueSubscription.getSubscriberQueue();
        mQSubEntry.setSubscriberId(mQQueueSubscription.getCorrelationId());
        SubscriptionHelper.deleteSubscriberMessages(mQSubEntry, mQQueue);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void deleteSubscriberMessages(MQSubEntry var0, MQQueue var1_1) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.mq.jms.SubscriptionHelper", "deleteSubscriberMessages(e,q)");
        }
        try {
            if (!var0.getSharedQueue() && var1_1 != null) {
                try {
                    if (Trace.isOn) {
                        Trace.trace("com.ibm.mq.jms.SubscriptionHelper", "Closing & deleting non-shared queue");
                    }
                    var1_1.closeOptions = 2;
                    var1_1.close();
                    if (!Trace.isOn) ** GOTO lbl57
                    Trace.trace("com.ibm.mq.jms.SubscriptionHelper", "Close & delete completed OK");
                }
                catch (MQException var2_2) {
                    if (var1_1 != null) {
                        var1_1.closeOptions = 0;
                    }
                    var3_6 = ConfigEnvironment.newException("MQJMS3017", var0.getQName());
                    var3_6.setLinkedException((Exception)var2_2);
                    throw var3_6;
                }
            } else if (var0.getSharedQueue() && var1_1 != null) {
                try {
                    if (Trace.isOn) {
                        Trace.trace("com.ibm.mq.jms.SubscriptionHelper", "deleteSubscriberMessages(e,q) attempting shared queue message cleanup.");
                    }
                    var2_3 = new MQMessage();
                    var2_3.correlationId = var0.getSubscriberId();
                    var3_7 = new MQGetMessageOptions();
                    var3_7.options = 64;
                    var3_7.matchOptions = 2;
                    var4_10 = 0;
                    var5_11 = false;
                    while (!var5_11) {
                        try {
                            var2_3.messageId = MQC.MQMI_NONE;
                            var1_1.get(var2_3, var3_7, 1);
                            ++var4_10;
                        }
                        catch (MQException var6_12) {
                            if (var6_12.reasonCode == 2079) {
                                ++var4_10;
                                continue;
                            }
                            var5_11 = true;
                            if (!Trace.isOn) continue;
                            if (var6_12.reasonCode == 2033) {
                                Trace.trace("com.ibm.mq.jms.SubscriptionHelper", "deleteSubscriberMessages cleanup complete: 2033 reached. Removed " + var4_10 + " messages.");
                                continue;
                            }
                            Trace.trace("com.ibm.mq.jms.SubscriptionHelper", "deleteSubscriberMessages cleanup: Unexpected MQException thrown: " + (Object)var6_12);
                        }
                    }
                    var1_1.close();
                }
                catch (MQException var2_4) {
                    if (Trace.isOn) {
                        Trace.trace("com.ibm.mq.jms.SubscriptionHelper", "Caught " + (Object)var2_4);
                    }
                    var3_8 = ConfigEnvironment.newException("MQJMS3017", var0.getQName());
                    var3_8.setLinkedException((Exception)var2_4);
                    Trace.trace("com.ibm.mq.jms.SubscriptionHelper", "Create and Throwing " + (Object)var3_8);
                    throw var3_8;
                }
            }
lbl57:
            // 5 sources

            var8_13 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable var7_16) {
            var8_15 = null;
            if (!Trace.isOn) throw var7_16;
            Trace.exit("com.ibm.mq.jms.SubscriptionHelper", "deleteSubscriberMessages(e,q)");
            throw var7_16;
        }
        Trace.exit("com.ibm.mq.jms.SubscriptionHelper", "deleteSubscriberMessages(e,q)");
        {
            return;
            catch (JMSException var2_5) {
                var3_9 = (MQException)var2_5.getLinkedException();
                switch (var3_9.reasonCode) {
                    case 2052: 
                    case 2085: {
                        if (Trace.isOn) {
                            Trace.trace("com.ibm.mq.jms.SubscriptionHelper", "deleteSubscriberMessages: Warning: subscription queue " + var0.getQName() + " couldn't be found");
                        }
                        break;
                    }
                    default: {
                        throw var2_5;
                    }
                }
                var8_14 = null;
                if (!Trace.isOn) return;
                Trace.exit("com.ibm.mq.jms.SubscriptionHelper", "deleteSubscriberMessages(e,q)");
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static MQQueue createOrOpenQueue(MQQueueManager mQQueueManager, String string, boolean bl) throws MQException {
        MQQueue mQQueue;
        try {
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "createOrOpenQueue");
            }
            MQQueue mQQueue2 = null;
            int n = 34;
            mQQueue2 = string.endsWith("*") ? mQQueueManager.accessQueue("SYSTEM.JMS.MODEL.QUEUE", n, null, string, null) : mQQueueManager.accessQueue(string, n);
            mQQueue = mQQueue2;
            Object var7_6 = null;
            if (!Trace.isOn) return mQQueue;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLASSNAME, "createOrOpenQueue");
            throw throwable;
        }
        Trace.exit(CLASSNAME, "createOrOpenQueue");
        return mQQueue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static MQQueue accessQueue(MQQueueManager mQQueueManager, MQSubEntry mQSubEntry) throws JMSException {
        MQQueue mQQueue;
        try {
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "accessQueue");
            }
            MQQueue mQQueue2 = null;
            try {
                mQQueue2 = mQSubEntry.getSharedQueue() ? mQQueueManager.accessQueue(mQSubEntry.getQName(), 1) : mQQueueManager.accessQueue(mQSubEntry.getQName(), 4);
            }
            catch (MQException mQException) {
                switch (mQException.reasonCode) {
                    case 2052: 
                    case 2085: {
                        if (!Trace.isOn) break;
                        Trace.trace(CLASSNAME, "Warning: Subscription queue '" + mQSubEntry.getQName() + "' no longer exists.");
                        break;
                    }
                    default: {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "accessQueue: MQException '" + (Object)((Object)mQException) + "' caught");
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS3014");
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        throw jMSException;
                    }
                }
            }
            mQQueue = mQQueue2;
            Object var6_6 = null;
            if (!Trace.isOn) return mQQueue;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLASSNAME, "accessQueue");
            throw throwable;
        }
        Trace.exit(CLASSNAME, "accessQueue");
        return mQQueue;
    }

    static void checkResponse(MQMsg2 mQMsg2) throws BrokerCommandFailedException, JMSException {
        String string;
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "checkResponse");
        }
        if (mQMsg2 == null) {
            Trace.trace(CLASSNAME, "response is NULL");
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1074");
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Creating and Throwing " + (Object)((Object)jMSException));
                Trace.exit(CLASSNAME, "checkResponse (via Exception)");
            }
            throw jMSException;
        }
        try {
            Trace.trace(CLASSNAME, "Getting format");
            string = mQMsg2.getFormat();
            Trace.trace(CLASSNAME, "Got format: " + string);
        }
        catch (Exception exception) {
            Trace.trace(CLASSNAME, "Caught " + exception);
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1087");
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Create and Throwing " + (Object)((Object)jMSException));
                Trace.exit(CLASSNAME, "checkResponse (via Exception)");
            }
            throw jMSException;
        }
        if (string.compareTo("MQHRF   ") == 0) {
            String string2;
            int n;
            int n2;
            Trace.trace(CLASSNAME, "RFH1 header found");
            RFH rFH = null;
            try {
                rFH = new RFH(mQMsg2);
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Throwing " + (Object)((Object)jMSException));
                    Trace.exit(CLASSNAME, "checkResponse (via Exception)");
                }
                throw jMSException;
            }
            try {
                Trace.trace(CLASSNAME, "Parse MQPSCompCode");
                n2 = Integer.parseInt(rFH.getValue("MQPSCompCode"));
                Trace.trace(CLASSNAME, "Parse MQPSReason");
                n = Integer.parseInt(rFH.getValue("MQPSReason"));
                Trace.trace(CLASSNAME, "Parse MQPSReasonText");
                string2 = rFH.getValue("MQPSReasonText");
                Trace.trace(CLASSNAME, "Parse Complete");
            }
            catch (Exception exception) {
                Trace.trace(CLASSNAME, "Caught " + exception);
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1087");
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Create and Throwing " + (Object)((Object)jMSException));
                    Trace.exit(CLASSNAME, "checkResponse (via Exception)");
                }
                throw jMSException;
            }
            if (n2 == 2) {
                BrokerCommandFailedException brokerCommandFailedException = new BrokerCommandFailedException("Broker command failed: " + string2 + " Reason code " + n);
                brokerCommandFailedException.setReason(n);
                switch (n) {
                    case 3078: {
                        String string3 = rFH.getValue("MQPSUserId");
                        brokerCommandFailedException.setUserId(string3);
                    }
                }
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Creating and Throwing " + (Object)((Object)brokerCommandFailedException));
                    Trace.exit(CLASSNAME, "checkResponse (via Exception)");
                }
                throw brokerCommandFailedException;
            }
        } else {
            Trace.trace(CLASSNAME, "RFH2 header found");
            try {
                mQMsg2.skipReadingBytes(40);
                byte[] byArray = new byte[1024];
                mQMsg2.read(byArray);
                String string4 = new String(byArray);
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Response NameValue string is " + string4);
                }
                if (!string4.startsWith("<pscr><Completion>")) {
                    Trace.trace(CLASSNAME, "nameValueString does not start with <pscr><Completion>");
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1087");
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Create and Throwing " + (Object)((Object)jMSException));
                        Trace.exit(CLASSNAME, "checkResponse (via Exception)");
                    }
                    throw jMSException;
                }
                Trace.trace(CLASSNAME, "nameValueString DID start with <pscr><Completion>");
                Trace.trace(CLASSNAME, "Extract the completion value");
                String string5 = string4.substring(string4.indexOf("<Completion>") + 12, string4.indexOf("</Completion>"));
                if (string5.compareTo("ok") != 0) {
                    Trace.trace(CLASSNAME, "Extract the reason value");
                    String string6 = string4.substring(string4.indexOf("<Reason>") + 8, string4.indexOf("</Reason>"));
                    Trace.trace(CLASSNAME, "Extract numeric reason code");
                    int n = Integer.valueOf(string6);
                    Trace.trace(CLASSNAME, "Numeric reason code expected");
                    BrokerCommandFailedException brokerCommandFailedException = new BrokerCommandFailedException("Broker command failed: Reason code " + n);
                    brokerCommandFailedException.setReason(n);
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Creating and Throwing " + (Object)((Object)brokerCommandFailedException));
                        Trace.exit(CLASSNAME, "checkResponse (via Exception)");
                    }
                    throw brokerCommandFailedException;
                }
            }
            catch (Exception exception) {
                Trace.trace(CLASSNAME, "Caught exception: " + exception);
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1087");
                if (Trace.isOn) {
                    Trace.exception(CLASSNAME, "checkResponse", (Throwable)jMSException);
                    Trace.exit(CLASSNAME, "checkResponse (via Exception)");
                }
                throw jMSException;
            }
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "checkResponse");
        }
    }

    static void MQPUT1(MQQueueManager mQQueueManager, String string, String string2, MQJMSMessage mQJMSMessage, boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "MQPUT1");
            Trace.trace(CLASSNAME, "About to perform an MQPUT1. Params follow:");
            Trace.trace(CLASSNAME, "   QueueManager:       '" + mQQueueManager.name + "'");
            Trace.trace(CLASSNAME, "   BrokerQueueManager: '" + string + "'");
            Trace.trace(CLASSNAME, "   Queue:              '" + string2 + "'");
            Trace.trace(CLASSNAME, "   Message:            '" + ((Object)((Object)mQJMSMessage)).toString() + "'");
        }
        MQQueue mQQueue = null;
        try {
            int n = 16;
            if (bl) {
                n |= 0x400;
            }
            mQQueue = mQQueueManager.accessQueue(string2, n, string, null, null);
        }
        catch (MQException mQException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS2008");
            jMSException.setLinkedException((Exception)((Object)mQException));
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Failed to access broker queue due to: " + (Object)((Object)mQException));
                Trace.trace(CLASSNAME, "Create and Throwing " + (Object)((Object)jMSException));
                Trace.exit(CLASSNAME, "MQPUT1 (via Exception)");
            }
            throw jMSException;
        }
        try {
            MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions();
            if (bl) {
                mQPutMessageOptions.options |= 0x400;
            }
            mQQueue.putMsg2((MQMsg2)mQJMSMessage, mQPutMessageOptions);
        }
        catch (MQException mQException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3011");
            jMSException.setLinkedException((Exception)((Object)mQException));
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Failed to MQPUT broker command due to: " + (Object)((Object)mQException));
                Trace.trace(CLASSNAME, "Creating and Throwing " + (Object)((Object)jMSException));
                Trace.exit(CLASSNAME, "MQPUT1 (via Exception)");
            }
            throw jMSException;
        }
        try {
            mQQueue.close();
        }
        catch (MQException mQException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS2000");
            jMSException.setLinkedException((Exception)((Object)mQException));
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Failed to close broker command due to: " + (Object)((Object)mQException));
                Trace.trace(CLASSNAME, "Creating and Throwing " + (Object)((Object)jMSException));
                Trace.exit(CLASSNAME, "MQPUT1 (via Exception)");
            }
            throw jMSException;
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "MQPUT1");
        }
    }

    static void MQPUT1(MQQueueManager mQQueueManager, String string, String string2, MQJMSMessage mQJMSMessage) throws JMSException {
        SubscriptionHelper.MQPUT1(mQQueueManager, string, string2, mQJMSMessage, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void unsubscribe(MQQueueManager mQQueueManager, BrokerConnectionInfo brokerConnectionInfo, String string, MQSubAdmin mQSubAdmin) throws JMSException {
        try {
            try {
                MQSubEntry mQSubEntry;
                if (Trace.isOn) {
                    Trace.entry(CLASSNAME, "unsubscribe");
                }
                if ((mQSubEntry = mQSubAdmin.getResolved(mQQueueManager, brokerConnectionInfo, string, null, false)) == null) {
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "No entry found for '" + string + "'");
                    }
                    String string2 = "MQJMS3018";
                    String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
                    throw invalidDestinationException;
                }
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Entry found for '" + string + "'");
                    Trace.trace(CLASSNAME, mQSubEntry.toString());
                }
                MQQueue mQQueue = null;
                try {
                    mQQueue = mQSubAdmin.checkInactive(mQQueueManager, mQSubEntry);
                }
                catch (JMSException jMSException) {
                    MQException mQException = (MQException)((Object)jMSException.getLinkedException());
                    switch (mQException.reasonCode) {
                        case 2052: 
                        case 2085: {
                            if (!Trace.isOn) break;
                            Trace.trace(CLASSNAME, "Warning: durable sub queue '" + mQSubEntry.getQName() + " is missing\n");
                            Trace.trace(CLASSNAME, "Carrying on with deregister");
                            break;
                        }
                        default: {
                            throw jMSException;
                        }
                    }
                }
                mQSubEntry.setSubscriberState('t');
                mQSubAdmin.add(mQSubEntry, false);
                SubscriptionHelper.deleteSubscriber(mQQueueManager, brokerConnectionInfo, mQSubEntry, mQQueue);
                MQSubEntry mQSubEntry2 = mQSubAdmin.remove(mQSubEntry);
                if (mQSubEntry2 == null) {
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "unsubscribe problem - failed to remove the admin entry");
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3013");
                    throw jMSException;
                }
                MQSubEntry mQSubEntry3 = mQSubAdmin.remove(mQSubEntry);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(CLASSNAME, "unsubscribe throwing: " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(CLASSNAME, "linked exception: " + exception);
                throw jMSException;
            }
            Object var9_16 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var9_17 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLASSNAME, "unsubscribe");
            throw throwable;
        }
        Trace.exit(CLASSNAME, "unsubscribe");
    }

    private static MQJMSMessage buildPubSubMessage(String string, byte[] byArray, boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "buildPubSubMessage");
            Trace.trace(CLASSNAME, "  directive: '" + string + "'");
            Trace.trace(CLASSNAME, "  correlId:  '" + Utils.bytesToHex(byArray) + "'");
            Trace.trace(CLASSNAME, "  report:    '" + (bl ? "true" : "false") + "'");
        }
        try {
            MQJMSMessage mQJMSMessage = new MQJMSMessage();
            JMSNullMessage jMSNullMessage = new JMSNullMessage(jmsStrings);
            jMSNullMessage.setJMSDeliveryMode(2);
            mQJMSMessage.writeRFH(string, jMSNullMessage, false, 0);
            mQJMSMessage.setFormat("MQHRF   ");
            mQJMSMessage.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
            if (bl) {
                mQJMSMessage.setReport(3);
            }
            if (byArray != null) {
                mQJMSMessage.setCorrelationId(byArray);
            }
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "buildPubSubMessage");
            }
            return mQJMSMessage;
        }
        catch (Exception exception) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3008");
            jMSException.setLinkedException(exception);
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Unable to build p/s command message: " + exception);
                Trace.trace(CLASSNAME, "Creating and Throwing " + (Object)((Object)jMSException));
                Trace.exit(CLASSNAME, "buildPubSubMessage (via Exception)");
            }
            throw jMSException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void interpretMetaMessage(BytesMessage bytesMessage, Vector vector, String string) throws Exception {
        block13: {
            block12: {
                if (Trace.isOn) {
                    Trace.entry(CLASSNAME, "interpretMetaMessage");
                    Trace.trace(CLASSNAME, "Incoming message: " + bytesMessage);
                }
                try {
                    try {
                        String string2 = null;
                        String string3 = null;
                        String string4 = null;
                        String string5 = null;
                        String string6 = null;
                        String string7 = null;
                        PCF pCF = new PCF(bytesMessage);
                        int n = pCF.getParameterCount();
                        int n2 = 0;
                        while (n2 < n) {
                            block16: {
                                int n3;
                                block14: {
                                    String string8;
                                    int n4;
                                    block19: {
                                        block18: {
                                            block17: {
                                                block15: {
                                                    n3 = pCF.getParameterType(n2);
                                                    if (n3 != 4) break block14;
                                                    PCF.MQCFST mQCFST = (PCF.MQCFST)pCF.getParameterAt(n2);
                                                    n4 = mQCFST.paramId;
                                                    string8 = mQCFST.value;
                                                    if (n4 != 3031) break block15;
                                                    if (string8.startsWith(string)) {
                                                        string8 = string8.substring(string.length() + 1);
                                                    }
                                                    if (string8.startsWith(string)) {
                                                        Object var18_18 = null;
                                                        if (!Trace.isOn) return;
                                                        break block12;
                                                    }
                                                    string2 = string8;
                                                    break block16;
                                                }
                                                if (n4 == 3034) break block16;
                                                if (n4 != 3039) break block17;
                                                string6 = string8;
                                                break block16;
                                            }
                                            if (n4 != 3042) break block18;
                                            string3 = string8;
                                            break block16;
                                        }
                                        if (n4 != 3043) break block19;
                                        string4 = string8;
                                        break block16;
                                    }
                                    if (n4 == 3044) {
                                        string5 = string8;
                                        break block16;
                                    } else if (n4 == 3038) {
                                        string7 = string8;
                                        SubscriptionInfo subscriptionInfo = new SubscriptionInfo(string3, string4, string2, string5, string6, string7);
                                        vector.addElement(subscriptionInfo);
                                        string7 = null;
                                        string6 = null;
                                        string5 = null;
                                        string4 = null;
                                        string3 = null;
                                    }
                                    break block16;
                                }
                                if (n3 != 3) throw new Exception("Unknown paramType in broker PCF response: " + n3);
                            }
                            ++n2;
                        }
                        break block13;
                    }
                    catch (Exception exception) {
                        if (!Trace.isOn) throw exception;
                        Trace.trace(CLASSNAME, "Exception caught in interpretMetaMessage: " + exception);
                        throw exception;
                    }
                }
                catch (Throwable throwable) {
                    Object var18_20 = null;
                    if (!Trace.isOn) throw throwable;
                    Trace.exit(CLASSNAME, "interpretMetaMessage");
                    throw throwable;
                }
            }
            Trace.exit(CLASSNAME, "interpretMetaMessage");
            return;
        }
        Object var18_19 = null;
        if (!Trace.isOn) return;
        Trace.exit(CLASSNAME, "interpretMetaMessage");
    }
}

