/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.mq.jms.BytesMessageImpl;
import com.ibm.mq.jms.ConnectionImpl;
import com.ibm.mq.jms.JMSInvalidParameterException;
import com.ibm.mq.jms.JMSNotActiveException;
import com.ibm.mq.jms.JMSNotSupportedException;
import com.ibm.mq.jms.MapMessageImpl;
import com.ibm.mq.jms.MessageConsumerImpl;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.MessageQueue;
import com.ibm.mq.jms.ObjectMessageImpl;
import com.ibm.mq.jms.SessionConfig;
import com.ibm.mq.jms.SessionDispatcher;
import com.ibm.mq.jms.StreamMessageImpl;
import com.ibm.mq.jms.TextMessageImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import java.io.Serializable;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public abstract class SessionImpl
implements Session,
ClientLogConstants,
ClientExceptionConstants {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM 5648-C60(c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/SessionImpl.java, jms, j521, j521-L020622 02/06/21 18:22:45 @(#) 1.11.1.7";
    private static final DebugObject debug = new DebugObject("SessionImpl");
    private boolean active = true;
    private boolean stopped = true;
    private boolean transacted;
    private int acknowledgeMode;
    private ConnectionImpl parentConnection;
    private MessageListener listener;
    private MessageQueue dispatchQueue;
    private static MessageQueue s_dispatchQueue;
    private SessionDispatcher dispatcher;
    private static SessionDispatcher s_dispatcher;
    private static boolean threadPoolChecked;
    protected Vector consumers;
    protected Vector producers;

    private static synchronized void checkForThreadPooling() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "StreamMessageImpl.checkForThreadPooling");
        }
        if (!threadPoolChecked) {
            threadPoolChecked = true;
            if (SessionConfig.MAX_CLIENT_READ_THREADS > 0) {
                s_dispatchQueue = new MessageQueue(SessionConfig.MAX_MESSAGE_QUEUE_SIZE);
                s_dispatcher = new SessionDispatcher(s_dispatchQueue);
                ConnectionImpl.threadProvider.schedule(s_dispatcher);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "CheckForThreadPooling");
        }
    }

    SessionImpl(ConnectionImpl connectionImpl, boolean bl, int n) throws JMSInvalidParameterException, JMSNotSupportedException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "SessionImpl", connectionImpl, new Boolean(bl), new Integer(n));
        }
        if (bl) {
            String string = "MQJMS6311";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSNotSupportedException(string2);
        }
        this.transacted = bl;
        this.setAcknowledgeMode(n);
        this.parentConnection = connectionImpl;
        SessionImpl.checkForThreadPooling();
        if (s_dispatchQueue != null) {
            this.dispatchQueue = s_dispatchQueue;
            this.dispatcher = s_dispatcher;
        } else {
            this.dispatchQueue = new MessageQueue(SessionConfig.MAX_MESSAGE_QUEUE_SIZE);
            this.dispatcher = new SessionDispatcher(this.dispatchQueue);
            ConnectionImpl.threadProvider.schedule(this.dispatcher);
        }
        this.consumers = new Vector();
        this.producers = new Vector();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "SessionImpl");
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "createBytesMessage");
        }
        BytesMessageImpl bytesMessageImpl = new BytesMessageImpl();
        bytesMessageImpl.setSession(this);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "createBytesMessage", bytesMessageImpl);
        }
        return bytesMessageImpl;
    }

    public MapMessage createMapMessage() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "createMapMessage");
        }
        MapMessageImpl mapMessageImpl = new MapMessageImpl();
        mapMessageImpl.setSession(this);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "createMapMessage", mapMessageImpl);
        }
        return mapMessageImpl;
    }

    public Message createMessage() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "createMessage");
        }
        MessageImpl messageImpl = new MessageImpl();
        messageImpl.setSession(this);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "createMessage", messageImpl);
        }
        return messageImpl;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "createObjectMessage");
        }
        ObjectMessageImpl objectMessageImpl = new ObjectMessageImpl();
        objectMessageImpl.setSession(this);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "createObjectMessage", objectMessageImpl);
        }
        return objectMessageImpl;
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "createObjectMessage", serializable);
        }
        ObjectMessageImpl objectMessageImpl = new ObjectMessageImpl();
        objectMessageImpl.setSession(this);
        objectMessageImpl.setObject(serializable);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "createObjectMessage", objectMessageImpl);
        }
        return objectMessageImpl;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "createStreamMessage");
        }
        StreamMessageImpl streamMessageImpl = new StreamMessageImpl();
        streamMessageImpl.setSession(this);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "createStreamMessage", streamMessageImpl);
        }
        return streamMessageImpl;
    }

    public TextMessage createTextMessage() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "createTextMessage");
        }
        TextMessageImpl textMessageImpl = new TextMessageImpl();
        textMessageImpl.setSession(this);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "createTextMessage", textMessageImpl);
        }
        return textMessageImpl;
    }

    public TextMessage createTextMessage(StringBuffer stringBuffer) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "createTextMessage", stringBuffer);
        }
        TextMessage textMessage = this.createTextMessage(stringBuffer.toString());
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "createTextMessage", textMessage);
        }
        return textMessage;
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "createTextMessage", string);
        }
        TextMessageImpl textMessageImpl = new TextMessageImpl();
        textMessageImpl.setSession(this);
        textMessageImpl.setText(string);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "createTextMessage", textMessageImpl);
        }
        return textMessageImpl;
    }

    public boolean getTransacted() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getTransacted");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getTransacted", new Boolean(this.transacted));
        }
        return this.transacted;
    }

    public void commit() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "commit");
        }
        if (this.isClosed()) {
            String string = "MQJMS1024";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSNotActiveException(string2);
        }
        String string = "MQJMS6311";
        String string3 = ConfigEnvironment.getErrorMessage(string);
        throw new JMSException(string3, string);
    }

    public void rollback() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "rollback");
        }
        if (this.isClosed()) {
            String string = "MQJMS1024";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSNotActiveException(string2);
        }
        String string = "MQJMS1010";
        String string3 = ConfigEnvironment.getErrorMessage(string);
        throw new JMSException(string3, string);
    }

    public void close() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "close");
        }
        this.close(null, true);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "close");
        }
    }

    public void close(Exception exception, boolean bl) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "close", exception, new Boolean(bl));
        }
        if (this.isClosed()) {
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "close");
            }
            return;
        }
        this.active = false;
        this.parentConnection.closed(this);
        this.stop();
        if (s_dispatcher == null && this.dispatcher != null) {
            this.dispatcher.close(exception, bl);
        }
        this.dispatcher = null;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "close");
        }
    }

    public void recover() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "recover");
        }
        if (this.isClosed()) {
            String string = "MQJMS1024";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSNotActiveException(string2);
        }
        String string = "MQJMS1010";
        String string3 = ConfigEnvironment.getErrorMessage(string);
        throw new JMSException(string3, string);
    }

    public MessageListener getMessageListener() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getMessageListener");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getMessageListener", this.listener);
        }
        return this.listener;
    }

    public void setMessageListener(MessageListener messageListener) throws JMSNotActiveException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setMessageListener", messageListener);
        }
        if (this.isClosed()) {
            String string = "MQJMS1024";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSNotActiveException(string2);
        }
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            MessageListener messageListener2 = this.listener;
            this.listener = messageListener;
            if (messageListener2 == messageListener) {
                if (debug.debugIt(64)) {
                    debug.debug(-175921860444054L, "setMessageListener");
                }
                return;
            }
            boolean bl = this.stopped;
            if (!bl) {
                this.stop();
            }
            Vector vector = (Vector)this.consumers.clone();
            int n = 0;
            while (n < vector.size()) {
                MessageConsumerImpl messageConsumerImpl = (MessageConsumerImpl)vector.elementAt(n);
                messageConsumerImpl.setSessionMessageListener(messageListener);
                ++n;
            }
            if (!bl) {
                this.start();
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setMessageListener");
        }
    }

    public void run() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "run");
        }
        throw new IllegalStateException(ExceptionBuilder.buildReasonString(1109, null));
    }

    ConnectionImpl getConnection() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getConnection");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getConnection", this.parentConnection);
        }
        return this.parentConnection;
    }

    MessageQueue getDispatchQueue() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getDispatchQueue");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getDispatchQueue", this.dispatchQueue);
        }
        return this.dispatchQueue;
    }

    private void setAcknowledgeMode(int n) throws JMSInvalidParameterException, JMSNotSupportedException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setAcknowledgeMode", new Integer(n));
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                this.acknowledgeMode = n;
                break;
            }
            default: {
                String string = "MQJMS1001";
                String string2 = ConfigEnvironment.getErrorMessage(string, String.valueOf(n));
                throw new JMSInvalidParameterException(string2);
            }
        }
        if (this.acknowledgeMode == 2) {
            String string = "MQJMS1010";
            String string3 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSNotSupportedException(string3);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setAcknowledgeMode");
        }
    }

    public int getAcknowledgeMode() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getAcknowledgeMode");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getAcknowledgeMode", new Integer(this.acknowledgeMode));
        }
        return this.acknowledgeMode;
    }

    boolean acknowledgeModeIsAuto() {
        boolean bl;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "acknowledgeModeIsAuto");
        }
        boolean bl2 = bl = 1 == this.acknowledgeMode;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "acknowledgeModeIsAuto", new Boolean(bl));
        }
        return bl;
    }

    boolean acknowledgeModeIsClient() {
        boolean bl;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "acknowledgeModeIsClient");
        }
        boolean bl2 = bl = 2 == this.acknowledgeMode;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "acknowledgeModeIsClient", new Boolean(bl));
        }
        return bl;
    }

    boolean acknowledgeModeIsDupsOK() {
        boolean bl;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "acknowledgeModeIsDupsOK");
        }
        boolean bl2 = bl = 3 == this.acknowledgeMode;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "acknowledgeModeIsDupsOK", new Boolean(bl));
        }
        return bl;
    }

    void enqueue(MessageImpl messageImpl) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "enqueue", messageImpl);
        }
        this.dispatchQueue.enqueue(messageImpl);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "enqueue");
        }
    }

    protected boolean isActive() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "isActive");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "isActive", new Boolean(this.active));
        }
        return this.active;
    }

    protected boolean isClosed() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "isClosed");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "isClosed", new Boolean(!this.active));
        }
        return !this.active;
    }

    protected boolean isStopped() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "isStopped");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "isStopped", new Boolean(this.stopped));
        }
        return this.stopped;
    }

    synchronized void stop() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "stop");
        }
        this.stopped = true;
        this.dispatcher.stop();
        Vector vector = (Vector)this.consumers.clone();
        int n = 0;
        while (n < vector.size()) {
            ((MessageConsumerImpl)vector.elementAt(n)).stop();
            ++n;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "stop");
        }
    }

    synchronized void start() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "start");
        }
        this.stopped = false;
        this.dispatcher.start();
        Vector vector = (Vector)this.consumers.clone();
        int n = 0;
        while (n < vector.size()) {
            ((MessageConsumerImpl)vector.elementAt(n)).start();
            ++n;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "start");
        }
    }
}

