/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.mq.jms.JMSWrappedException;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.MessageQueue;
import com.ibm.mq.jms.SessionImpl;

public class SessionDispatcher
implements Runnable,
ClientLogConstants {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM 5648-C60(c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/SessionDispatcher.java, jms, j521, j521-L020523 02/05/22 18:33:30 @(#) 1.6.1.2";
    private static final DebugObject debug = new DebugObject("SessionDispatcher");
    private SessionImpl session;
    private MessageQueue messageQueue;
    private volatile boolean alive = true;
    private boolean stopped = true;
    private Thread dispatchThread = null;

    SessionDispatcher(MessageQueue messageQueue) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "SessionDispatcher", messageQueue);
        }
        this.messageQueue = messageQueue;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "SessionDispatcher");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "run");
        }
        while (this.alive) {
            try {
                SessionDispatcher sessionDispatcher;
                Object var9_9;
                Object var1_1 = null;
                MessageImpl messageImpl = null;
                boolean bl = false;
                MessageQueue messageQueue = this.messageQueue;
                synchronized (messageQueue) {
                    messageImpl = this.messageQueue.dequeue();
                    if (messageImpl == null) {
                        break;
                    }
                    SessionDispatcher sessionDispatcher2 = this;
                    synchronized (sessionDispatcher2) {
                        this.dispatchThread = Thread.currentThread();
                    }
                }
                try {
                    try {
                        messageImpl.dispatch();
                    }
                    catch (RuntimeException runtimeException) {
                        System.out.println("Disthub caught a RuntimeException from MessageListener.onMessage() -- ignored");
                        runtimeException.printStackTrace();
                        var9_9 = null;
                        sessionDispatcher = this;
                        synchronized (sessionDispatcher) {
                            this.dispatchThread = null;
                            this.notifyAll();
                            continue;
                        }
                    }
                    var9_9 = null;
                    sessionDispatcher = this;
                }
                catch (Throwable throwable) {
                    var9_9 = null;
                    sessionDispatcher = this;
                    synchronized (sessionDispatcher) {
                        this.dispatchThread = null;
                        this.notifyAll();
                        throw throwable;
                    }
                }
                synchronized (sessionDispatcher) {
                    this.dispatchThread = null;
                    this.notifyAll();
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (JMSWrappedException jMSWrappedException) {}
            break;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "run");
        }
    }

    public void close(Exception exception, boolean bl) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "close", exception, new Boolean(bl));
        }
        this.alive = false;
        if (this.messageQueue != null) {
            this.messageQueue.close(exception, bl);
        }
        this.messageQueue = null;
        this.session = null;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "close");
        }
    }

    synchronized void stop() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "stop");
        }
        this.stopped = true;
        this.messageQueue.stop();
        while (this.dispatchThread != null && this.dispatchThread != Thread.currentThread()) {
            try {
                System.out.println("waiting...");
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "stop");
        }
    }

    synchronized void start() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "start");
        }
        this.stopped = false;
        this.messageQueue.start();
        this.notifyAll();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "start");
        }
    }
}

