/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.client.BaseConfig;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.impl.util.FeatureSet;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.mq.jms.services.ConfigEnvironment;
import java.applet.Applet;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Properties;

public class SessionConfig
extends BaseConfig
implements ClientLogConstants,
ClientExceptionConstants {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM 5648-C60(c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/SessionConfig.java, jms, j521, j521-L020515 02/05/14 14:57:59 @(#) 1.9.1.2";
    public static String[] parameters;
    public static String[] undocParameters;
    public static final int RELEASE_VERSION = 65537;
    public static final String SUBTOPIC_MATCHMANY = "#";
    public static final String SUBTOPIC_MATCHONE = "+";
    public static final char SUBTOPIC_SEPARATOR_CHAR = '/';
    public static final char SUBTOPIC_MATCHMANY_CHAR = '#';
    public static final char SUBTOPIC_MATCHONE_CHAR = '+';
    private static final String CTLMSG_SERVERTOSERVER_COMP = "SERVER";
    private static final String CTLMSG_QOP_COMP = "QOP";
    private static final String CTLMSG_SERVERTOSERVER_PREFIX = "\u0001ISYS/SERVER/";
    public static final String CTLMSG_QOP_PREFIX = "\u0001ISYS/QOP/";
    public static final String DEFAULT_ADMIN_TOPIC_PREFIX = "Gryphon/Admin/";
    public static String SSL_CLASS;
    public static String SSL_CIPHER_SUITES;
    public static String SSL_KEYRING_FILE;
    public static String SSL_PASSPHRASE_FILE;
    public static int MAX_CLIENT_READ_THREADS;
    public static int CLIENT_THREAD_POLLING_INTERVAL;
    public static int MY_BROKER_PORT;
    public static int CLIENT_PING_INTERVAL;
    public static int PING_TIMEOUT_MULTIPLE;
    public static int PING_MIN;
    public static String HTTP_PROXY;
    public static int HTTP_PROXY_PORT;
    public static int MAX_MESSAGE_QUEUE_SIZE;
    public static boolean ENABLE_SOCKS;
    public static final byte REPLY_TOPIC_QOP = 14;
    public static int LOG_MAX_QUEUE;
    public static int MATCH_CACHE_INITIAL_CAPACITY;
    static /* synthetic */ Class class$com$ibm$mq$jms$SessionConfig;

    protected SessionConfig() {
    }

    public static final String getClientToServerControlMessageTopic() {
        return "\u0001ISYS/CLIENT/";
    }

    public static final String getServerToServerControlMessageTopic(String string) {
        return CTLMSG_SERVERTOSERVER_PREFIX + string;
    }

    public static long checkConsistency() {
        if (MAX_CLIENT_READ_THREADS < 0 || CLIENT_THREAD_POLLING_INTERVAL <= 0 && MAX_CLIENT_READ_THREADS != 0) {
            return 18049582881575817L;
        }
        if (CLIENT_PING_INTERVAL > 0) {
            if (PING_TIMEOUT_MULTIPLE <= 0) {
                return 18049582881575818L;
            }
            if (PING_MIN <= 0) {
                return 18049582881575819L;
            }
        }
        if (BaseConfig.EXPECTED_MESSAGE_SIZE <= 0) {
            return 18049582881575820L;
        }
        if (BaseConfig.MAX_MESSAGE_SIZE <= 0) {
            return 18049582881575821L;
        }
        if (BaseConfig.MESSAGE_SIZE_EXTRA_ALLOWANCE < 0) {
            return 18049582881575822L;
        }
        return 0L;
    }

    public static synchronized void initialize() {
        BaseConfig.initialize(class$com$ibm$mq$jms$SessionConfig == null ? (class$com$ibm$mq$jms$SessionConfig = SessionConfig.class$("com.ibm.mq.jms.SessionConfig")) : class$com$ibm$mq$jms$SessionConfig);
        long l = SessionConfig.checkConsistency();
        if (l != 0L) {
            String string = "MQJMS4112";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new IllegalArgumentException(string2);
        }
    }

    public static synchronized void initialize(Properties properties2) {
        String string;
        Assert.condition(!BaseConfig.initClient && !BaseConfig.initServer);
        Assert.condition(!BaseConfig.noMoreChanges);
        BaseConfig.initServer = true;
        String string2 = null;
        String string3 = null;
        try {
            int n = 0;
            while (n < parameters.length) {
                string2 = parameters[n];
                string3 = properties2.getProperty(string2);
                if (string3 != null) {
                    BaseConfig.setParameter(class$com$ibm$mq$jms$SessionConfig == null ? SessionConfig.class$("com.ibm.mq.jms.SessionConfig") : class$com$ibm$mq$jms$SessionConfig, string2, string3);
                    ((Hashtable)properties2).remove(string2);
                }
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(ExceptionBuilder.buildReasonString(1106, new Object[]{string2, numberFormatException}));
        }
        try {
            Properties properties3 = null;
            Properties properties4 = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return System.getProperties();
                    }
                    catch (AccessControlException accessControlException) {
                        return "";
                    }
                }
            });
            string = properties4.getProperty("DistHub.Config");
            if (string != null) {
                properties3 = new Properties();
                try {
                    FileInputStream fileInputStream = new FileInputStream(string);
                    properties3.load(fileInputStream);
                }
                catch (IOException iOException) {
                    System.err.println("Warning: could not read configuration file " + string);
                    properties3 = null;
                }
            }
            int n = 0;
            while (n < parameters.length) {
                string2 = parameters[n];
                string3 = properties4.getProperty("DistHub.Parameter." + string2);
                if (string3 == null && properties3 != null) {
                    string3 = properties3.getProperty(string2);
                }
                if (string3 != null) {
                    BaseConfig.setParameter(class$com$ibm$mq$jms$SessionConfig == null ? SessionConfig.class$("com.ibm.mq.jms.SessionConfig") : class$com$ibm$mq$jms$SessionConfig, string2, string3);
                }
                ++n;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        long l = SessionConfig.checkConsistency();
        if (l != 0L) {
            string = "MQJMS4112";
            String string4 = ConfigEnvironment.getErrorMessage(string);
            throw new IllegalArgumentException(string4);
        }
    }

    public static synchronized void setParameters(Applet applet) {
        if (BaseConfig.noMoreChanges) {
            throw new IllegalStateException(ExceptionBuilder.buildReasonString(1105, null));
        }
        int n = 0;
        while (n < parameters.length) {
            String string = parameters[n];
            String string2 = applet.getParameter("DistHub.Parameter." + string);
            if (string2 != null) {
                BaseConfig.setParameter(class$com$ibm$mq$jms$SessionConfig == null ? SessionConfig.class$("com.ibm.mq.jms.SessionConfig") : class$com$ibm$mq$jms$SessionConfig, string, string2);
            }
            ++n;
        }
        long l = SessionConfig.checkConsistency();
        if (l != 0L) {
            String string = "MQJMS4112";
            String string3 = ConfigEnvironment.getErrorMessage(string);
            throw new IllegalArgumentException(string3);
        }
    }

    public static synchronized void setParameter(String string, String string2) throws IllegalArgumentException, IllegalStateException {
        BaseConfig.setParameter(class$com$ibm$mq$jms$SessionConfig == null ? (class$com$ibm$mq$jms$SessionConfig = SessionConfig.class$("com.ibm.mq.jms.SessionConfig")) : class$com$ibm$mq$jms$SessionConfig, string, string2);
        long l = SessionConfig.checkConsistency();
        if (l != 0L) {
            String string3 = "MQJMS4112";
            String string4 = ConfigEnvironment.getErrorMessage(string3);
            throw new IllegalArgumentException(string4);
        }
    }

    public static synchronized void setParameter(Properties properties2) throws IllegalArgumentException, IllegalStateException {
        BaseConfig.setParameter(class$com$ibm$mq$jms$SessionConfig == null ? (class$com$ibm$mq$jms$SessionConfig = SessionConfig.class$("com.ibm.mq.jms.SessionConfig")) : class$com$ibm$mq$jms$SessionConfig, properties2);
    }

    public static String getParameter(String string) throws IllegalArgumentException {
        return BaseConfig.getParameter(class$com$ibm$mq$jms$SessionConfig == null ? (class$com$ibm$mq$jms$SessionConfig = SessionConfig.class$("com.ibm.mq.jms.SessionConfig")) : class$com$ibm$mq$jms$SessionConfig, string);
    }

    public static Properties getParameter() throws IllegalArgumentException {
        return BaseConfig.getParameter(class$com$ibm$mq$jms$SessionConfig == null ? (class$com$ibm$mq$jms$SessionConfig = SessionConfig.class$("com.ibm.mq.jms.SessionConfig")) : class$com$ibm$mq$jms$SessionConfig);
    }

    public static Properties getAllParameters() throws IllegalArgumentException {
        return BaseConfig.getAllParameters(class$com$ibm$mq$jms$SessionConfig == null ? (class$com$ibm$mq$jms$SessionConfig = SessionConfig.class$("com.ibm.mq.jms.SessionConfig")) : class$com$ibm$mq$jms$SessionConfig);
    }

    public static void populate(String string, FeatureSet featureSet) {
        SessionConfig.populateAux(class$com$ibm$mq$jms$SessionConfig == null ? (class$com$ibm$mq$jms$SessionConfig = SessionConfig.class$("com.ibm.mq.jms.SessionConfig")) : class$com$ibm$mq$jms$SessionConfig, string, featureSet);
    }

    protected static void populateAux(Class clazz, String string, FeatureSet featureSet) {
        String[] stringArray = null;
        try {
            stringArray = (String[])clazz.getField("parameters").get(null);
        }
        catch (Exception exception) {
            Assert.condition(false);
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2;
            String string3 = stringArray[n2];
            try {
                string2 = BaseConfig.getParameter(clazz, string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string2 = "********field not accessible********";
            }
            featureSet.put(string, string3, "" + string2);
            ++n2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String[] stringArray = new String[]{"MAX_CLIENT_READ_THREADS", "CLIENT_THREAD_POLLING_INTERVAL", "MY_BROKER_PORT", "CLIENT_PING_INTERVAL", "PING_TIMEOUT_MULTIPLE", "PING_MIN", "ENABLE_SOCKS", "HTTP_PROXY", "HTTP_PROXY_PORT", "MAX_MESSAGE_QUEUE_SIZE", "SSL_CLASS", "SSL_CIPHER_SUITES", "SSL_KEYRING_FILE", "SSL_PASSPHRASE_FILE", "LOG_MAX_QUEUE", "MATCH_CACHE_INITIAL_CAPACITY"};
        String[] stringArray2 = new String[]{};
        try {
            Class clazz = (class$com$ibm$mq$jms$SessionConfig == null ? (class$com$ibm$mq$jms$SessionConfig = SessionConfig.class$("com.ibm.mq.jms.SessionConfig")) : class$com$ibm$mq$jms$SessionConfig).getSuperclass();
            String[] stringArray3 = (String[])clazz.getField("parameters").get(null);
            parameters = new String[stringArray3.length + stringArray.length];
            System.arraycopy(stringArray3, 0, parameters, 0, stringArray3.length);
            System.arraycopy(stringArray, 0, parameters, stringArray3.length, stringArray.length);
            String[] stringArray4 = (String[])clazz.getField("undocParameters").get(null);
            undocParameters = new String[stringArray4.length + stringArray2.length];
            System.arraycopy(stringArray4, 0, undocParameters, 0, stringArray4.length);
            System.arraycopy(stringArray2, 0, undocParameters, stringArray4.length, stringArray2.length);
        }
        catch (Exception exception) {
            Assert.failure(exception);
        }
        SSL_CLASS = "com.ibm.disthubmq.impl.security.ssl.SimpSSL";
        SSL_CIPHER_SUITES = "SSL_RSA_WITH_RC4_128_SHA  SSL_RSA_EXPORT_WITH_RC4_40_MD5";
        SSL_KEYRING_FILE = null;
        SSL_PASSPHRASE_FILE = null;
        MAX_CLIENT_READ_THREADS = 0;
        CLIENT_THREAD_POLLING_INTERVAL = 100;
        MY_BROKER_PORT = 1506;
        CLIENT_PING_INTERVAL = 30000;
        PING_TIMEOUT_MULTIPLE = 3;
        PING_MIN = 100;
        HTTP_PROXY = "";
        HTTP_PROXY_PORT = 8080;
        MAX_MESSAGE_QUEUE_SIZE = 1000;
        ENABLE_SOCKS = false;
        LOG_MAX_QUEUE = 1000;
        MATCH_CACHE_INITIAL_CAPACITY = 10000;
    }
}

