/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQMessageConsumer;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.NoMsgListenerException;
import com.ibm.mq.jms.SessionClosedException;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.jms.JMSException;

public class SessionAsyncHelper
implements Runnable {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/SessionAsyncHelper.java, jms, j521, j521-L020126 02/01/25 15:34:34 @(#) 1.25.1.1";
    private Vector receivers = new Vector();
    private boolean going = true;
    private boolean finished = false;
    private MQConnection connection;
    private MQSession session;
    private int pollingInterval;
    private int msgBatchSize;
    private Thread asyncThread = null;
    private static int tId = 0;

    SessionAsyncHelper(MQConnection mQConnection, MQSession mQSession) {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        this.connection = mQConnection;
        this.session = mQSession;
        this.msgBatchSize = this.connection.getMsgBatchSize();
        this.pollingInterval = this.connection.getPollingInterval();
        String string = "asyncDelivery" + tId;
        ++tId;
        this.asyncThread = MQEnvironment.createThread((Runnable)this, (String)string, (boolean)true);
        this.asyncThread.start();
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    void addReceiver(MQMessageConsumer mQMessageConsumer) {
        if (Trace.isOn) {
            Trace.entry(this, "addReceiver");
        }
        if (!this.receivers.contains(mQMessageConsumer)) {
            this.receivers.addElement(mQMessageConsumer);
        }
        if (Trace.isOn) {
            Trace.exit(this, "addReceiver");
        }
    }

    void removeReceiver(MQMessageConsumer mQMessageConsumer) {
        boolean bl;
        if (Trace.isOn) {
            Trace.entry(this, "removeReceiver");
        }
        if (!(bl = this.receivers.removeElement(mQMessageConsumer)) && Trace.isOn) {
            Trace.trace(this, "removeReceiver() didn't find the receiver on the list!");
        }
        if (Trace.isOn) {
            Trace.exit(this, "removeReceiver");
        }
    }

    synchronized void shutdown() {
        if (Trace.isOn) {
            Trace.entry(this, "shutdown");
        }
        this.going = false;
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "shutdown");
        }
    }

    private synchronized void setFinished() {
        this.finished = true;
        this.notifyAll();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean hasReceivers() {
        boolean bl;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "hasReceivers");
            }
            bl = this.receivers.size() > 0;
            Object var3_2 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "hasReceivers");
            throw throwable;
        }
        Trace.exit(this, "hasReceivers");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean callingFromOnMessage() {
        boolean bl;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "callingFromOnMessage");
            }
            Thread thread = Thread.currentThread();
            boolean bl2 = thread.equals(this.asyncThread);
            if (Trace.isOn) {
                Trace.trace(this, "callingFromOnMessage returning " + bl2);
            }
            bl = bl2;
            Object var5_4 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "callingFromOnMessage");
            throw throwable;
        }
        Trace.exit(this, "callingFromOnMessage");
        return bl;
    }

    public void run() {
        if (Trace.isOn) {
            Trace.entry(this, "run");
        }
        MQMessageConsumer mQMessageConsumer = null;
        while (this.going) {
            MQMessageConsumer mQMessageConsumer2;
            block25: {
                Vector vector = (Vector)this.receivers.clone();
                Enumeration enumeration = vector.elements();
                boolean bl = true;
                mQMessageConsumer2 = null;
                block18: while (this.going) {
                    try {
                        mQMessageConsumer = (MQMessageConsumer)enumeration.nextElement();
                        int n = 0;
                        while (n < this.msgBatchSize) {
                            boolean bl2;
                            if (!this.going || !(bl2 = mQMessageConsumer.receiveAsync(0L))) continue block18;
                            bl = false;
                            mQMessageConsumer2 = mQMessageConsumer;
                            ++n;
                        }
                    }
                    catch (NoMsgListenerException noMsgListenerException) {
                        this.receivers.removeElement(mQMessageConsumer);
                    }
                    catch (JMSException jMSException) {
                        this.receivers.removeElement(mQMessageConsumer);
                        this.connection.deliverException(jMSException);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        if (!Trace.isOn) break;
                        Trace.trace(this, "leaving the recvr polling loop, nothingReceived = " + bl);
                        break;
                    }
                    catch (Throwable throwable) {
                        try {
                            Logger.log(new LogMessage(2, "MQJMS1016", throwable.toString()));
                        }
                        catch (LogException logException) {
                            System.err.println("failed to log error because of " + logException);
                        }
                    }
                }
                if (!this.going || !bl) continue;
                if (mQMessageConsumer2 == null) {
                    try {
                        mQMessageConsumer2 = (MQMessageConsumer)this.receivers.firstElement();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                    }
                    catch (Exception exception) {
                        if (!Trace.isOn) break block25;
                        Trace.trace(this, "failed to find a consumer for blocking read because of " + exception);
                    }
                }
            }
            if (!this.session.isStarted()) {
                try {
                    this.session.waitForStart(this.pollingInterval);
                }
                catch (SessionClosedException sessionClosedException) {
                    this.going = false;
                }
                catch (JMSException jMSException) {}
                continue;
            }
            if (mQMessageConsumer2 == null || this.session.getPlayNice()) {
                try {
                    Thread.sleep(this.pollingInterval);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                mQMessageConsumer2.receiveAsync(this.pollingInterval);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) continue;
                Trace.trace(this, "suppressing exception from blocking receiveAsync: " + (Object)((Object)jMSException));
            }
        }
        this.setFinished();
        if (Trace.isOn) {
            Trace.exit(this, "run");
        }
    }
}

