/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQMsg2;
import com.ibm.mq.jms.MQBrokerMessage;
import com.ibm.mq.jms.RFH;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.jms.JMSException;

class RFH1BrokerMessageImpl
extends MQBrokerMessage {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2001, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/RFH1BrokerMessageImpl.java, jms, j521, j521-L020126 02/01/25 15:47:31 @(#) 1.6.1.1";
    private static final String clsName = "RFH1BrokerMessageImpl";
    private RFH rfh = null;
    private Vector auxilliaryNVPairs = new Vector();
    private static final int PARSE_STATE_START = 0;
    private static final int PARSE_STATE_UNQUOTED_TOKEN = 1;
    private static final int PARSE_STATE_QUOTED_TOKEN = 2;
    private static final int PARSE_STATE_AFTER_ONE_QUOTE = 3;
    private static final int PARSE_STATE_FINISHED = 4;
    private static final int PARSE_TOKEN_NORMAL = 0;
    private static final int PARSE_TOKEN_SPACE = 1;
    private static final int PARSE_TOKEN_QUOTE = 2;
    private static final int PARSE_TOKEN_END = 3;

    public RFH1BrokerMessageImpl() {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    public void clear() {
        if (Trace.isOn) {
            Trace.entry(this, "clear");
        }
        this.rfh = null;
        this.auxilliaryNVPairs = new Vector();
        super.clear();
        if (Trace.isOn) {
            Trace.exit(this, "clear");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initializeFromMessage(MQMsg2 mQMsg2) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "initializeFromMessage");
        }
        try {
            try {
                this.clear();
                this.rfh = new RFH(mQMsg2);
                this.setEncoding(this.rfh.getEncoding());
                this.setCodedCharSetId(this.rfh.getCodedCharSetId());
                this.setFormat(this.rfh.getFormat());
                String string = this.rfh.getNameValueString();
                Vector vector = this.parseNameValues(string);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    String string2;
                    String string3;
                    try {
                        string3 = (String)enumeration.nextElement();
                        string2 = (String)enumeration.nextElement();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        if (Trace.isOn) {
                            Trace.trace(this, "caught " + noSuchElementException);
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1087");
                        jMSException.setLinkedException((Exception)noSuchElementException);
                        throw jMSException;
                    }
                    try {
                        this.update(string3, string2);
                    }
                    catch (JMSException jMSException) {
                        this.auxilliaryNVPairs.addElement(string3);
                        this.auxilliaryNVPairs.addElement(string2);
                    }
                }
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var10_11 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "initializeFromMessage");
            throw throwable;
        }
        Trace.exit(this, "initializeFromMessage");
    }

    public void writeToMessage(MQMsg2 mQMsg2) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "writeToMessage");
        }
        try {
            try {
                String string;
                if (this.rfh == null) {
                    this.rfh = new RFH();
                }
                this.rfh.setEncoding(this.getEncoding());
                this.rfh.setCodedCharSetId(this.getCodedCharSetId());
                this.rfh.setFormat(this.getFormat());
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = false;
                String string2 = this.get("MQPSCommand");
                if (string2 != null) {
                    if (bl) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append("MQPSCommand");
                    stringBuffer.append(' ');
                    this.appendToken(stringBuffer, string2);
                    bl = true;
                }
                Enumeration enumeration = this.getFields();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    if (string.equals("MQPSCommand")) continue;
                    string2 = this.get(string);
                    if (bl) {
                        stringBuffer.append(' ');
                    }
                    this.appendToken(stringBuffer, string);
                    stringBuffer.append(' ');
                    this.appendToken(stringBuffer, string2);
                    bl = true;
                }
                enumeration = this.auxilliaryNVPairs.elements();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    string2 = (String)enumeration.nextElement();
                    if (bl) {
                        stringBuffer.append(' ');
                    }
                    this.appendToken(stringBuffer, string);
                    stringBuffer.append(' ');
                    this.appendToken(stringBuffer, string2);
                    bl = true;
                }
                string = stringBuffer.toString();
                this.rfh.setNameValueString(string);
                this.rfh.write(mQMsg2);
            }
            catch (JMSException jMSException) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Trace.exit(this, "writeToMessage");
            throw throwable;
        }
        Trace.exit(this, "writeToMessage");
    }

    public String getHeaderFormat() {
        return "MQHRF   ";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector parseNameValues(String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "parseNameValues");
        }
        int n = 0;
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        try {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \"\u0000", true);
                while (n != 4) {
                    int n2;
                    String string3;
                    block41: {
                        block39: {
                            block40: {
                                if (!stringTokenizer.hasMoreElements()) break block39;
                                string3 = stringTokenizer.nextToken();
                                n2 = 0;
                                if (!string3.equals(" ")) break block40;
                                n2 = 1;
                                break block41;
                            }
                            if (string3.equals("\"")) {
                                n2 = 2;
                                break block41;
                            } else if (string3.equals("\u0000")) {
                                n2 = 3;
                            }
                            break block41;
                        }
                        n2 = 3;
                        string3 = null;
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "Parser state is " + n + ", token is " + string3 + " of type " + n2);
                    }
                    block2 : switch (n) {
                        case 0: {
                            switch (n2) {
                                case 0: {
                                    vector.addElement(string3);
                                    n = 1;
                                    break block2;
                                }
                                case 1: {
                                    n = 0;
                                    break block2;
                                }
                                case 2: {
                                    n = 2;
                                    string2 = "";
                                    break block2;
                                }
                                case 3: {
                                    n = 4;
                                    break block2;
                                }
                            }
                            this.badTokType();
                            break;
                        }
                        case 1: {
                            switch (n2) {
                                case 0: 
                                case 2: {
                                    this.invalidNVPairs();
                                    break block2;
                                }
                                case 1: {
                                    n = 0;
                                    break block2;
                                }
                                case 3: {
                                    n = 4;
                                    break block2;
                                }
                            }
                            this.badTokType();
                            break;
                        }
                        case 2: {
                            switch (n2) {
                                case 0: {
                                    string2 = string2 + string3;
                                    n = 2;
                                    break block2;
                                }
                                case 1: {
                                    string2 = string2 + ' ';
                                    n = 2;
                                    break block2;
                                }
                                case 2: {
                                    n = 3;
                                    break block2;
                                }
                                case 3: {
                                    this.invalidNVPairs();
                                    break block2;
                                }
                            }
                            this.badTokType();
                            break;
                        }
                        case 3: {
                            switch (n2) {
                                case 0: {
                                    this.invalidNVPairs();
                                    break block2;
                                }
                                case 1: {
                                    vector.addElement(string2);
                                    string2 = null;
                                    n = 0;
                                    break block2;
                                }
                                case 2: {
                                    string2 = string2 + '\"';
                                    n = 2;
                                    break block2;
                                }
                                case 3: {
                                    vector.addElement(string2);
                                    string2 = null;
                                    n = 4;
                                    break block2;
                                }
                            }
                            this.badTokType();
                            break;
                        }
                        default: {
                            this.badState();
                        }
                    }
                }
                Vector<String> vector2 = vector;
                Object var9_10 = null;
                Trace.exit(clsName, "parseNameValues");
                return vector2;
            }
            catch (JMSException jMSException) {
                Trace.trace(clsName, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            Trace.exit(clsName, "parseNameValues");
            throw throwable;
        }
    }

    private void badTokType() throws JMSException {
        String string = "RFH1BrokerMessageImpl encountered impossible token type";
        JMSException jMSException = ConfigEnvironment.newException("MQJMS1016", string);
        throw jMSException;
    }

    private void badState() throws JMSException {
        String string = "RFH1BrokerMessageImpl encountered impossible state value";
        JMSException jMSException = ConfigEnvironment.newException("MQJMS1016", string);
        throw jMSException;
    }

    private void invalidNVPairs() throws JMSException {
        JMSException jMSException = ConfigEnvironment.newException("MQJMS1087");
        throw jMSException;
    }

    private void appendToken(StringBuffer stringBuffer, String string) {
        if (Trace.isOn) {
            Trace.entry(this, "appendToken");
        }
        if (string.equals("")) {
            stringBuffer.append("\"\"");
        } else if (string.indexOf("\"") == -1) {
            if (string.indexOf(" ") == -1) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append('\"');
                stringBuffer.append(string);
                stringBuffer.append('\"');
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\"", true);
            stringBuffer.append('\"');
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("\"")) {
                    stringBuffer.append("\"\"");
                    continue;
                }
                stringBuffer.append(string2);
            }
            stringBuffer.append("\"");
        }
        if (Trace.isOn) {
            Trace.exit(this, "appendToken");
        }
    }
}

