/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQMessage;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import javax.jms.JMSException;

class RFH {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/RFH.java, jms, j521, j521-L020126 02/01/25 14:46:27 @(#) 1.11.1.1";
    private static final String MQRFH_STRUC_ID = "RFH ";
    private static final int MQRFH_ASCII_STRUC_ID_INT = 1380337696;
    private static final int MQRFH_EBCDIC_STRUC_ID_INT = -641284032;
    private static final int MQRFH_VERSION_1 = 1;
    private static final int MQRFH_STRUC_LENGTH_FIXED = 32;
    private String strucId;
    private int version;
    private int strucLength;
    private int encoding;
    private int codedCharSetId;
    private String format;
    private int flags;
    private String nameValueString;
    private int msgCharSet;
    private int msgEncoding;

    RFH() {
        if (Trace.isOn) {
            Trace.entry(this, "constructor()");
        }
        this.strucId = MQRFH_STRUC_ID;
        this.version = 1;
        this.strucLength = 32;
        this.encoding = 273;
        this.codedCharSetId = 0;
        this.format = "        ";
        this.flags = 0;
        this.nameValueString = null;
        if (Trace.isOn) {
            Trace.exit(this, "constructor()");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    RFH(MQMsg2 mQMsg2) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "constructor(message)");
            }
            if (mQMsg2 == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1074");
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            this.msgCharSet = mQMsg2.getCharacterSet();
            this.msgEncoding = mQMsg2.getEncoding();
            try {
                int n = mQMsg2.readInt(1);
                switch (n) {
                    case 1380337696: {
                        this.msgCharSet = 819;
                        this.strucId = MQRFH_STRUC_ID;
                        break;
                    }
                    case -641284032: {
                        this.msgCharSet = 500;
                        this.strucId = MQRFH_STRUC_ID;
                        break;
                    }
                    default: {
                        throw new Exception("strucId");
                    }
                }
                this.version = mQMsg2.readInt(this.msgEncoding);
                if (this.version != 1) {
                    throw new Exception("version");
                }
                this.strucLength = mQMsg2.readInt(this.msgEncoding);
                this.encoding = mQMsg2.readInt(this.msgEncoding);
                this.codedCharSetId = mQMsg2.readInt(this.msgEncoding);
                byte[] byArray = new byte[8];
                mQMsg2.read(byArray);
                this.format = this.getString(byArray);
                this.flags = mQMsg2.readInt(this.msgEncoding);
                int n2 = this.strucLength - 32;
                byArray = new byte[n2];
                mQMsg2.read(byArray);
                this.nameValueString = this.getString(byArray);
                if (Trace.isOn) {
                    Trace.trace(this, "The following fields have been read:\n" + this.toString());
                }
            }
            catch (Exception exception) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1086");
                jMSException.setLinkedException(exception);
                if (Trace.isOn) {
                    Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                }
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Linked Exception " + exception);
                throw jMSException;
            }
            Object var6_8 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "constructor(message)");
            throw throwable;
        }
        Trace.exit(this, "constructor(message)");
    }

    String getNameValueString() {
        return this.nameValueString;
    }

    void setNameValueString(String string) {
        this.nameValueString = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getValue(String string) {
        String string2;
        block5: {
            String string3;
            if (Trace.isOn) {
                Trace.entry(this, "getValue");
                Trace.trace(this, "nameValueString='" + this.nameValueString + "'");
                Trace.trace(this, "searching for key='" + string + "'");
            }
            try {
                String string4;
                StringTokenizer stringTokenizer = new StringTokenizer(this.nameValueString);
                do {
                    if (!stringTokenizer.hasMoreTokens()) {
                        string2 = null;
                        break block5;
                    }
                    string2 = stringTokenizer.nextToken();
                    string4 = stringTokenizer.nextToken();
                } while (!string2.equals(string));
                string3 = string4;
                Object var7_6 = null;
                if (!Trace.isOn) return string3;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (!Trace.isOn) throw throwable;
                Trace.exit(this, "getValue");
                throw throwable;
            }
            Trace.exit(this, "getValue");
            return string3;
        }
        Object var7_7 = null;
        if (!Trace.isOn) return string2;
        Trace.exit(this, "getValue");
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void write(MQMessage mQMessage) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "write");
                }
                this.encoding = mQMessage.encoding;
                this.codedCharSetId = mQMessage.characterSet;
                this.format = mQMessage.format;
                mQMessage.encoding = 273;
                mQMessage.characterSet = 0;
                mQMessage.format = "MQHRF   ";
                int n = mQMessage.getMessageLength();
                byte[] byArray = new byte[n];
                mQMessage.seek(0);
                mQMessage.readFully(byArray);
                mQMessage.seek(0);
                this.writeRFHFields(mQMessage);
                mQMessage.write(byArray);
            }
            catch (Exception exception) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1085");
                jMSException.setLinkedException(exception);
                throw jMSException;
            }
            Object var5_6 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "write");
            throw throwable;
        }
        Trace.exit(this, "write");
    }

    private void writeRFHFields(MQMessage mQMessage) throws IOException {
        if (this.nameValueString != null) {
            while (this.nameValueString.length() % 4 != 0) {
                this.nameValueString = this.nameValueString + " ";
            }
            this.strucLength = 32 + this.nameValueString.length();
        }
        mQMessage.writeString(this.strucId);
        mQMessage.writeInt(this.version);
        mQMessage.writeInt(this.strucLength);
        mQMessage.writeInt(this.encoding);
        mQMessage.writeInt(this.codedCharSetId);
        mQMessage.writeString(this.format);
        mQMessage.writeInt(this.flags);
        if (this.nameValueString != null) {
            mQMessage.writeString(this.nameValueString);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(MQMsg2 mQMsg2) throws JMSException {
        try {
            block9: {
                if (Trace.isOn) {
                    Trace.entry(this, "write(MQMsg2)");
                }
                if (this.nameValueString != null) {
                    int n = this.nameValueString.length();
                    while (n % 4 != 0) {
                        this.nameValueString = this.nameValueString + " ";
                        ++n;
                    }
                    this.strucLength = 32 + this.nameValueString.length();
                } else {
                    this.strucLength = 32;
                }
                this.msgEncoding = mQMsg2.getEncoding();
                this.msgCharSet = mQMsg2.getCharacterSet();
                mQMsg2.appendByteArray(this.getByteArray(this.strucId));
                mQMsg2.appendInt(this.version, this.msgEncoding);
                mQMsg2.appendInt(this.strucLength, this.msgEncoding);
                mQMsg2.appendInt(this.encoding, this.msgEncoding);
                mQMsg2.appendInt(this.codedCharSetId, this.msgEncoding);
                mQMsg2.appendByteArray(this.getByteArray(this.format));
                mQMsg2.appendInt(this.flags, this.msgEncoding);
                if (this.nameValueString == null) break block9;
                mQMsg2.appendByteArray(this.getByteArray(this.nameValueString));
            }
            Object var5_4 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "write(MQMsg2)");
            throw throwable;
        }
        Trace.exit(this, "write(MQMsg2)");
        {
            return;
            catch (Exception exception) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1085");
                jMSException.setLinkedException(exception);
                if (Trace.isOn) {
                    Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                }
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Linked Exception " + exception);
                throw jMSException;
            }
        }
    }

    private String getString(byte[] byArray) throws UnsupportedEncodingException {
        return new String(byArray, MQJMSMessage.getCharacterSetString(this.msgCharSet, this.msgEncoding));
    }

    private byte[] getByteArray(String string) throws UnsupportedEncodingException {
        return string.getBytes(MQJMSMessage.getCharacterSetString(this.msgCharSet, this.msgEncoding));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("StrucId='" + this.strucId + "'\n");
        stringBuffer.append("Version=" + this.version + "\n");
        stringBuffer.append("StrucLength=" + this.strucLength + "\n");
        stringBuffer.append("Encoding=" + this.encoding + "\n");
        stringBuffer.append("CodedCharSetId=" + this.codedCharSetId + "\n");
        stringBuffer.append("Format='" + this.format + "'\n");
        stringBuffer.append("Flags=" + this.flags + "\n");
        if (this.nameValueString != null) {
            stringBuffer.append("NameValueString='" + this.nameValueString + "'");
        }
        return stringBuffer.toString();
    }

    public void setEncoding(int n) {
        if (Trace.isOn) {
            Trace.entry(this, "setEncoding");
            Trace.exit(this, "setEncoding");
        }
        this.encoding = n;
    }

    public int getEncoding() {
        if (Trace.isOn) {
            Trace.entry(this, "getEncoding");
            Trace.exit(this, "getEncoding");
        }
        return this.encoding;
    }

    public void setCodedCharSetId(int n) {
        if (Trace.isOn) {
            Trace.entry(this, "setCodedCharSetId");
            Trace.exit(this, "setCodedCharSetId");
        }
        this.codedCharSetId = n;
    }

    public int getCodedCharSetId() {
        if (Trace.isOn) {
            Trace.entry(this, "getCodedCharSetId");
            Trace.exit(this, "getCodedCharSetId");
        }
        return this.codedCharSetId;
    }

    public void setFormat(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setFormat");
            Trace.exit(this, "setFormat");
        }
        this.format = string;
    }

    public String getFormat() {
        if (Trace.isOn) {
            Trace.entry(this, "getFormat");
            Trace.exit(this, "getFormat");
        }
        return this.format;
    }
}

