/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.Envelop;
import com.ibm.disthubmq.impl.formats.SchemaCursor;
import com.ibm.disthubmq.impl.formats.TupleCursor;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.mq.jms.JMSWrappedException;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;

public class ObjectMessageImpl
extends MessageImpl
implements ObjectMessage,
Envelop.payload.normal.body.jms,
ClientExceptionConstants {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM 5648-C60(c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/ObjectMessageImpl.java, jms, j521, j521-L020126 02/01/25 15:19:51 @(#) 1.11.1.1";
    private static final DebugObject debug = new DebugObject("ObjectMessageImpl");

    public ObjectMessageImpl(SchemaCursor schemaCursor, TupleCursor tupleCursor, TupleCursor tupleCursor2) {
        super(schemaCursor, tupleCursor, tupleCursor2);
        this.messageClass = "jms_object";
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "ObjectMessageImpl", schemaCursor, tupleCursor, tupleCursor2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "ObjectMessageImpl");
        }
    }

    public ObjectMessageImpl() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "ObjectMessageImpl");
        }
        this.messageClass = "jms_object";
        try {
            this.setObjectBody(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "ObjectMessageImpl");
        }
    }

    public void setObject(Serializable serializable) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setObject", serializable);
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.setObjectRaw(byArray);
        }
        catch (InvalidClassException invalidClassException) {
            String string = "MQJMS1060";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new MessageFormatException(string2, string);
        }
        catch (NotSerializableException notSerializableException) {
            String string = "MQJMS1060";
            String string3 = ConfigEnvironment.getErrorMessage(string);
            throw new MessageFormatException(string3, string);
        }
        catch (IOException iOException) {
            String string = "MQJMS1060";
            String string4 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string4, string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setObject");
        }
    }

    public Serializable getObject() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getObject");
        }
        Serializable serializable = null;
        try {
            serializable = this.getObjectBody();
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string = "MQJMS1061";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string2, string);
        }
        catch (InvalidClassException invalidClassException) {
            String string = "MQJMS1061";
            String string3 = ConfigEnvironment.getErrorMessage(string);
            throw new MessageFormatException(string3, string);
        }
        catch (Exception exception) {
            String string = "MQJMS1061";
            String string4 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSWrappedException(string4, exception);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getObject", serializable);
        }
        return serializable;
    }

    public void clearBody() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "clearBody");
        }
        this.readOnly = false;
        try {
            this.setObjectBody(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "clearBody");
        }
    }
}

