/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.client.MessageImpl;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.mq.jms.GenericMessage;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class MsgConverter
implements ClientLogConstants {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM 5648-C60(c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "common/jms/com/ibm/mq/jms/MsgConverter.java, jms, j521, j521-L020126 02/01/25 15:19:40 @(#) 1.6.1.1";
    private static final DebugObject debug = new DebugObject("MsgConverter");

    private MsgConverter() {
    }

    public static void fromGryphon(MessageImpl messageImpl, GenericMessage genericMessage) {
        Object object;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "fromGryphon", messageImpl, genericMessage);
        }
        genericMessage.setMessageType(messageImpl.getMessageType());
        genericMessage.setTopic(messageImpl.getTopicString());
        genericMessage.setReplyTopic(messageImpl.getReplyString());
        genericMessage.setMessageID(messageImpl.getMessageID());
        genericMessage.setMDT(messageImpl.cursor.getContents().getByteArray(0));
        genericMessage.setJMSCorrelationID(messageImpl.getCorrelationID());
        genericMessage.setJMSDeliveryMode(1);
        genericMessage.setJMSExpiration(0L);
        genericMessage.setJMSPriority(messageImpl.getPriority());
        genericMessage.setJMSRedelivered(false);
        genericMessage.setJMSTimestamp(messageImpl.getTimestamp());
        genericMessage.setJMSType(messageImpl.getJMSTypeField());
        Dictionary dictionary = messageImpl.getProperties();
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            genericMessage.setProperty((String)object, dictionary.get(object));
        }
        switch (messageImpl.getMessageType()) {
            case 1: {
                break;
            }
            case 3: {
                genericMessage.setBody(messageImpl.getBytesBody());
                break;
            }
            case 5: {
                object = messageImpl.getFields().elements();
                while (object.hasMoreElements()) {
                    genericMessage.setField(object.nextElement());
                }
                break;
            }
            case 6: {
                Dictionary dictionary2 = messageImpl.getNamedFields();
                Enumeration enumeration2 = dictionary2.keys();
                while (enumeration2.hasMoreElements()) {
                    String string = (String)enumeration2.nextElement();
                    genericMessage.setField(string, dictionary2.get(string));
                }
                break;
            }
            case 2: {
                genericMessage.setBody(messageImpl.getObjectRaw());
                break;
            }
            case 4: {
                genericMessage.setText(messageImpl.getTextBody());
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "fromGryphon");
        }
    }

    public static MessageImpl toGryphon(GenericMessage genericMessage) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "toGryphon", genericMessage);
        }
        MessageImpl messageImpl = new MessageImpl();
        messageImpl.setTopicString(genericMessage.getTopic());
        messageImpl.setReplyString(genericMessage.getReplyTopic());
        messageImpl.setMessageID(genericMessage.getMessageID());
        messageImpl.cursor.getContents().setByteArray(0, genericMessage.getMDT());
        messageImpl.setCorrelationID(genericMessage.getJMSCorrelationID());
        messageImpl.setPriority(genericMessage.getJMSPriority());
        messageImpl.setTimestamp(genericMessage.getJMSTimestamp());
        messageImpl.setJMSTypeField(genericMessage.getJMSType());
        Hashtable hashtable = new Hashtable();
        GenericMessage.NamedEnumeration namedEnumeration = genericMessage.getProperties();
        while (namedEnumeration.hasMoreElements()) {
            hashtable.put(namedEnumeration.getName(), namedEnumeration.nextElement());
        }
        messageImpl.setProperties(hashtable);
        switch (genericMessage.getMessageType()) {
            case 1: {
                break;
            }
            case 3: {
                messageImpl.setBytesBody(genericMessage.getBody());
                break;
            }
            case 5: {
                Vector vector = new Vector();
                Enumeration enumeration = genericMessage.getFields();
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                messageImpl.setFields(vector);
                break;
            }
            case 6: {
                Hashtable hashtable2 = new Hashtable();
                GenericMessage.NamedEnumeration namedEnumeration2 = genericMessage.getNamedFields();
                while (namedEnumeration2.hasMoreElements()) {
                    hashtable2.put(namedEnumeration2.getName(), namedEnumeration2.nextElement());
                }
                messageImpl.setNamedFields(hashtable2);
                break;
            }
            case 2: {
                messageImpl.setObjectRaw(genericMessage.getBody());
                break;
            }
            case 4: {
                messageImpl.setTextBody(genericMessage.getText());
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "toGryphon");
        }
        return messageImpl;
    }
}

