/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.impl.util.Queue;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.mq.jms.ExceptionDispatchThread;
import com.ibm.mq.jms.JMSMessageQueueOverflowException;
import com.ibm.mq.jms.JMSWrappedException;
import com.ibm.mq.jms.MessageConsumerImpl;
import com.ibm.mq.jms.MessageImpl;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;

public class MessageQueue
implements ClientExceptionConstants,
ClientLogConstants {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM 5648-C60(c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MessageQueue.java, jms, j521, j521-L020523 02/05/22 18:33:29 @(#) 1.6.1.3";
    private static final DebugObject debug = new DebugObject("MessageQueue");
    private Queue normalQueue;
    private Queue priorityQueue;
    private Thread blockedThread;
    private volatile boolean alive = true;
    private boolean stopped = true;
    private boolean appConnectionClosed = true;
    private Exception eConnectionClosed = null;
    private int messageCount;
    private int maxMessageCount;

    MessageQueue(int n) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "MessageQueue");
        }
        this.normalQueue = new Queue();
        this.priorityQueue = new Queue();
        this.maxMessageCount = n;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "MessageQueue");
        }
    }

    synchronized void enqueue(MessageImpl messageImpl) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "enqueue", messageImpl);
        }
        if (this.maxMessageCount > 0 && this.messageCount >= this.maxMessageCount) {
            while (this.priorityQueue.dequeueOrNull() != null) {
            }
            while (this.normalQueue.dequeueOrNull() != null) {
            }
            this.messageCount = 0;
            try {
                ExceptionListener exceptionListener = messageImpl.getConsumer().getSession().getConnection().getExceptionListener();
                if (exceptionListener != null) {
                    ExceptionDispatchThread.xThread.enqueue(exceptionListener, (Exception)((Object)new JMSMessageQueueOverflowException(ExceptionBuilder.buildReasonString(1122, new Object[]{new Integer(this.maxMessageCount)}))));
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        ++this.messageCount;
        try {
            if (messageImpl.getJMSPriority() > 4) {
                this.priorityQueue.enqueue(messageImpl);
            } else {
                this.normalQueue.enqueue(messageImpl);
            }
            this.notifyAll();
        }
        catch (JMSException jMSException) {
            Assert.failure((Exception)((Object)jMSException));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "enqueue");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized MessageImpl dequeue() throws InterruptedException, JMSWrappedException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "dequeue");
        }
        while (true) {
            Object var3_1;
            if (!(this.stopped || this.priorityQueue.isEmpty() && this.normalQueue.isEmpty())) {
                MessageImpl messageImpl = this.dequeueImmediate();
                if (debug.debugIt(64)) {
                    debug.debug(-175921860444054L, "dequeue", messageImpl);
                }
                return messageImpl;
            }
            if (!this.alive) {
                if (!this.appConnectionClosed) {
                    throw new InterruptedException(ExceptionBuilder.buildReasonString(1092, null));
                }
                if (debug.debugIt(64)) {
                    debug.debug(-175921860444054L, "dequeue", null);
                }
                return null;
            }
            this.blockedThread = Thread.currentThread();
            try {
                try {
                    this.wait();
                    if (!this.alive) {
                        if (!this.appConnectionClosed) {
                            throw new JMSWrappedException(ExceptionBuilder.buildReasonString(1100, new Object[]{this.eConnectionClosed}), this.eConnectionClosed);
                        }
                        if (debug.debugIt(64)) {
                            debug.debug(-175921860444054L, "dequeue", null);
                        }
                        MessageImpl messageImpl = null;
                        var3_1 = null;
                        this.blockedThread = null;
                        return messageImpl;
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedException(ExceptionBuilder.buildReasonString(1101, new Object[]{interruptedException}));
                }
            }
            catch (Throwable throwable) {
                var3_1 = null;
                this.blockedThread = null;
                throw throwable;
            }
            var3_1 = null;
            this.blockedThread = null;
        }
    }

    synchronized MessageImpl dequeueNoWait() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "dequeueNoWait");
        }
        MessageImpl messageImpl = null;
        if (!(this.stopped || this.priorityQueue.isEmpty() && this.normalQueue.isEmpty())) {
            messageImpl = this.dequeueImmediate();
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "dequeueNoWait", messageImpl);
        }
        return messageImpl;
    }

    synchronized MessageImpl dequeueWait(long l) throws InterruptedException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "dequeueWait", new Long(l));
        }
        if (!(this.stopped || this.priorityQueue.isEmpty() && this.normalQueue.isEmpty())) {
            MessageImpl messageImpl = this.dequeueImmediate();
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "dequeueWait", messageImpl);
            }
            return messageImpl;
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 + l;
        while (l3 > l2) {
            Object var8_5;
            if (!this.alive) {
                throw new InterruptedException(ExceptionBuilder.buildReasonString(1092, null));
            }
            this.blockedThread = Thread.currentThread();
            try {
                this.wait(l3 - l2);
                var8_5 = null;
                this.blockedThread = null;
            }
            catch (Throwable throwable) {
                var8_5 = null;
                this.blockedThread = null;
                throw throwable;
            }
            if (!(this.stopped || this.priorityQueue.isEmpty() && this.normalQueue.isEmpty())) {
                MessageImpl messageImpl = this.dequeueImmediate();
                if (debug.debugIt(64)) {
                    debug.debug(-175921860444054L, "dequeueWait", messageImpl);
                }
                return messageImpl;
            }
            l2 = System.currentTimeMillis();
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "dequeueWait", null);
        }
        return null;
    }

    synchronized MessageImpl dequeueImmediate() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "dequeueImmediate");
        }
        MessageImpl messageImpl = null;
        if (!this.priorityQueue.isEmpty()) {
            messageImpl = (MessageImpl)this.priorityQueue.dequeue();
        } else if (!this.normalQueue.isEmpty()) {
            messageImpl = (MessageImpl)this.normalQueue.dequeue();
        }
        if (messageImpl == null) {
            Assert.failure();
        }
        --this.messageCount;
        Assert.condition(this.messageCount >= 0);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "dequeueImmediate", messageImpl);
        }
        return messageImpl;
    }

    synchronized void moveTo(MessageQueue messageQueue) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "moveTo", messageQueue);
        }
        MessageQueue messageQueue2 = messageQueue;
        synchronized (messageQueue2) {
            while (!this.priorityQueue.isEmpty()) {
                messageQueue.priorityQueue.enqueue(this.priorityQueue.dequeue());
                ++messageQueue.messageCount;
                --this.messageCount;
            }
            while (!this.normalQueue.isEmpty()) {
                messageQueue.normalQueue.enqueue(this.normalQueue.dequeue());
                ++messageQueue.messageCount;
                --this.messageCount;
            }
            messageQueue.notifyAll();
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "moveTo");
        }
    }

    synchronized void moveMessagesFor(MessageConsumerImpl messageConsumerImpl, MessageQueue messageQueue) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "moveMessageFor", messageConsumerImpl, messageQueue);
        }
        MessageQueue messageQueue2 = new MessageQueue(0);
        MessageQueue messageQueue3 = messageQueue;
        synchronized (messageQueue3) {
            MessageImpl messageImpl;
            while (!this.priorityQueue.isEmpty()) {
                messageImpl = (MessageImpl)this.priorityQueue.dequeue();
                --this.messageCount;
                if (messageImpl.isFor(messageConsumerImpl)) {
                    messageQueue.priorityQueue.enqueue(messageImpl);
                    ++messageQueue.messageCount;
                    continue;
                }
                messageQueue2.enqueue(messageImpl);
            }
            while (!this.normalQueue.isEmpty()) {
                messageImpl = (MessageImpl)this.normalQueue.dequeue();
                --this.messageCount;
                if (messageImpl.isFor(messageConsumerImpl)) {
                    messageQueue.normalQueue.enqueue(messageImpl);
                    ++messageQueue.messageCount;
                    continue;
                }
                messageQueue2.enqueue(messageImpl);
            }
            messageQueue2.moveTo(this);
            messageQueue.notifyAll();
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "moveMessagesFor");
        }
    }

    synchronized void close(Exception exception, boolean bl) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "close", exception, new Boolean(bl));
        }
        this.alive = false;
        if (this.blockedThread != null) {
            this.appConnectionClosed = bl;
            this.eConnectionClosed = exception;
            this.blockedThread = null;
            this.notifyAll();
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "close");
        }
    }

    synchronized void stop() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "stop");
        }
        this.stopped = true;
        this.notifyAll();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "stop");
        }
    }

    synchronized void start() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "start");
        }
        this.stopped = false;
        this.notifyAll();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "start");
        }
    }
}

