/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.mq.jms.JMSInvalidParameterException;
import com.ibm.mq.jms.JMSNotActiveException;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.SessionImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import javax.jms.JMSException;
import javax.jms.MessageProducer;

public class MessageProducerImpl
implements MessageProducer,
ClientLogConstants,
ClientExceptionConstants {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM 5648-C60(c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MessageProducerImpl.java, jms, j521, j521-L020126 02/01/25 15:19:13 @(#) 1.10.1.1";
    private static final DebugObject debug = new DebugObject("MessageProducerImpl");
    private boolean active = true;
    private boolean disableMessageID = false;
    private boolean disableMessageTimestamp = false;
    protected int deliveryMode = 1;
    protected int priority = 4;
    protected long timeToLive = 0L;
    private SessionImpl parentSession;

    public MessageProducerImpl(SessionImpl sessionImpl) throws JMSNotActiveException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "MessageProducerImpl", sessionImpl);
        }
        this.parentSession = sessionImpl;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "MessageProducerImpl");
        }
    }

    public void setDisableMessageID(boolean bl) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setDisableMessageID", new Boolean(bl));
        }
        this.disableMessageID = bl;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setDisableMessageID");
        }
    }

    public boolean getDisableMessageID() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getDisableMessageID");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getDisableMessageID", new Boolean(this.disableMessageID));
        }
        return this.disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean bl) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setDisableMessageTimestamp", new Boolean(bl));
        }
        this.disableMessageTimestamp = bl;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setDisableMessageTimestamp");
        }
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getDisableMessageTimestamp");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getDisableMessageTimestamp", new Boolean(this.disableMessageTimestamp));
        }
        return this.disableMessageTimestamp;
    }

    public void setDeliveryMode(int n) throws JMSInvalidParameterException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setDeliveryMode", new Integer(n));
        }
        MessageImpl.validateDeliveryMode(n);
        this.deliveryMode = n;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setDeliveryMode");
        }
    }

    public int getDeliveryMode() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getDeliveryMode");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getDeliveryMode", new Integer(this.deliveryMode));
        }
        return this.deliveryMode;
    }

    public void setPriority(int n) throws JMSInvalidParameterException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setPriority", new Integer(n));
        }
        MessageImpl.validatePriority(n);
        this.priority = n;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setPriority");
        }
    }

    public int getPriority() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getPirority");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getPriority", new Integer(this.priority));
        }
        return this.priority;
    }

    public void setTimeToLive(long l) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setTimeToLive", new Long(l));
        }
        if (l < 0L) {
            String string = "MQJMS1006";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSInvalidParameterException(string2);
        }
        if (l > 0L) {
            String string = "MQJMS1010";
            String string3 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string3, string);
        }
        this.timeToLive = l;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setTimeToLive");
        }
    }

    public void setTimeToLive(int n) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setTimeToLive", new Long(n));
        }
        this.setTimeToLive((long)n);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setTimeToLive");
        }
    }

    public long getTimeToLive() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getTimeToLive");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getTimeToLive", new Long(this.timeToLive));
        }
        return this.timeToLive;
    }

    public void close() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "close");
        }
        this.active = false;
        this.parentSession = null;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "close");
        }
    }

    SessionImpl getSession() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getSession");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getSession", this.parentSession);
        }
        return this.parentSession;
    }

    protected boolean isActive() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "isActive");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "isActive", new Boolean(this.active));
        }
        return this.active;
    }

    protected boolean isClosed() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "isClosed");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "isClosed", new Boolean(!this.active));
        }
        return !this.active;
    }
}

