/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.ByteSequence;
import com.ibm.disthubmq.impl.formats.SchemaCursor;
import com.ibm.disthubmq.impl.formats.SchemaRegistry;
import com.ibm.disthubmq.impl.formats.TupleCursor;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.mq.jms.BytesMessageImpl;
import com.ibm.mq.jms.JMSInvalidParameterException;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MapMessageImpl;
import com.ibm.mq.jms.MessageConsumerImpl;
import com.ibm.mq.jms.ObjectMessageImpl;
import com.ibm.mq.jms.SerialMessage;
import com.ibm.mq.jms.SessionImpl;
import com.ibm.mq.jms.StreamMessageImpl;
import com.ibm.mq.jms.TextMessageImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;

public class MessageImpl
extends com.ibm.disthubmq.impl.client.MessageImpl
implements Message,
ClientLogConstants,
ClientExceptionConstants,
Serializable {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM 5648-C60(c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MessageImpl.java, jms, j000 02/01/18 14:24:03 @(#) 1.20";
    private static final DebugObject debug = new DebugObject("MessageImpl");
    private static final long serialVersionUID = -4266952183484564154L;
    public static final String CLASS_NONE = "jms_none";
    public static final String CLASS_TEXT = "jms_text";
    public static final String CLASS_OBJECT = "jms_object";
    public static final String CLASS_MAP = "jms_map";
    public static final String CLASS_STREAM = "jms_stream";
    public static final String CLASS_BYTES = "jms_bytes";
    String messageClass = "jms_none";
    private SessionImpl session;
    private MessageConsumerImpl consumer;
    protected boolean readOnly;
    protected boolean propertiesReadOnly;
    long expiration = 0L;
    boolean redelivered = false;
    int deliveryMode = 1;
    Dictionary props;
    String messageId;

    public static MessageImpl construct(SchemaCursor schemaCursor) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "construct", schemaCursor);
        }
        TupleCursor tupleCursor = schemaCursor.getContents().getContents(7);
        TupleCursor tupleCursor2 = tupleCursor.getContents(3);
        MessageImpl messageImpl = null;
        switch (tupleCursor2.getChoice(7)) {
            case 2: {
                messageImpl = new ObjectMessageImpl(schemaCursor, tupleCursor, tupleCursor2);
                break;
            }
            case 3: {
                messageImpl = new BytesMessageImpl(schemaCursor, tupleCursor, tupleCursor2);
                break;
            }
            case 4: {
                messageImpl = new TextMessageImpl(schemaCursor, tupleCursor, tupleCursor2);
                break;
            }
            case 5: {
                messageImpl = new StreamMessageImpl(schemaCursor, tupleCursor, tupleCursor2);
                break;
            }
            case 6: {
                messageImpl = new MapMessageImpl(schemaCursor, tupleCursor, tupleCursor2);
                break;
            }
            default: {
                messageImpl = new MessageImpl(schemaCursor, tupleCursor, tupleCursor2);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "construct", messageImpl);
        }
        return messageImpl;
    }

    public static MessageImpl construct(int n) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "construct", new Integer(n));
        }
        MessageImpl messageImpl = null;
        switch (n) {
            case 2: {
                messageImpl = new ObjectMessageImpl();
                break;
            }
            case 3: {
                messageImpl = new BytesMessageImpl();
                break;
            }
            case 4: {
                messageImpl = new TextMessageImpl();
                break;
            }
            case 5: {
                messageImpl = new StreamMessageImpl();
                break;
            }
            case 6: {
                messageImpl = new MapMessageImpl();
                break;
            }
            default: {
                messageImpl = new MessageImpl();
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "construct", messageImpl);
        }
        return messageImpl;
    }

    MessageImpl duplicate() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "duplicate");
        }
        SchemaCursor schemaCursor = SchemaRegistry.getSchemaCursor(this.cursor.getInterpreterId(), this.cursor.getEncodingSchema().getId());
        ByteSequence byteSequence = new ByteSequence((byte[])this.cursor.getRawMessage().linearize().clone());
        schemaCursor.decode(byteSequence, 0, -1, null);
        MessageImpl messageImpl = MessageImpl.construct(schemaCursor);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "duplicate", messageImpl);
        }
        return messageImpl;
    }

    MessageImpl(SchemaCursor schemaCursor, TupleCursor tupleCursor, TupleCursor tupleCursor2) {
        super(schemaCursor, tupleCursor, tupleCursor2);
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "MessageImpl", schemaCursor, tupleCursor, tupleCursor2);
        }
        this.readOnly = true;
        this.props = this.getProperties();
        this.propertiesReadOnly = true;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "MessageImpl");
        }
    }

    public MessageImpl() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "MessageImpl");
        }
        this.readOnly = false;
        this.propertiesReadOnly = false;
        this.props = new Hashtable();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "MessageImpl");
        }
    }

    void setSession(SessionImpl sessionImpl) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setSession", sessionImpl);
        }
        this.session = sessionImpl;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setSession");
        }
    }

    void setConsumer(MessageConsumerImpl messageConsumerImpl) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setConsumer", messageConsumerImpl);
        }
        this.consumer = messageConsumerImpl;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setConsumer");
        }
    }

    public void setTopic(MQTopic mQTopic) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setTopic", mQTopic);
        }
        String string = mQTopic.getBaseTopicName();
        this.setTopicString(string);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setTopic");
        }
    }

    MessageConsumerImpl getConsumer() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getConsumer");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getConsumer", this.consumer);
        }
        return this.consumer;
    }

    void dispatch() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "dispatch");
        }
        this.consumer.dispatch(this);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "dispatch");
        }
    }

    boolean isFor(MessageConsumer messageConsumer) {
        boolean bl;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "isFor", messageConsumer);
        }
        boolean bl2 = bl = this.consumer == messageConsumer;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "isFor", new Boolean(bl));
        }
        return bl;
    }

    static void validateDeliveryMode(int n) throws JMSInvalidParameterException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "validateDeliveryMode", new Integer(n));
        }
        if (n != 1 && n != 2) {
            String string = "MQJMS1042";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSInvalidParameterException(string2);
        }
        if (n == 2) {
            String string = "MQJMS1010";
            String string3 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string3, string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "validateDeliveryMode");
        }
    }

    static void validatePriority(int n) throws JMSInvalidParameterException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "validatePriority", new Integer(n));
        }
        if (n < 0 || n > 9) {
            throw new JMSInvalidParameterException(ExceptionBuilder.buildReasonString(1096, new Object[]{new Integer(n)}));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "validatePriority");
        }
    }

    public String getJMSMessageID() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getJMSMessageID");
        }
        String string = null;
        if (this.messageId == null) {
            int n;
            string = Long.toHexString(this.getMessageID());
            int n2 = n = string.length();
            while (n2 < 48) {
                string = "0" + string;
                ++n2;
            }
            this.messageId = "ID:" + string;
        }
        if (this.messageId.equals("ID:000000000000000000000000000000000000000000000000")) {
            this.messageId = null;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getJMSMessageID", this.messageId);
        }
        return this.messageId;
    }

    public void setJMSMessageID(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setJMSMessageID", string);
        }
        this.messageId = string;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setJMSMessageID");
        }
    }

    public long getJMSTimestamp() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getJMSTimestamp");
        }
        long l = this.getTimestamp();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getJMSTimestamp", new Long(l));
        }
        return l;
    }

    public void setJMSTimestamp(long l) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setJMSTimestamp", new Long(l));
        }
        this.setTimestamp(l);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setJMSTimestamp");
        }
    }

    public void resetJMSTimestamp() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "resetJMSTimestamp");
        }
        this.setTimestamp(0L);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "resetJMSTimestamp");
        }
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getJMSCorrelationIDAsBytes");
        }
        byte[] byArray = null;
        if (this.getJMSCorrelationID() != null) {
            byArray = this.getJMSCorrelationID().getBytes();
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getJMSCorrelationIDAsBytes");
        }
        return byArray;
    }

    public void setJMSCorrelationIDAsBytes(byte[] byArray) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setJMSCorrelationIDAsBytes", byArray);
        }
        this.setCorrelationID(new String(byArray));
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setJMSCorrelationIDAsBytes");
        }
    }

    public String getJMSCorrelationID() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getJMSCorrelationID");
        }
        String string = this.getCorrelationID();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getJMSCorrelationID", string);
        }
        return string;
    }

    public Destination getJMSReplyTo() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getJMSReplyTo");
        }
        String string = this.getReplyString();
        MQTopic mQTopic = null;
        if (string != null) {
            mQTopic = new MQTopic(string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getJMSReplyTo", mQTopic);
        }
        return mQTopic;
    }

    public void setJMSReplyTo(Destination destination) throws JMSException, InvalidDestinationException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setJMSReplyTo", destination);
        }
        if (destination == null) {
            this.setReplyString(null);
        } else if (destination instanceof MQTopic) {
            this.setReplyString(((MQTopic)destination).toString());
        } else {
            String string = "MQJMS0003";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new InvalidDestinationException(string2, string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setJMSReplyTo");
        }
    }

    public Destination getJMSDestination() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getJMSDestination");
        }
        String string = this.getTopicString();
        MQTopic mQTopic = null;
        if (string != null) {
            mQTopic = new MQTopic(string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getJMSDestination", mQTopic);
        }
        return mQTopic;
    }

    String getJMSDestinationString() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getJMSDestinationString");
        }
        String string = this.getTopicString();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getJMSDestinationString", string);
        }
        return string;
    }

    public void setJMSDestination(Destination destination) throws InvalidDestinationException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setJMSDestination", destination);
        }
        if (!(destination instanceof MQTopic)) {
            String string = "MQJMS0003";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new InvalidDestinationException(string2, string);
        }
        this.setTopicString(((MQTopic)destination).toStringInternal());
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setJMSDestination");
        }
    }

    public int getJMSDeliveryMode() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getJMSDeliveryMode");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getJMSDeliveryMode", new Integer(this.deliveryMode));
        }
        return this.deliveryMode;
    }

    public void setJMSDeliveryMode(int n) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setJMSDeliveryMode", new Integer(n));
        }
        this.deliveryMode = n;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setJMSDeliveryMode");
        }
    }

    public boolean getJMSRedelivered() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getJMSRedelivered");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getJMSRedelivered", new Boolean(this.redelivered));
        }
        return this.redelivered;
    }

    public void setJMSRedelivered(boolean bl) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setJMSRedelivered", new Boolean(bl));
        }
        this.redelivered = bl;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setJMSRedelivered");
        }
    }

    public long getJMSExpiration() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getJMSExpiration");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getJMSExpiration", new Long(this.expiration));
        }
        return this.expiration;
    }

    public void setJMSExpiration(long l) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setJMSExpiration", new Long(l));
        }
        this.expiration = l;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setJMSExpiration");
        }
    }

    public int getJMSPriority() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getJMSPriority");
        }
        int n = this.getPriority();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getJMSPriority", new Integer(n));
        }
        return n;
    }

    public void setJMSPriority(int n) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setJMSPriority", new Integer(n));
        }
        MessageImpl.validatePriority(n);
        this.setPriority(n);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setJMSPriority");
        }
    }

    public void setJMSType(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setJMSType", string);
        }
        if (string != null && string.startsWith("mcd://") && this.messageClass != CLASS_TEXT && this.messageClass != CLASS_BYTES) {
            throw new JMSException(ConfigEnvironment.getErrorMessage("MQJMS1006", "JMSType", string));
        }
        this.setJMSTypeField(string);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setJMSType");
        }
    }

    public String getJMSType() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getJMSType");
        }
        String string = this.getJMSTypeField();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getJMSType");
        }
        return string;
    }

    public void clearProperties() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "clearProperties");
        }
        super.clearProperties();
        this.props = new Hashtable();
        this.propertiesReadOnly = false;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "clearProperties");
        }
    }

    public boolean getBooleanProperty(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getBooleanProperty", string);
        }
        Object v = this.props.get(string);
        Boolean bl = null;
        if (v == null) {
            bl = Boolean.valueOf(null);
        } else if (v instanceof String) {
            bl = Boolean.valueOf((String)v);
        } else if (v instanceof Boolean) {
            bl = (Boolean)v;
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getShortProperty", bl);
        }
        return bl;
    }

    public byte getByteProperty(String string) throws JMSException {
        Byte by;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getByteProperty", string);
        }
        if ((v = this.props.get(string)) == null) {
            by = Byte.valueOf(null);
        } else if (v instanceof String) {
            by = Byte.valueOf((String)v);
        } else if (v instanceof Byte) {
            by = (Byte)v;
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getShortProperty", by);
        }
        return by;
    }

    public short getShortProperty(String string) throws JMSException {
        short s;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getShortProperty", string);
        }
        if ((v = this.props.get(string)) == null) {
            s = Short.valueOf(null);
        } else if (v instanceof String) {
            s = Short.valueOf((String)v);
        } else if (v instanceof Short) {
            s = (Short)v;
        } else if (v instanceof Byte) {
            s = ((Byte)v).byteValue();
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getShortProperty", new Short(s));
        }
        return s;
    }

    public int getIntProperty(String string) throws JMSException {
        int n;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getIntProperty", string);
        }
        if ((v = this.props.get(string)) == null) {
            n = Integer.valueOf(null);
        } else if (v instanceof String) {
            n = Integer.valueOf((String)v);
        } else if (v instanceof Integer) {
            n = (Integer)v;
        } else if (v instanceof Short) {
            n = ((Short)v).shortValue();
        } else if (v instanceof Byte) {
            n = ((Byte)v).byteValue();
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getIntProperty", new Integer(n));
        }
        return n;
    }

    public long getLongProperty(String string) throws JMSException {
        long l;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getLongProperty", string);
        }
        if ((v = this.props.get(string)) == null) {
            l = Long.valueOf(null);
        } else if (v instanceof String) {
            l = Long.valueOf((String)v);
        } else if (v instanceof Long) {
            l = (Long)v;
        } else if (v instanceof Integer) {
            l = ((Integer)v).intValue();
        } else if (v instanceof Short) {
            l = ((Short)v).shortValue();
        } else if (v instanceof Byte) {
            l = ((Byte)v).byteValue();
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getLongProperty", new Long(l));
        }
        return l;
    }

    public float getFloatProperty(String string) throws JMSException {
        Float f;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getFloatProperty", string);
        }
        if ((v = this.props.get(string)) == null) {
            f = Float.valueOf(null);
        } else if (v instanceof String) {
            f = Float.valueOf((String)v);
        } else if (v instanceof Float) {
            f = (Float)v;
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getFloatProperty", f);
        }
        return f.floatValue();
    }

    public double getDoubleProperty(String string) throws JMSException {
        Double d;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getDoubleProperty", string);
        }
        if ((v = this.props.get(string)) == null) {
            d = Double.valueOf(null);
        } else if (v instanceof String) {
            d = Double.valueOf((String)v);
        } else if (v instanceof Double) {
            d = (Double)v;
        } else if (v instanceof Float) {
            d = new Double(((Float)v).doubleValue());
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getDoubleProperty", d);
        }
        return d;
    }

    public String getStringProperty(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getStringProperty", string);
        }
        Object v = this.props.get(string);
        String string2 = null;
        if (v != null) {
            string2 = v.toString();
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getStringProperty", string2);
        }
        return string2;
    }

    public Object getObjectProperty(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getObjectProperty", string);
        }
        Object v = this.props.get(string);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getObjectProperty", v);
        }
        return v;
    }

    public Enumeration getPropertyNames() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getPropertyNames");
        }
        Enumeration enumeration = this.props.keys();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getPropertyNames", enumeration);
        }
        return enumeration;
    }

    public void setBooleanProperty(String string, boolean bl) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setBooleanProperty", string, new Boolean(bl));
        }
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        this.props.put(string, new Boolean(bl));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setBooleanProperty");
        }
    }

    public void setByteProperty(String string, byte by) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setByteProperty", string, new Byte(by));
        }
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        this.props.put(string, new Byte(by));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setByteProperty");
        }
    }

    public void setShortProperty(String string, short s) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setShortProperty", string, new Short(s));
        }
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        this.props.put(string, new Short(s));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setShortProperty");
        }
    }

    public void setIntProperty(String string, int n) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setIntProperty", string, new Integer(n));
        }
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        this.props.put(string, new Integer(n));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setIntProperty");
        }
    }

    public void setLongProperty(String string, long l) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setLongProperty", string, new Long(l));
        }
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        this.props.put(string, new Long(l));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setLongProperty");
        }
    }

    public void setFloatProperty(String string, float f) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setFloatProperty", string, new Float(f));
        }
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        this.props.put(string, new Float(f));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setFloatProperty");
        }
    }

    public void setDoubleProperty(String string, double d) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setDoubleProperty", string, new Double(d));
        }
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        this.props.put(string, new Double(d));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setDoubleProperty");
        }
    }

    public void setStringProperty(String string, String string2) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setStringProperty", string, string2);
        }
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        if (string2 != null) {
            this.props.put(string, string2);
        } else {
            this.props.remove(string);
        }
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setStringProperty");
        }
    }

    public void setObjectProperty(String string, Object object) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setObjectProperty", string, object);
        }
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        if (object instanceof String || object instanceof Integer || object instanceof Boolean || object instanceof Short || object instanceof Long || object instanceof Byte || object instanceof Double || object instanceof Float) {
            this.props.put(string, object);
        } else if (object == null) {
            this.props.remove(string);
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setObjectProperty");
        }
    }

    public void acknowledge() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "acknowledge");
        }
        if (this.session != null && !this.session.getTransacted() && this.session.getAcknowledgeMode() != 1 && this.session.getAcknowledgeMode() != 3) {
            String string = "MQJMS1010";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string2, string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "acknowledge");
        }
    }

    public void clearBody() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "clearBody");
        }
        this.readOnly = false;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "clearBudy");
        }
    }

    public void setJMSCorrelationID(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setJMSCorrelationID", string);
        }
        if (string != null) {
            if (string.startsWith("ID:")) {
                try {
                    byte[] byArray = this.hexToBin(string, 3);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
            this.setCorrelationID(string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setJMSCorrelationID");
        }
    }

    public boolean propertyExists(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "propertyExists", string);
        }
        boolean bl = ((Hashtable)this.props).containsKey(string);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "propertyExists", new Boolean(bl));
        }
        return bl;
    }

    public int length() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "length");
        }
        ByteSequence byteSequence = this.cursor.getRawMessage();
        int n = 0;
        if (byteSequence != null) {
            n = byteSequence.length;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "length", new Integer(n));
        }
        return n;
    }

    public Object writeReplace() {
        return new SerialMessage(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("\nJMS Message class: " + this.messageClass);
            stringBuffer.append("\n  JMSDeliveryMode: " + this.getJMSDeliveryMode());
            stringBuffer.append("\n  JMSExpiration:   " + this.getJMSExpiration());
            stringBuffer.append("\n  JMSPriority:     " + this.getJMSPriority());
            stringBuffer.append("\n  JMSMessageID:    " + this.getJMSMessageID());
            stringBuffer.append("\n  JMSTimestamp:    " + this.getJMSTimestamp());
            stringBuffer.append("\n  JMSCorrelationID:" + this.getJMSCorrelationID());
            stringBuffer.append("\n  JMSDestination:  " + this.getJMSDestination());
            stringBuffer.append("\n  JMSReplyTo:      " + this.getJMSReplyTo());
            stringBuffer.append("\n  JMSRedelivered:  " + this.getJMSRedelivered());
            Enumeration enumeration = this.getPropertyNames();
            int n = 999;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append("\n  " + string + ":" + this.getObjectProperty(string));
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    byte[] hexToBin(String string, int n) throws JMSException {
        int n2 = string.length() - n;
        if (n2 == 0) {
            return new byte[0];
        }
        if (n2 < 0 || n2 % 2 != 0) {
            throw new JMSInvalidParameterException(ExceptionBuilder.buildReasonString(1097, new Object[]{new String(string)}));
        }
        byte[] byArray = new byte[n2 /= 2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = Character.digit(string.charAt(2 * n3 + n), 16) << 4;
            int n5 = Character.digit(string.charAt(2 * n3 + n + 1), 16);
            if (n4 < 0 || n5 < 0) {
                throw new JMSInvalidParameterException(ExceptionBuilder.buildReasonString(1097, new Object[]{new String(string)}));
            }
            byArray[n3] = (byte)(n4 + n5);
            ++n3;
        }
        return byArray;
    }
}

